<?php

namespace Shop\Infrastructure\Models\ShopPositionSizeType\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\ShopPositionSize\ShopPositionSize;
use Shop\Infrastructure\Models\ShopPositionSizeType\ShopPositionSizeType as ChildShopPositionSizeType;
use Shop\Infrastructure\Models\ShopPositionSizeType\ShopPositionSizeTypeQuery as ChildShopPositionSizeTypeQuery;
use Shop\Infrastructure\Models\ShopPositionSizeType\Map\ShopPositionSizeTypeTableMap;

/**
 * Base class that represents a query for the 'shop_position_size_types' table.
 *
 *
 *
 * @method     ChildShopPositionSizeTypeQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildShopPositionSizeTypeQuery orderByname($order = Criteria::ASC) Order by the name column
 * @method     ChildShopPositionSizeTypeQuery orderByType($order = Criteria::ASC) Order by the type column
 *
 * @method     ChildShopPositionSizeTypeQuery groupById() Group by the id column
 * @method     ChildShopPositionSizeTypeQuery groupByname() Group by the name column
 * @method     ChildShopPositionSizeTypeQuery groupByType() Group by the type column
 *
 * @method     ChildShopPositionSizeTypeQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildShopPositionSizeTypeQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildShopPositionSizeTypeQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildShopPositionSizeTypeQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildShopPositionSizeTypeQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildShopPositionSizeTypeQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildShopPositionSizeTypeQuery leftJoinShopPositionSize($relationAlias = null) Adds a LEFT JOIN clause to the query using the ShopPositionSize relation
 * @method     ChildShopPositionSizeTypeQuery rightJoinShopPositionSize($relationAlias = null) Adds a RIGHT JOIN clause to the query using the ShopPositionSize relation
 * @method     ChildShopPositionSizeTypeQuery innerJoinShopPositionSize($relationAlias = null) Adds a INNER JOIN clause to the query using the ShopPositionSize relation
 *
 * @method     ChildShopPositionSizeTypeQuery joinWithShopPositionSize($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the ShopPositionSize relation
 *
 * @method     ChildShopPositionSizeTypeQuery leftJoinWithShopPositionSize() Adds a LEFT JOIN clause and with to the query using the ShopPositionSize relation
 * @method     ChildShopPositionSizeTypeQuery rightJoinWithShopPositionSize() Adds a RIGHT JOIN clause and with to the query using the ShopPositionSize relation
 * @method     ChildShopPositionSizeTypeQuery innerJoinWithShopPositionSize() Adds a INNER JOIN clause and with to the query using the ShopPositionSize relation
 *
 * @method     \Shop\Infrastructure\Models\ShopPositionSize\ShopPositionSizeQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildShopPositionSizeType findOne(ConnectionInterface $con = null) Return the first ChildShopPositionSizeType matching the query
 * @method     ChildShopPositionSizeType findOneOrCreate(ConnectionInterface $con = null) Return the first ChildShopPositionSizeType matching the query, or a new ChildShopPositionSizeType object populated from the query conditions when no match is found
 *
 * @method     ChildShopPositionSizeType findOneById(int $id) Return the first ChildShopPositionSizeType filtered by the id column
 * @method     ChildShopPositionSizeType findOneByname(string $name) Return the first ChildShopPositionSizeType filtered by the name column
 * @method     ChildShopPositionSizeType findOneByType(string $type) Return the first ChildShopPositionSizeType filtered by the type column *

 * @method     ChildShopPositionSizeType requirePk($key, ConnectionInterface $con = null) Return the ChildShopPositionSizeType by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopPositionSizeType requireOne(ConnectionInterface $con = null) Return the first ChildShopPositionSizeType matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildShopPositionSizeType requireOneById(int $id) Return the first ChildShopPositionSizeType filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopPositionSizeType requireOneByname(string $name) Return the first ChildShopPositionSizeType filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopPositionSizeType requireOneByType(string $type) Return the first ChildShopPositionSizeType filtered by the type column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildShopPositionSizeType[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildShopPositionSizeType objects based on current ModelCriteria
 * @method     ChildShopPositionSizeType[]|ObjectCollection findById(int $id) Return ChildShopPositionSizeType objects filtered by the id column
 * @method     ChildShopPositionSizeType[]|ObjectCollection findByname(string $name) Return ChildShopPositionSizeType objects filtered by the name column
 * @method     ChildShopPositionSizeType[]|ObjectCollection findByType(string $type) Return ChildShopPositionSizeType objects filtered by the type column
 * @method     ChildShopPositionSizeType[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ShopPositionSizeTypeQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\ShopPositionSizeType\Base\ShopPositionSizeTypeQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\ShopPositionSizeType\\ShopPositionSizeType', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildShopPositionSizeTypeQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildShopPositionSizeTypeQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildShopPositionSizeTypeQuery) {
            return $criteria;
        }
        $query = new ChildShopPositionSizeTypeQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildShopPositionSizeType|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ShopPositionSizeTypeTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ShopPositionSizeTypeTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildShopPositionSizeType A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `name`, `type` FROM `shop_position_size_types` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildShopPositionSizeType $obj */
            $obj = new ChildShopPositionSizeType();
            $obj->hydrate($row);
            ShopPositionSizeTypeTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildShopPositionSizeType|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildShopPositionSizeTypeQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ShopPositionSizeTypeTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildShopPositionSizeTypeQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ShopPositionSizeTypeTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopPositionSizeTypeQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(ShopPositionSizeTypeTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(ShopPositionSizeTypeTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopPositionSizeTypeTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByname('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByname('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopPositionSizeTypeQuery The current query, for fluid interface
     */
    public function filterByname($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopPositionSizeTypeTableMap::COL_NAME, $name, $comparison);
    }

    /**
     * Filter the query on the type column
     *
     * Example usage:
     * <code>
     * $query->filterByType('fooValue');   // WHERE type = 'fooValue'
     * $query->filterByType('%fooValue%', Criteria::LIKE); // WHERE type LIKE '%fooValue%'
     * </code>
     *
     * @param     string $type The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopPositionSizeTypeQuery The current query, for fluid interface
     */
    public function filterByType($type = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($type)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopPositionSizeTypeTableMap::COL_TYPE, $type, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\ShopPositionSize\ShopPositionSize object
     *
     * @param \Shop\Infrastructure\Models\ShopPositionSize\ShopPositionSize|ObjectCollection $shopPositionSize the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildShopPositionSizeTypeQuery The current query, for fluid interface
     */
    public function filterByShopPositionSize($shopPositionSize, $comparison = null)
    {
        if ($shopPositionSize instanceof \Shop\Infrastructure\Models\ShopPositionSize\ShopPositionSize) {
            return $this
                ->addUsingAlias(ShopPositionSizeTypeTableMap::COL_ID, $shopPositionSize->getSizeTypeId(), $comparison);
        } elseif ($shopPositionSize instanceof ObjectCollection) {
            return $this
                ->useShopPositionSizeQuery()
                ->filterByPrimaryKeys($shopPositionSize->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByShopPositionSize() only accepts arguments of type \Shop\Infrastructure\Models\ShopPositionSize\ShopPositionSize or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the ShopPositionSize relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildShopPositionSizeTypeQuery The current query, for fluid interface
     */
    public function joinShopPositionSize($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('ShopPositionSize');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'ShopPositionSize');
        }

        return $this;
    }

    /**
     * Use the ShopPositionSize relation ShopPositionSize object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\ShopPositionSize\ShopPositionSizeQuery A secondary query class using the current class as primary query
     */
    public function useShopPositionSizeQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinShopPositionSize($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'ShopPositionSize', '\Shop\Infrastructure\Models\ShopPositionSize\ShopPositionSizeQuery');
    }

    /**
     * Filter the query by a related Position object
     * using the shop_position_sizes table as cross reference
     *
     * @param Position $position the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildShopPositionSizeTypeQuery The current query, for fluid interface
     */
    public function filterByPosition($position, $comparison = Criteria::EQUAL)
    {
        return $this
            ->useShopPositionSizeQuery()
            ->filterByPosition($position, $comparison)
            ->endUse();
    }

    /**
     * Exclude object from result
     *
     * @param   ChildShopPositionSizeType $shopPositionSizeType Object to remove from the list of results
     *
     * @return $this|ChildShopPositionSizeTypeQuery The current query, for fluid interface
     */
    public function prune($shopPositionSizeType = null)
    {
        if ($shopPositionSizeType) {
            $this->addUsingAlias(ShopPositionSizeTypeTableMap::COL_ID, $shopPositionSizeType->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_position_size_types table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopPositionSizeTypeTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ShopPositionSizeTypeTableMap::clearInstancePool();
            ShopPositionSizeTypeTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopPositionSizeTypeTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ShopPositionSizeTypeTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ShopPositionSizeTypeTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ShopPositionSizeTypeTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // ShopPositionSizeTypeQuery
