<?php

namespace Shop\Infrastructure\Models\Position;

use Shop\Domain\PricePosition\Contracts\PricePositionEntityInterface;
use Shop\Infrastructure\Models\Position\Base\Position as BasePosition;

/**
 * Skeleton subclass for representing a row from the 'shop_positions' table.
 *
 *
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 */
class Position extends BasePosition implements PricePositionEntityInterface
{

    /**
     * @return float
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getPriceFinal()
    {
        $complex_rate = $this->getVirtualColumn("rate");
        return ceil($this->getPrice() * ($complex_rate/100+1));
    }

    /**
     * @return float
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function getPriceOldFinal()
    {
        $complex_rate = $this->getVirtualColumn("rate");
        $old =  ceil($this->getPriceOld() * ($complex_rate/100+1));
        
        return $old < $this->getPriceFinal() ? $this->getPriceFinal() : $old;
    }

    /**
     * Получение реальных размеров
     * @return type
     */
    public function getRealSizes():string
    {
        $desc = "";
        $sizes = $this->getShopPositionSizeTypeValues();
        foreach ($sizes as $size) {
            $desc .= sprintf("%s: %s; ", $size[0]->getName(), $size[1]);
        }
        return rtrim($desc, "; ");
    }


}