<?php

namespace Shop\Infrastructure\Models\FastLink\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Infrastructure\Models\Customer\Customer;
use Shop\Infrastructure\Models\FastLink\FastLink as ChildFastLink;
use Shop\Infrastructure\Models\FastLink\FastLinkQuery as ChildFastLinkQuery;
use Shop\Infrastructure\Models\FastLink\Map\FastLinkTableMap;

/**
 * Base class that represents a query for the 'shop_fastlinks' table.
 *
 *
 *
 * @method     ChildFastLinkQuery orderByCode($order = Criteria::ASC) Order by the code column
 * @method     ChildFastLinkQuery orderByDatetime($order = Criteria::ASC) Order by the datetime column
 * @method     ChildFastLinkQuery orderByData($order = Criteria::ASC) Order by the data column
 * @method     ChildFastLinkQuery orderByOwnerCustomerId($order = Criteria::ASC) Order by the owner_customer_id column
 *
 * @method     ChildFastLinkQuery groupByCode() Group by the code column
 * @method     ChildFastLinkQuery groupByDatetime() Group by the datetime column
 * @method     ChildFastLinkQuery groupByData() Group by the data column
 * @method     ChildFastLinkQuery groupByOwnerCustomerId() Group by the owner_customer_id column
 *
 * @method     ChildFastLinkQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildFastLinkQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildFastLinkQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildFastLinkQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildFastLinkQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildFastLinkQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildFastLinkQuery leftJoinOwnerCustomer($relationAlias = null) Adds a LEFT JOIN clause to the query using the OwnerCustomer relation
 * @method     ChildFastLinkQuery rightJoinOwnerCustomer($relationAlias = null) Adds a RIGHT JOIN clause to the query using the OwnerCustomer relation
 * @method     ChildFastLinkQuery innerJoinOwnerCustomer($relationAlias = null) Adds a INNER JOIN clause to the query using the OwnerCustomer relation
 *
 * @method     ChildFastLinkQuery joinWithOwnerCustomer($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the OwnerCustomer relation
 *
 * @method     ChildFastLinkQuery leftJoinWithOwnerCustomer() Adds a LEFT JOIN clause and with to the query using the OwnerCustomer relation
 * @method     ChildFastLinkQuery rightJoinWithOwnerCustomer() Adds a RIGHT JOIN clause and with to the query using the OwnerCustomer relation
 * @method     ChildFastLinkQuery innerJoinWithOwnerCustomer() Adds a INNER JOIN clause and with to the query using the OwnerCustomer relation
 *
 * @method     ChildFastLinkQuery leftJoinCustomer($relationAlias = null) Adds a LEFT JOIN clause to the query using the Customer relation
 * @method     ChildFastLinkQuery rightJoinCustomer($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Customer relation
 * @method     ChildFastLinkQuery innerJoinCustomer($relationAlias = null) Adds a INNER JOIN clause to the query using the Customer relation
 *
 * @method     ChildFastLinkQuery joinWithCustomer($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Customer relation
 *
 * @method     ChildFastLinkQuery leftJoinWithCustomer() Adds a LEFT JOIN clause and with to the query using the Customer relation
 * @method     ChildFastLinkQuery rightJoinWithCustomer() Adds a RIGHT JOIN clause and with to the query using the Customer relation
 * @method     ChildFastLinkQuery innerJoinWithCustomer() Adds a INNER JOIN clause and with to the query using the Customer relation
 *
 * @method     \Shop\Infrastructure\Models\Customer\CustomerQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildFastLink findOne(ConnectionInterface $con = null) Return the first ChildFastLink matching the query
 * @method     ChildFastLink findOneOrCreate(ConnectionInterface $con = null) Return the first ChildFastLink matching the query, or a new ChildFastLink object populated from the query conditions when no match is found
 *
 * @method     ChildFastLink findOneByCode(string $code) Return the first ChildFastLink filtered by the code column
 * @method     ChildFastLink findOneByDatetime(string $datetime) Return the first ChildFastLink filtered by the datetime column
 * @method     ChildFastLink findOneByData(string $data) Return the first ChildFastLink filtered by the data column
 * @method     ChildFastLink findOneByOwnerCustomerId(int $owner_customer_id) Return the first ChildFastLink filtered by the owner_customer_id column *

 * @method     ChildFastLink requirePk($key, ConnectionInterface $con = null) Return the ChildFastLink by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildFastLink requireOne(ConnectionInterface $con = null) Return the first ChildFastLink matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildFastLink requireOneByCode(string $code) Return the first ChildFastLink filtered by the code column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildFastLink requireOneByDatetime(string $datetime) Return the first ChildFastLink filtered by the datetime column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildFastLink requireOneByData(string $data) Return the first ChildFastLink filtered by the data column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildFastLink requireOneByOwnerCustomerId(int $owner_customer_id) Return the first ChildFastLink filtered by the owner_customer_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildFastLink[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildFastLink objects based on current ModelCriteria
 * @method     ChildFastLink[]|ObjectCollection findByCode(string $code) Return ChildFastLink objects filtered by the code column
 * @method     ChildFastLink[]|ObjectCollection findByDatetime(string $datetime) Return ChildFastLink objects filtered by the datetime column
 * @method     ChildFastLink[]|ObjectCollection findByData(string $data) Return ChildFastLink objects filtered by the data column
 * @method     ChildFastLink[]|ObjectCollection findByOwnerCustomerId(int $owner_customer_id) Return ChildFastLink objects filtered by the owner_customer_id column
 * @method     ChildFastLink[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class FastLinkQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Infrastructure\Models\FastLink\Base\FastLinkQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\FastLink\\FastLink', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildFastLinkQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildFastLinkQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildFastLinkQuery) {
            return $criteria;
        }
        $query = new ChildFastLinkQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildFastLink|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(FastLinkTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = FastLinkTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildFastLink A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `code`, `datetime`, `data`, `owner_customer_id` FROM `shop_fastlinks` WHERE `code` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_STR);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildFastLink $obj */
            $obj = new ChildFastLink();
            $obj->hydrate($row);
            FastLinkTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildFastLink|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildFastLinkQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(FastLinkTableMap::COL_CODE, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildFastLinkQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(FastLinkTableMap::COL_CODE, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the code column
     *
     * Example usage:
     * <code>
     * $query->filterByCode('fooValue');   // WHERE code = 'fooValue'
     * $query->filterByCode('%fooValue%', Criteria::LIKE); // WHERE code LIKE '%fooValue%'
     * </code>
     *
     * @param     string $code The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildFastLinkQuery The current query, for fluid interface
     */
    public function filterByCode($code = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($code)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(FastLinkTableMap::COL_CODE, $code, $comparison);
    }

    /**
     * Filter the query on the datetime column
     *
     * Example usage:
     * <code>
     * $query->filterByDatetime('2011-03-14'); // WHERE datetime = '2011-03-14'
     * $query->filterByDatetime('now'); // WHERE datetime = '2011-03-14'
     * $query->filterByDatetime(array('max' => 'yesterday')); // WHERE datetime > '2011-03-13'
     * </code>
     *
     * @param     mixed $datetime The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildFastLinkQuery The current query, for fluid interface
     */
    public function filterByDatetime($datetime = null, $comparison = null)
    {
        if (is_array($datetime)) {
            $useMinMax = false;
            if (isset($datetime['min'])) {
                $this->addUsingAlias(FastLinkTableMap::COL_DATETIME, $datetime['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($datetime['max'])) {
                $this->addUsingAlias(FastLinkTableMap::COL_DATETIME, $datetime['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(FastLinkTableMap::COL_DATETIME, $datetime, $comparison);
    }

    /**
     * Filter the query on the data column
     *
     * Example usage:
     * <code>
     * $query->filterByData('fooValue');   // WHERE data = 'fooValue'
     * $query->filterByData('%fooValue%', Criteria::LIKE); // WHERE data LIKE '%fooValue%'
     * </code>
     *
     * @param     string $data The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildFastLinkQuery The current query, for fluid interface
     */
    public function filterByData($data = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($data)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(FastLinkTableMap::COL_DATA, $data, $comparison);
    }

    /**
     * Filter the query on the owner_customer_id column
     *
     * Example usage:
     * <code>
     * $query->filterByOwnerCustomerId(1234); // WHERE owner_customer_id = 1234
     * $query->filterByOwnerCustomerId(array(12, 34)); // WHERE owner_customer_id IN (12, 34)
     * $query->filterByOwnerCustomerId(array('min' => 12)); // WHERE owner_customer_id > 12
     * </code>
     *
     * @see       filterByOwnerCustomer()
     *
     * @param     mixed $ownerCustomerId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildFastLinkQuery The current query, for fluid interface
     */
    public function filterByOwnerCustomerId($ownerCustomerId = null, $comparison = null)
    {
        if (is_array($ownerCustomerId)) {
            $useMinMax = false;
            if (isset($ownerCustomerId['min'])) {
                $this->addUsingAlias(FastLinkTableMap::COL_OWNER_CUSTOMER_ID, $ownerCustomerId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($ownerCustomerId['max'])) {
                $this->addUsingAlias(FastLinkTableMap::COL_OWNER_CUSTOMER_ID, $ownerCustomerId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(FastLinkTableMap::COL_OWNER_CUSTOMER_ID, $ownerCustomerId, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Customer\Customer object
     *
     * @param \Shop\Infrastructure\Models\Customer\Customer|ObjectCollection $customer The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildFastLinkQuery The current query, for fluid interface
     */
    public function filterByOwnerCustomer($customer, $comparison = null)
    {
        if ($customer instanceof \Shop\Infrastructure\Models\Customer\Customer) {
            return $this
                ->addUsingAlias(FastLinkTableMap::COL_OWNER_CUSTOMER_ID, $customer->getId(), $comparison);
        } elseif ($customer instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(FastLinkTableMap::COL_OWNER_CUSTOMER_ID, $customer->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByOwnerCustomer() only accepts arguments of type \Shop\Infrastructure\Models\Customer\Customer or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the OwnerCustomer relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildFastLinkQuery The current query, for fluid interface
     */
    public function joinOwnerCustomer($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('OwnerCustomer');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'OwnerCustomer');
        }

        return $this;
    }

    /**
     * Use the OwnerCustomer relation Customer object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Customer\CustomerQuery A secondary query class using the current class as primary query
     */
    public function useOwnerCustomerQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinOwnerCustomer($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'OwnerCustomer', '\Shop\Infrastructure\Models\Customer\CustomerQuery');
    }

    /**
     * Filter the query by a related \Shop\Infrastructure\Models\Customer\Customer object
     *
     * @param \Shop\Infrastructure\Models\Customer\Customer|ObjectCollection $customer The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildFastLinkQuery The current query, for fluid interface
     */
    public function filterByCustomer($customer, $comparison = null)
    {
        if ($customer instanceof \Shop\Infrastructure\Models\Customer\Customer) {
            return $this
                ->addUsingAlias(FastLinkTableMap::COL_CODE, $customer->getPassword(), $comparison);
        } elseif ($customer instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(FastLinkTableMap::COL_CODE, $customer->toKeyValue('PrimaryKey', 'Password'), $comparison);
        } else {
            throw new PropelException('filterByCustomer() only accepts arguments of type \Shop\Infrastructure\Models\Customer\Customer or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Customer relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildFastLinkQuery The current query, for fluid interface
     */
    public function joinCustomer($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Customer');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Customer');
        }

        return $this;
    }

    /**
     * Use the Customer relation Customer object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Infrastructure\Models\Customer\CustomerQuery A secondary query class using the current class as primary query
     */
    public function useCustomerQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCustomer($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Customer', '\Shop\Infrastructure\Models\Customer\CustomerQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildFastLink $fastLink Object to remove from the list of results
     *
     * @return $this|ChildFastLinkQuery The current query, for fluid interface
     */
    public function prune($fastLink = null)
    {
        if ($fastLink) {
            $this->addUsingAlias(FastLinkTableMap::COL_CODE, $fastLink->getCode(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_fastlinks table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(FastLinkTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            FastLinkTableMap::clearInstancePool();
            FastLinkTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(FastLinkTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(FastLinkTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            FastLinkTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            FastLinkTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // FastLinkQuery
