<?php

namespace Shop\Domain\Customer;


use Core\Repository\DropDownInterface;
use Repo\Concrete\AbstractCollection;
use Shop\Domain\Customer\Contracts\CustomerEntityInterface;

class CustomerCollection extends AbstractCollection implements DropDownInterface
{
    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return CustomerEntityInterface::class;
    }
    
    public function getDropdownList(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity){
            $ar[$entity->getId()] = $entity->getName();
        }

        return $ar;
    }
}