<?php


namespace Shop\Application\Mailing;


use Core\MailingPreparation\MailingCook;
use Diamond\Domain\MailingList\Concrete\MailingListEntityInterface;
use Diamond\Repositories\MailingList\MailingListRepository;
use Diamond\Repositories\MailingSubscriber\MailingSubscriberRepository;
use Diamond\Repositories\MailingTemplate\MailingTemplateRepository;
use Shop\Application\Office\OfficeService;

/**
 * Class MailingService
 * @package Shop\Application\Mailing
 */
class MailingService extends \Diamond\Application\Mailing\MailingService
{
    protected $officeService;

    public function __construct(MailingListRepository $mailingListRepository,
                                MailingSubscriberRepository $mailingSubscriberRepository,
                                MailingTemplateRepository $mailingTemplateRepository,
                                MailingCook $mailingCook,
                                OfficeService $officeService)
    {
        parent::__construct($mailingListRepository, $mailingSubscriberRepository, $mailingTemplateRepository, $mailingCook);
        $this->officeService = $officeService;
    }


    /**
     * @todo нужна работа драйвеов по получению подписчиков
     * @param MailingListEntityInterface $mailingListEntity
     * @return array
     * @throws \Repo\Concrete\Exceptions\Collection
     */
    public function getSubscribeEmails(MailingListEntityInterface $mailingListEntity): array
    {
        $_emails = [];

        $sub = $mailingListEntity->getMailingSubscriber();

        switch ($sub->getFn()) {
            case 'custom':

                $_emails = explode(';', $sub->getCustomMails());

                break;

            case 'allClients':

                $_emails = $this->officeService->getEmailsAll();

                break;

            case 'blockClients':

                $_emails = $this->officeService->getEmailsblockClients();

                break;

            case 'noneAuthClients':

                $_emails = $this->officeService->getEmailsNoneAuthClients();

                break;

            case 'AuthClients':

                $_emails = $this->officeService->getEmailsAuthClients();

                break;
            case 'group3ClientsOffice1':

                $_emails = $this->officeService->getEmailsgroup3ClientsOffice1();

                break;

        }

        $_ignore = explode(';', $sub->getIgnoreMails());

        return \array_diff($_emails, $_ignore);
    }

}