<?php

namespace Shop\Config;

/**
 * Конфиг магазина
 *
 * @author Admin
 */
class Main extends \Core\IniConfig
{

    /**
     * @var int
     */
    protected $defaultContractorGroup; //for new registrated client
    /**
     * @var int
     */
    protected $default_customer_category; //for new registrated client
    /**
     * @var int
     */
    protected $defaultGuestGroup; //for guest from fast links

    /**
     * @var string
     */
    protected $googleMapApiKey; //api key
    /**
     * @var int
     */
    protected $daysNewGoods; //new products days
    /**
     * @deprecated
     * @var string
     */
    protected $curencyDisplay = "руб"; //currency full
    /**
     * @deprecated
     * @var string
     */
    protected $curencyDisplayShort = "р."; //currency short
    protected $defaultCity = 1339; //def city
    protected $defaultRegion; //def region
    protected $managerEmail = "manager@mail.ru";

    /**
     * @var int
     */
    protected $defaultCurrency = 1;

    /**
     * @var int
     */
    protected $stateProviderDefault = 1;//state default provider
    /**
     * @var int
     */
    protected $stateDefault = 1; //state new order
    /**
     * @var int
     */
    protected $statePayment = 1; //state payment order
    /**
     * @var int
     */
    protected $stateCancel = 1; //state cancel? for ignore calculate

    /**
     * @var int
     */
    protected $stateProviderSend = 1; //state payment order

    /**
     * @var int|null
     */
    protected $defaultBrandId;
    /**
     * @var int|null
     */
    protected $defaultCategoryId;
    
    public const MODE_CHANGE_STATE_SINHLY = 1;
    public const MODE_CHANGE_STATE_FROM_ORDER = 2;
    public const MODE_CHANGE_STATE_FROM_POSITION = 3;

    /**
     * Режим смены состояний заказа
     * @var int
     */
    protected $modeChangeOrderStates = 1;



    protected $mobileMask = '(+7) 999-999-9999'; //phone mask
    protected $fakePersent; //fake persent
    protected $minOrderSumm; //min summ for order
    protected $russianPostUrl; //link for see post state
    protected $imagesServer = 'https://img.site.ru'; //image server
    protected $paginationRows = [15, 30, 60, 120]; //pagination rows
    protected $thumbPath = '/image/product/resize/'; //путь к миниэскизам на сервере изображений
    protected $stockImagePath = '/assets/upload/shops/'; //каталог сайта для изображений точек
    /**
     * @var string
     */
    protected $productImagePath = '/upload/products/';

    protected $customersBlockedInterval = 360; //customer limit for blocked
    protected $orderScoreSumm = 0; //с какой суммы начислять баллы
    protected $orderScoreVolume; //кол-во начисляемых балов    
    protected $orderScoreConvertPrice = 1;//кол-во начисляемых денег за 1 балл
    protected $orderDiscountIgnoreCustomerGroups = [];


    //МойСклад
    protected $moyskladSyncOrders = 'N';

    /**
     * @var string|null
     */
    protected $moyskladLogin;
    /**
     * @var string|null
     */
    protected $moyskladPassword;
    /**
     * @var int|null
     */
    protected $moyskladOrderStateId;

    /**
     * @var int|null
     */
    protected $moyskladOrderStateSucessId;

    /**
     * @var string|null
     */
    protected $moyskladRemoteStock;

    /**
     * @var array|null
     */
    protected $moyskladSyncStockIds;

    //Bitrix24
    protected $bitrixSyncOrders = 'N';
    //адрес сервиса битрикса
    protected $bitrixUrl='';
    //пользовать учетки
    protected $bitrixUserID='';
    //уникальный ид хука
    protected $bitrixWebHook='';
    //на кого назначать заказы
    protected $bitrixAssignedById='';

    /**
     * @var array|null
     */
    protected $bitrixSyncStockIds;

    /**
     * @var int|null
     */
    protected $bitrixOrderStateId;

    /**
     * @var int|null
     */
    protected $bitrixOrderStateSuсcessId;

    /**
     * @return int|null
     */
    public function getDefaultBrandId(): ?int
    {
        return $this->defaultBrandId;
    }

    /**
     * @return int|null
     */
    public function getDefaultCategoryId(): ?int
    {
        return $this->defaultCategoryId;
    }

    /**
     * @return array|null
     */
    public function getBitrixSyncStockIds(): ?array
    {
        return $this->bitrixSyncStockIds;
    }

    /**
     * @return int|null
     */
    public function getBitrixOrderStateId(): ?int
    {
        return $this->bitrixOrderStateId;
    }

    /**
     * @return int|null
     */
    public function getBitrixOrderStateSuсcessId(): ?int
    {
        return $this->bitrixOrderStateSuсcessId;
    }


    /**
     * @return string
     */
    public function getBitrixSyncOrders(): string
    {
        return $this->bitrixSyncOrders;
    }

    /**
     * @return string
     */
    public function getBitrixUrl(): string
    {
        return $this->bitrixUrl;
    }

    /**
     * @return string
     */
    public function getBitrixUserID(): string
    {
        return $this->bitrixUserID;
    }

    /**
     * @return string
     */
    public function getBitrixWebHook(): string
    {
        return $this->bitrixWebHook;
    }

    /**
     * @return string
     */
    public function getBitrixAssignedById(): string
    {
        return $this->bitrixAssignedById;
    }




    /**
     * @return bool
     */
    public function getMoyskladSyncOrders(): string
    {
        return $this->moyskladSyncOrders;
    }


    /**
     * @return array|null
     */
    public function getMoyskladSyncStockIds(): ?array
    {
        return $this->moyskladSyncStockIds;
    }

    /**
     * @return int
     */
    public function getModeChangeOrderStates(): int
    {
        return $this->modeChangeOrderStates;
    }


    /**
     * @return string|null
     */
    public function getMoyskladRemoteStock(): ?string
    {
        return $this->moyskladRemoteStock;
    }


    /**
     * @return string|null
     */
    public function getMoyskladLogin(): ?string
    {
        return $this->moyskladLogin;
    }

    /**
     * @return string|null
     */
    public function getMoyskladPassword(): ?string
    {
        return $this->moyskladPassword;
    }

    /**
     * @return int|null
     */
    public function getMoyskladOrderStateId(): ?int
    {
        return $this->moyskladOrderStateId > 0 ? (int)$this->moyskladOrderStateId : null;
    }

    /**
     * @return int|null
     */
    public function getMoyskladOrderStateSucessId(): ?int
    {
        return $this->moyskladOrderStateSucessId > 0 ? (int) $this->moyskladOrderStateSucessId : null;
    }



    /**
     * @return string
     */
    public function getProductImagePath(): string
    {
        return $this->productImagePath;
    }

    /**
     * @param string $productImagePath
     * @return Main
     */
    public function setProductImagePath(string $productImagePath): Main
    {
        $this->productImagePath = $productImagePath;
        return $this;
    }



    /**
     * @return int
     */
    public function getStateProviderSend(): int
    {
        return $this->stateProviderSend;
    }



    /**
     * @return int
     */
    public function getDefaultCurrency(): int
    {
        return $this->defaultCurrency;
    }

    //не использовать скиды для групп клиентов
    function getOrderDiscountIgnoreCustomerGroups()
    {
        return (array)$this->orderDiscountIgnoreCustomerGroups;
    }

    function getStateCancel()
    {
        return $this->stateCancel;
    }

    function getOrderScoreConvertPrice()
    {
        return $this->orderScoreConvertPrice;
    }

    function getOrderScoreSumm()
    {
        return $this->orderScoreSumm;
    }

    function getOrderScoreVolume()
    {
        return $this->orderScoreVolume;
    }

    function getCustomersBlockedInterval()
    {
        return $this->customersBlockedInterval;
    }

    function getStockImagePath()
    {
        return $this->stockImagePath;
    }

    function getThumbPath()
    {
        return $this->thumbPath;
    }

    function getPaginationRows()
    {
        return $this->paginationRows;
    }

    function getDefaultRegion()
    {
        return $this->defaultRegion;
    }

    function getStatePayment(): ?int
    {
        return $this->statePayment;
    }

    function getImages_server()
    {
        return $this->getImagesServer();
    }

    function getImagesServer()
    {
        return $this->imagesServer;
    }

    function getRussianPostUrl()
    {
        return $this->russianPostUrl;
    }

    function getMinOrderSumm()
    {
        return $this->minOrderSumm;
    }

    function getFakePersent()
    {
        return $this->fakePersent;
    }

    /**
     * @return int
     */
    public function getDefaultGuestGroup():?int
    {
        return $this->defaultGuestGroup;
    }

    function getMobileMask()
    {
        return $this->mobileMask;
    }

    /**
     * @return int
     */
    public function getDefaultContractorGroup(): ?int
    {
        return $this->defaultContractorGroup;
    }

    /**
     * @param int $defaultContractorGroup
     * @return Main
     */
    public function setDefaultContractorGroup(int $defaultContractorGroup): Main
    {
        $this->defaultContractorGroup = $defaultContractorGroup;
        return $this;
    }

    /**
     * @return int
     */
    public function getStateDefault(): int
    {
        return $this->stateDefault;
    }

    public function getStateProviderDefault():int
    {
        return $this->stateProviderDefault;
    }

    public function getManagerEmail()
    {
        return $this->managerEmail;
    }

    public function getDefaultCity()
    {
        return $this->defaultCity;
    }

    /**
     * Кол-во дней в течении которых товар считается новинкой
     * @return type
     */
    public function getDaysNewGoods(): int
    {
        return (int)$this->daysNewGoods;
    }

    /**
     * Ключ апи карты
     * @return string
     */
    public function getGoogleMapApiKey(): ?string
    {
        return $this->googleMapApiKey;
    }

    //put your code here
    protected function getFileName()
    {
        return 'shop.main.ini';
    }

    /**
     * @deprecated
     * @see Main::getDefaultCustomerGroup()
     * @return int
     */
    public function getDefault_customer_category()
    {
        return $this->default_customer_category;
    }

    /**
     * @return int
     */
    public function getDefaultCustomerGroup(): int
    {
        return $this->default_customer_category;
    }

    /**
     * @deprecated
     * @see Main::getDefaultCurrency()
     * @return string
     */
    public function getCurencyDisplay()
    {
        return $this->curencyDisplay;
    }

    /**
     * @deprecated
     * @return string
     */
    public function getCurencyDisplayShort()
    {
        return $this->curencyDisplayShort;
    }

}