<?php

namespace Shop\Repositories\StateLog;

use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\StateLog\Contracts\StateLogCriteriaInterface;
use Shop\Domain\StateLog\StateLogCollection;
use Shop\Models\StateLog\StateLog;
use Shop\Models\StateLog\StateLogQuery;

class StateLogRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface

{
    /**
     * @return EntityInterface
     */
    public static function createEntity(): EntityInterface
    {
        return new StateLog();
    }

    /**
     * @return ModelCriteria
     */
    protected function createQuery(): ModelCriteria
    {
        return StateLogQuery::create();
    }

    /**
     * @param PaginationInterface|StateLogCriteriaInterface $criteria
     * @param ModelCriteria|StateLogQuery $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        $this->modifyCriteriaForFilterSort($criteria,$dbCriteria);
        $dbCriteria
            ->_if($criteria->getFilterByObjectId()!==null)
            ->filterByObjectId($criteria->getFilterByObjectId())
            ->_endif()
            ;
    }

    /**
     * @param PaginationInterface $criteria
     * @return CollectionInterface
     * @throws \Repo\Concrete\Exceptions\Collection
     */
    public function findByCriteria(PaginationInterface $criteria): CollectionInterface
    {
        $query = $this->createQuery();
        $this->modifyCriteria($criteria, $query);
        $result = $query->paginate($criteria->getPage(), $criteria->getLimit());

        $collection = new StateLogCollection();

        foreach ($result->getResults() as $row) {
            $collection->push($row);
        }

        return $collection;
    }

}