<?php


namespace Shop\Repositories\City;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\City\Contracts\CityCriteriaInterface;

class CityCriteria extends AbstractCriteria implements CityCriteriaInterface
{
    /**
     * @var int|null
     */
    protected $filterByRegionId;
    /**
     * @var int|null
     */
    protected $filterByCountryId;

    /**
     * @var string|null
     */
    protected $sortByName;


    /**
     * @var string|null
     */
    protected $searchByName;

    /**
     * @var string|null
     */
    protected $filterByName;

    public static function create()
    {
        return new self();
    }

    /**
     * @return string|null
     */
    public function getFilterByName(): ?string
    {
        return $this->filterByName;
    }

    /**
     * @param string|null $filterByName
     * @return CityCriteria
     */
    public function setFilterByName(?string $filterByName): CityCriteria
    {
        $this->filterByName = $filterByName;
        return $this;
    }



    /**
     * @return int|null
     */
    public function getFilterByRegionId(): ?int
    {
        return $this->filterByRegionId;
    }

    /**
     * @param int|null $filterByRegionId
     * @return RegionCriteria
     */
    public function setFilterByRegionId(?int $filterByRegionId): CityCriteria
    {
        $this->filterByRegionId = $filterByRegionId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSortByName(): ?string
    {
        return $this->sortByName;
    }

    /**
     * @param string|null $sortByName
     * @return CityCriteria
     */
    public function setSortByName(?string $sortByName): CityCriteria
    {
        $this->sortByName = $sortByName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByName(): ?string
    {
        return $this->searchByName;
    }

    /**
     * @param string|null $searchByName
     * @return CityCriteria
     */
    public function setSearchByName(?string $searchByName): CityCriteria
    {
        $this->searchByName = $searchByName;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterByCountryId(): ?int
    {
        return $this->filterByCountryId;
    }

    /**
     * @param int|null $filterByCountryId
     * @return CityCriteria
     */
    public function setFilterByCountryId(?int $filterByCountryId): CityCriteria
    {
        $this->filterByCountryId = $filterByCountryId;
        return $this;
    }


}