<?php

namespace Shop\Models\Shop\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\Shop\ShopShopsArchive as ChildShopShopsArchive;
use Shop\Models\Shop\ShopShopsArchiveQuery as ChildShopShopsArchiveQuery;
use Shop\Models\Shop\Map\ShopShopsArchiveTableMap;

/**
 * Base class that represents a query for the 'shop_shops_archive' table.
 *
 *
 *
 * @method     ChildShopShopsArchiveQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildShopShopsArchiveQuery orderByTitle($order = Criteria::ASC) Order by the title column
 * @method     ChildShopShopsArchiveQuery orderByDesc($order = Criteria::ASC) Order by the desc column
 * @method     ChildShopShopsArchiveQuery orderByImage($order = Criteria::ASC) Order by the image column
 * @method     ChildShopShopsArchiveQuery orderByLogo($order = Criteria::ASC) Order by the logo column
 * @method     ChildShopShopsArchiveQuery orderBydirectorContact($order = Criteria::ASC) Order by the director_contact column
 * @method     ChildShopShopsArchiveQuery orderByPhones($order = Criteria::ASC) Order by the phones column
 * @method     ChildShopShopsArchiveQuery orderByemails($order = Criteria::ASC) Order by the emails column
 * @method     ChildShopShopsArchiveQuery orderByType($order = Criteria::ASC) Order by the type column
 * @method     ChildShopShopsArchiveQuery orderByParentId($order = Criteria::ASC) Order by the parent_id column
 * @method     ChildShopShopsArchiveQuery orderByDomainId($order = Criteria::ASC) Order by the domain_id column
 * @method     ChildShopShopsArchiveQuery orderByActive($order = Criteria::ASC) Order by the active column
 * @method     ChildShopShopsArchiveQuery orderByContractorId($order = Criteria::ASC) Order by the contractor_id column
 * @method     ChildShopShopsArchiveQuery orderByArchivedAt($order = Criteria::ASC) Order by the archived_at column
 *
 * @method     ChildShopShopsArchiveQuery groupById() Group by the id column
 * @method     ChildShopShopsArchiveQuery groupByTitle() Group by the title column
 * @method     ChildShopShopsArchiveQuery groupByDesc() Group by the desc column
 * @method     ChildShopShopsArchiveQuery groupByImage() Group by the image column
 * @method     ChildShopShopsArchiveQuery groupByLogo() Group by the logo column
 * @method     ChildShopShopsArchiveQuery groupBydirectorContact() Group by the director_contact column
 * @method     ChildShopShopsArchiveQuery groupByPhones() Group by the phones column
 * @method     ChildShopShopsArchiveQuery groupByemails() Group by the emails column
 * @method     ChildShopShopsArchiveQuery groupByType() Group by the type column
 * @method     ChildShopShopsArchiveQuery groupByParentId() Group by the parent_id column
 * @method     ChildShopShopsArchiveQuery groupByDomainId() Group by the domain_id column
 * @method     ChildShopShopsArchiveQuery groupByActive() Group by the active column
 * @method     ChildShopShopsArchiveQuery groupByContractorId() Group by the contractor_id column
 * @method     ChildShopShopsArchiveQuery groupByArchivedAt() Group by the archived_at column
 *
 * @method     ChildShopShopsArchiveQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildShopShopsArchiveQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildShopShopsArchiveQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildShopShopsArchiveQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildShopShopsArchiveQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildShopShopsArchiveQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildShopShopsArchive findOne(ConnectionInterface $con = null) Return the first ChildShopShopsArchive matching the query
 * @method     ChildShopShopsArchive findOneOrCreate(ConnectionInterface $con = null) Return the first ChildShopShopsArchive matching the query, or a new ChildShopShopsArchive object populated from the query conditions when no match is found
 *
 * @method     ChildShopShopsArchive findOneById(int $id) Return the first ChildShopShopsArchive filtered by the id column
 * @method     ChildShopShopsArchive findOneByTitle(string $title) Return the first ChildShopShopsArchive filtered by the title column
 * @method     ChildShopShopsArchive findOneByDesc(string $desc) Return the first ChildShopShopsArchive filtered by the desc column
 * @method     ChildShopShopsArchive findOneByImage(string $image) Return the first ChildShopShopsArchive filtered by the image column
 * @method     ChildShopShopsArchive findOneByLogo(string $logo) Return the first ChildShopShopsArchive filtered by the logo column
 * @method     ChildShopShopsArchive findOneBydirectorContact(string $director_contact) Return the first ChildShopShopsArchive filtered by the director_contact column
 * @method     ChildShopShopsArchive findOneByPhones(string $phones) Return the first ChildShopShopsArchive filtered by the phones column
 * @method     ChildShopShopsArchive findOneByemails(string $emails) Return the first ChildShopShopsArchive filtered by the emails column
 * @method     ChildShopShopsArchive findOneByType(string $type) Return the first ChildShopShopsArchive filtered by the type column
 * @method     ChildShopShopsArchive findOneByParentId(int $parent_id) Return the first ChildShopShopsArchive filtered by the parent_id column
 * @method     ChildShopShopsArchive findOneByDomainId(int $domain_id) Return the first ChildShopShopsArchive filtered by the domain_id column
 * @method     ChildShopShopsArchive findOneByActive(string $active) Return the first ChildShopShopsArchive filtered by the active column
 * @method     ChildShopShopsArchive findOneByContractorId(int $contractor_id) Return the first ChildShopShopsArchive filtered by the contractor_id column
 * @method     ChildShopShopsArchive findOneByArchivedAt(string $archived_at) Return the first ChildShopShopsArchive filtered by the archived_at column *

 * @method     ChildShopShopsArchive requirePk($key, ConnectionInterface $con = null) Return the ChildShopShopsArchive by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopShopsArchive requireOne(ConnectionInterface $con = null) Return the first ChildShopShopsArchive matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildShopShopsArchive requireOneById(int $id) Return the first ChildShopShopsArchive filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopShopsArchive requireOneByTitle(string $title) Return the first ChildShopShopsArchive filtered by the title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopShopsArchive requireOneByDesc(string $desc) Return the first ChildShopShopsArchive filtered by the desc column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopShopsArchive requireOneByImage(string $image) Return the first ChildShopShopsArchive filtered by the image column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopShopsArchive requireOneByLogo(string $logo) Return the first ChildShopShopsArchive filtered by the logo column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopShopsArchive requireOneBydirectorContact(string $director_contact) Return the first ChildShopShopsArchive filtered by the director_contact column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopShopsArchive requireOneByPhones(string $phones) Return the first ChildShopShopsArchive filtered by the phones column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopShopsArchive requireOneByemails(string $emails) Return the first ChildShopShopsArchive filtered by the emails column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopShopsArchive requireOneByType(string $type) Return the first ChildShopShopsArchive filtered by the type column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopShopsArchive requireOneByParentId(int $parent_id) Return the first ChildShopShopsArchive filtered by the parent_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopShopsArchive requireOneByDomainId(int $domain_id) Return the first ChildShopShopsArchive filtered by the domain_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopShopsArchive requireOneByActive(string $active) Return the first ChildShopShopsArchive filtered by the active column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopShopsArchive requireOneByContractorId(int $contractor_id) Return the first ChildShopShopsArchive filtered by the contractor_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildShopShopsArchive requireOneByArchivedAt(string $archived_at) Return the first ChildShopShopsArchive filtered by the archived_at column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildShopShopsArchive[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildShopShopsArchive objects based on current ModelCriteria
 * @method     ChildShopShopsArchive[]|ObjectCollection findById(int $id) Return ChildShopShopsArchive objects filtered by the id column
 * @method     ChildShopShopsArchive[]|ObjectCollection findByTitle(string $title) Return ChildShopShopsArchive objects filtered by the title column
 * @method     ChildShopShopsArchive[]|ObjectCollection findByDesc(string $desc) Return ChildShopShopsArchive objects filtered by the desc column
 * @method     ChildShopShopsArchive[]|ObjectCollection findByImage(string $image) Return ChildShopShopsArchive objects filtered by the image column
 * @method     ChildShopShopsArchive[]|ObjectCollection findByLogo(string $logo) Return ChildShopShopsArchive objects filtered by the logo column
 * @method     ChildShopShopsArchive[]|ObjectCollection findBydirectorContact(string $director_contact) Return ChildShopShopsArchive objects filtered by the director_contact column
 * @method     ChildShopShopsArchive[]|ObjectCollection findByPhones(string $phones) Return ChildShopShopsArchive objects filtered by the phones column
 * @method     ChildShopShopsArchive[]|ObjectCollection findByemails(string $emails) Return ChildShopShopsArchive objects filtered by the emails column
 * @method     ChildShopShopsArchive[]|ObjectCollection findByType(string $type) Return ChildShopShopsArchive objects filtered by the type column
 * @method     ChildShopShopsArchive[]|ObjectCollection findByParentId(int $parent_id) Return ChildShopShopsArchive objects filtered by the parent_id column
 * @method     ChildShopShopsArchive[]|ObjectCollection findByDomainId(int $domain_id) Return ChildShopShopsArchive objects filtered by the domain_id column
 * @method     ChildShopShopsArchive[]|ObjectCollection findByActive(string $active) Return ChildShopShopsArchive objects filtered by the active column
 * @method     ChildShopShopsArchive[]|ObjectCollection findByContractorId(int $contractor_id) Return ChildShopShopsArchive objects filtered by the contractor_id column
 * @method     ChildShopShopsArchive[]|ObjectCollection findByArchivedAt(string $archived_at) Return ChildShopShopsArchive objects filtered by the archived_at column
 * @method     ChildShopShopsArchive[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ShopShopsArchiveQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Models\Shop\Base\ShopShopsArchiveQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\Shop\\ShopShopsArchive', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildShopShopsArchiveQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildShopShopsArchiveQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildShopShopsArchiveQuery) {
            return $criteria;
        }
        $query = new ChildShopShopsArchiveQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildShopShopsArchive|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ShopShopsArchiveTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ShopShopsArchiveTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildShopShopsArchive A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `title`, `desc`, `image`, `logo`, `director_contact`, `phones`, `emails`, `type`, `parent_id`, `domain_id`, `active`, `contractor_id`, `archived_at` FROM `shop_shops_archive` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildShopShopsArchive $obj */
            $obj = new ChildShopShopsArchive();
            $obj->hydrate($row);
            ShopShopsArchiveTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildShopShopsArchive|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildShopShopsArchiveQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ShopShopsArchiveTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildShopShopsArchiveQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ShopShopsArchiveTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopShopsArchiveQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(ShopShopsArchiveTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(ShopShopsArchiveTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopShopsArchiveTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the title column
     *
     * Example usage:
     * <code>
     * $query->filterByTitle('fooValue');   // WHERE title = 'fooValue'
     * $query->filterByTitle('%fooValue%', Criteria::LIKE); // WHERE title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $title The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopShopsArchiveQuery The current query, for fluid interface
     */
    public function filterByTitle($title = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($title)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopShopsArchiveTableMap::COL_TITLE, $title, $comparison);
    }

    /**
     * Filter the query on the desc column
     *
     * Example usage:
     * <code>
     * $query->filterByDesc('fooValue');   // WHERE desc = 'fooValue'
     * $query->filterByDesc('%fooValue%', Criteria::LIKE); // WHERE desc LIKE '%fooValue%'
     * </code>
     *
     * @param     string $desc The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopShopsArchiveQuery The current query, for fluid interface
     */
    public function filterByDesc($desc = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($desc)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopShopsArchiveTableMap::COL_DESC, $desc, $comparison);
    }

    /**
     * Filter the query on the image column
     *
     * Example usage:
     * <code>
     * $query->filterByImage('fooValue');   // WHERE image = 'fooValue'
     * $query->filterByImage('%fooValue%', Criteria::LIKE); // WHERE image LIKE '%fooValue%'
     * </code>
     *
     * @param     string $image The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopShopsArchiveQuery The current query, for fluid interface
     */
    public function filterByImage($image = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($image)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopShopsArchiveTableMap::COL_IMAGE, $image, $comparison);
    }

    /**
     * Filter the query on the logo column
     *
     * Example usage:
     * <code>
     * $query->filterByLogo('fooValue');   // WHERE logo = 'fooValue'
     * $query->filterByLogo('%fooValue%', Criteria::LIKE); // WHERE logo LIKE '%fooValue%'
     * </code>
     *
     * @param     string $logo The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopShopsArchiveQuery The current query, for fluid interface
     */
    public function filterByLogo($logo = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($logo)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopShopsArchiveTableMap::COL_LOGO, $logo, $comparison);
    }

    /**
     * Filter the query on the director_contact column
     *
     * Example usage:
     * <code>
     * $query->filterBydirectorContact('fooValue');   // WHERE director_contact = 'fooValue'
     * $query->filterBydirectorContact('%fooValue%', Criteria::LIKE); // WHERE director_contact LIKE '%fooValue%'
     * </code>
     *
     * @param     string $directorContact The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopShopsArchiveQuery The current query, for fluid interface
     */
    public function filterBydirectorContact($directorContact = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($directorContact)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopShopsArchiveTableMap::COL_DIRECTOR_CONTACT, $directorContact, $comparison);
    }

    /**
     * Filter the query on the phones column
     *
     * Example usage:
     * <code>
     * $query->filterByPhones('fooValue');   // WHERE phones = 'fooValue'
     * $query->filterByPhones('%fooValue%', Criteria::LIKE); // WHERE phones LIKE '%fooValue%'
     * </code>
     *
     * @param     string $phones The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopShopsArchiveQuery The current query, for fluid interface
     */
    public function filterByPhones($phones = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($phones)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopShopsArchiveTableMap::COL_PHONES, $phones, $comparison);
    }

    /**
     * Filter the query on the emails column
     *
     * Example usage:
     * <code>
     * $query->filterByemails('fooValue');   // WHERE emails = 'fooValue'
     * $query->filterByemails('%fooValue%', Criteria::LIKE); // WHERE emails LIKE '%fooValue%'
     * </code>
     *
     * @param     string $emails The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopShopsArchiveQuery The current query, for fluid interface
     */
    public function filterByemails($emails = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($emails)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopShopsArchiveTableMap::COL_EMAILS, $emails, $comparison);
    }

    /**
     * Filter the query on the type column
     *
     * Example usage:
     * <code>
     * $query->filterByType('fooValue');   // WHERE type = 'fooValue'
     * $query->filterByType('%fooValue%', Criteria::LIKE); // WHERE type LIKE '%fooValue%'
     * </code>
     *
     * @param     string $type The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopShopsArchiveQuery The current query, for fluid interface
     */
    public function filterByType($type = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($type)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopShopsArchiveTableMap::COL_TYPE, $type, $comparison);
    }

    /**
     * Filter the query on the parent_id column
     *
     * Example usage:
     * <code>
     * $query->filterByParentId(1234); // WHERE parent_id = 1234
     * $query->filterByParentId(array(12, 34)); // WHERE parent_id IN (12, 34)
     * $query->filterByParentId(array('min' => 12)); // WHERE parent_id > 12
     * </code>
     *
     * @param     mixed $parentId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopShopsArchiveQuery The current query, for fluid interface
     */
    public function filterByParentId($parentId = null, $comparison = null)
    {
        if (is_array($parentId)) {
            $useMinMax = false;
            if (isset($parentId['min'])) {
                $this->addUsingAlias(ShopShopsArchiveTableMap::COL_PARENT_ID, $parentId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($parentId['max'])) {
                $this->addUsingAlias(ShopShopsArchiveTableMap::COL_PARENT_ID, $parentId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopShopsArchiveTableMap::COL_PARENT_ID, $parentId, $comparison);
    }

    /**
     * Filter the query on the domain_id column
     *
     * Example usage:
     * <code>
     * $query->filterByDomainId(1234); // WHERE domain_id = 1234
     * $query->filterByDomainId(array(12, 34)); // WHERE domain_id IN (12, 34)
     * $query->filterByDomainId(array('min' => 12)); // WHERE domain_id > 12
     * </code>
     *
     * @param     mixed $domainId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopShopsArchiveQuery The current query, for fluid interface
     */
    public function filterByDomainId($domainId = null, $comparison = null)
    {
        if (is_array($domainId)) {
            $useMinMax = false;
            if (isset($domainId['min'])) {
                $this->addUsingAlias(ShopShopsArchiveTableMap::COL_DOMAIN_ID, $domainId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($domainId['max'])) {
                $this->addUsingAlias(ShopShopsArchiveTableMap::COL_DOMAIN_ID, $domainId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopShopsArchiveTableMap::COL_DOMAIN_ID, $domainId, $comparison);
    }

    /**
     * Filter the query on the active column
     *
     * Example usage:
     * <code>
     * $query->filterByActive('fooValue');   // WHERE active = 'fooValue'
     * $query->filterByActive('%fooValue%', Criteria::LIKE); // WHERE active LIKE '%fooValue%'
     * </code>
     *
     * @param     string $active The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopShopsArchiveQuery The current query, for fluid interface
     */
    public function filterByActive($active = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($active)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopShopsArchiveTableMap::COL_ACTIVE, $active, $comparison);
    }

    /**
     * Filter the query on the contractor_id column
     *
     * Example usage:
     * <code>
     * $query->filterByContractorId(1234); // WHERE contractor_id = 1234
     * $query->filterByContractorId(array(12, 34)); // WHERE contractor_id IN (12, 34)
     * $query->filterByContractorId(array('min' => 12)); // WHERE contractor_id > 12
     * </code>
     *
     * @param     mixed $contractorId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopShopsArchiveQuery The current query, for fluid interface
     */
    public function filterByContractorId($contractorId = null, $comparison = null)
    {
        if (is_array($contractorId)) {
            $useMinMax = false;
            if (isset($contractorId['min'])) {
                $this->addUsingAlias(ShopShopsArchiveTableMap::COL_CONTRACTOR_ID, $contractorId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($contractorId['max'])) {
                $this->addUsingAlias(ShopShopsArchiveTableMap::COL_CONTRACTOR_ID, $contractorId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopShopsArchiveTableMap::COL_CONTRACTOR_ID, $contractorId, $comparison);
    }

    /**
     * Filter the query on the archived_at column
     *
     * Example usage:
     * <code>
     * $query->filterByArchivedAt('2011-03-14'); // WHERE archived_at = '2011-03-14'
     * $query->filterByArchivedAt('now'); // WHERE archived_at = '2011-03-14'
     * $query->filterByArchivedAt(array('max' => 'yesterday')); // WHERE archived_at > '2011-03-13'
     * </code>
     *
     * @param     mixed $archivedAt The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildShopShopsArchiveQuery The current query, for fluid interface
     */
    public function filterByArchivedAt($archivedAt = null, $comparison = null)
    {
        if (is_array($archivedAt)) {
            $useMinMax = false;
            if (isset($archivedAt['min'])) {
                $this->addUsingAlias(ShopShopsArchiveTableMap::COL_ARCHIVED_AT, $archivedAt['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($archivedAt['max'])) {
                $this->addUsingAlias(ShopShopsArchiveTableMap::COL_ARCHIVED_AT, $archivedAt['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ShopShopsArchiveTableMap::COL_ARCHIVED_AT, $archivedAt, $comparison);
    }

    /**
     * Exclude object from result
     *
     * @param   ChildShopShopsArchive $shopShopsArchive Object to remove from the list of results
     *
     * @return $this|ChildShopShopsArchiveQuery The current query, for fluid interface
     */
    public function prune($shopShopsArchive = null)
    {
        if ($shopShopsArchive) {
            $this->addUsingAlias(ShopShopsArchiveTableMap::COL_ID, $shopShopsArchive->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_shops_archive table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopShopsArchiveTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ShopShopsArchiveTableMap::clearInstancePool();
            ShopShopsArchiveTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ShopShopsArchiveTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ShopShopsArchiveTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ShopShopsArchiveTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ShopShopsArchiveTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // ShopShopsArchiveQuery
