<?php


namespace Shop\Application\Office\CustomerRegistration;

/**
 * Class CustomerRequest
 * @package Shop\UseCases\SecurePolicy
 */
class CustomerRequest
{
    /**
     * @var int
     */
    protected $cityId;
    /**
     * @var string
     */
    protected $email;
    /**
     * @var int
     */
    protected $groupId;
    /**
     * @var string
     */
    protected $name;
    /**
     * @var string|null
     */
    protected $phone;
    /**
     * @var int
     */
    protected $managerId;

    /**
     * @var string|null
     */
    protected $passwordHash;

    /**
     * @var string|null
     */
    protected $password;

    /**
     * @return string|null
     */
    public function getPassword(): ?string
    {
        return $this->password;
    }

    /**
     * @param string|null $password
     * @return CustomerRequest
     */
    public function setPassword(?string $password): CustomerRequest
    {
        $this->password = $password;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getPasswordHash(): ?string
    {
        return $this->passwordHash;
    }

    /**
     * @param string|null $passwordHash
     * @return CustomerRequest
     */
    public function setPasswordHash(?string $passwordHash): CustomerRequest
    {
        $this->passwordHash = $passwordHash;
        return $this;
    }


    /**
     * @return int
     */
    public function getCityId(): int
    {
        return $this->cityId;
    }

    /**
     * @param int $cityId
     * @return CustomerRequest
     */
    public function setCityId(int $cityId): CustomerRequest
    {
        $this->cityId = $cityId;
        return $this;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @param string $email
     * @return CustomerRequest
     */
    public function setEmail(string $email): CustomerRequest
    {
        $this->email = $email;
        return $this;
    }

    /**
     * @return int
     */
    public function getGroupId(): int
    {
        return $this->groupId;
    }

    /**
     * @param int $groupId
     * @return CustomerRequest
     */
    public function setGroupId(int $groupId): CustomerRequest
    {
        $this->groupId = $groupId;
        return $this;
    }

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return CustomerRequest
     */
    public function setName(string $name): CustomerRequest
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPhone(): ?string
    {
        return $this->phone;
    }

    /**
     * @param string|null $phone
     * @return CustomerRequest
     */
    public function setPhone(?string $phone): CustomerRequest
    {
        $this->phone = $phone;
        return $this;
    }

    /**
     * @return int
     */
    public function getManagerId(): int
    {
        return $this->managerId;
    }

    /**
     * @param int $managerId
     * @return CustomerRequest
     */
    public function setManagerId(int $managerId): CustomerRequest
    {
        $this->managerId = $managerId;
        return $this;
    }


}