<?php

use Propel\Generator\Manager\MigrationManager;

/**
 * Data object containing the SQL and PHP code to migrate the database
 * up to version 1603523298.
 * Generated on 2020-10-24 10:08:18
 */
class PropelMigration_1603529653
{
    public $comment = '';

    public function preUp(MigrationManager $manager)
    {


    }

    public function postUp(MigrationManager $manager)
    {
        //delete
        \Diamond\Models\Menu\MenuQuery::create()->filterByName('admin-main')->delete();

        //add new
        $baseMenu = (new \Diamond\Models\Menu\Menu)
            ->setDomainId(1)
            ->setName('admin-main')
            ->setActive('Y');

        $baseMenu
            ->copy()
            ->setTitle('Система')
            ->setCode('flatscreen')
            ->setUrl('/admin/diamond/system/dashboard')
            ->save();

        $baseMenu
            ->copy()
            ->setTitle('Контент')
            ->setCode('book')
            ->setUrl('/admin/diamond/content/pages')
            ->save();

        $baseMenu
            ->copy()
            ->setTitle('Рассылка')
            ->setCode('message')
            ->setUrl('/admin/diamond/mailing/mailing')
            ->save();

        $baseMenu
            ->copy()
            ->setTitle('СЕО')
            ->setCode('chart')
            ->setUrl('/admin/diamond/seo/stat-chart')
            ->save();

        $baseMenu
            ->copy()
            ->setTitle('Клиенты и заказы')
            ->setCode('chart')
            ->setUrl('/admin/shop/customers/orders')
            ->save();

        $baseMenu
            ->copy()
            ->setTitle('Справочники')
            ->setCode('lists')
            ->setUrl('/admin/shop/other/states')
            ->save();

        $baseMenu
            ->copy()
            ->setTitle('Офисы')
            ->setCode('home')
            ->setUrl('/admin/shop/stocks/stocks')
            ->save();

        $baseMenu
            ->copy()
            ->setTitle('Номенклатура')
            ->setCode('tree')
            ->setUrl('/admin/shop/catalog/brands')
            ->save();

        //-----------------

        \Diamond\Models\Menu\MenuQuery::create()->filterByName('admin-diamond-system')->delete();

        $baseMenu = (new \Diamond\Models\Menu\Menu)
            ->setDomainId(1)
            ->setName('admin-diamond-system')
            ->setActive('Y');

        $baseMenu
            ->copy()
            ->setTitle('Сводная информация')
            ->setUrl('/admin/diamond/system/dashboard')
            ->save();

        $userMenu = $baseMenu
            ->copy()
            ->setTitle('Пользователи');
        $userMenu->save();

        $baseMenu
            ->copy()
            ->setTitle('Список пользователей')
            ->setUrl('/admin/diamond/system/users')
            ->setParentId($userMenu->getId())
            ->save();

        $baseMenu
            ->copy()
            ->setTitle('Группы пользователей')
            ->setUrl('/admin/diamond/system/user-groups')
            ->setParentId($userMenu->getId())
            ->save();

        $templatesMenu = $baseMenu
            ->copy()
            ->setTitle('Настройка шаблонов');
        $templatesMenu->save();

        $baseMenu
            ->copy()
            ->setTitle('Шаблоны уведомлений')
            ->setUrl('/admin/diamond/system/report')
            ->setParentId($templatesMenu->getId())
            ->save();

        $baseMenu
            ->copy()
            ->setTitle('Шаблоны сайта')
            ->setUrl('/admin/diamond/system/templates')
            ->setParentId($templatesMenu->getId())
            ->save();


        $settingMenu = $baseMenu
            ->copy()
            ->setCode('elements')
            ->setTitle('Конфигурация');
        $settingMenu->save();

        $baseMenu
            ->copy()
            ->setTitle('Настройки сайта')
            ->setUrl('/admin/diamond/system/settings-main')
            ->setParentId($settingMenu->getId())
            ->save();

        $baseMenu
            ->copy()
            ->setTitle('Установки почты')
            ->setUrl('/admin/diamond/system/settings-email')
            ->setParentId($settingMenu->getId())
            ->save();

        $systemMenu = $baseMenu
            ->copy()
            ->setCode('addons')
            ->setTitle('Системная информация');
        $systemMenu->save();

        $baseMenu
            ->copy()
            ->setTitle('Таблица логов')
            ->setUrl('/admin/diamond/system/logs')
            ->setParentId($systemMenu->getId())
            ->save();

        $baseMenu
            ->copy()
            ->setTitle('Нагрузка на сайт')
            ->setUrl('/admin/diamond/system/performance')
            ->setParentId($systemMenu->getId())
            ->save();

        $baseMenu
            ->copy()
            ->setTitle('Информация о php')
            ->setUrl('/admin/diamond/system/info_php')
            ->setParentId($systemMenu->getId())
            ->save();

        $baseMenu
            ->copy()
            ->setTitle('Экспресс проверка системы')
            ->setUrl('/admin/diamond/system/system_test')
            ->setParentId($systemMenu->getId())
            ->save();

        $baseMenu
            ->copy()
            ->setTitle('Мультисайтовость')
            ->setCode('support')
            ->setUrl('/admin/diamond/system/domains')
            ->save();
    }

    public function preDown(MigrationManager $manager)
    {
        // add the pre-migration code here
    }

    public function postDown(MigrationManager $manager)
    {
        // add the post-migration code here
    }

    /**
     * Get the SQL statements for the Up migration
     *
     * @return array list of the SQL strings to execute for the Up migration
     *               the keys being the datasources
     */
    public function getUpSQL()
    {
        return array(
            'default' => '
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;




# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
',
        );
    }

    /**
     * Get the SQL statements for the Down migration
     *
     * @return array list of the SQL strings to execute for the Down migration
     *               the keys being the datasources
     */
    public function getDownSQL()
    {
        return array(
            'default' => '
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
',
        );
    }

}