<?php

namespace Shop\Modules\AdminSettingsCatalog;

use Core\Form\ControlBuilder;
use Core\Form\FormBuilder;
use Diamond\Helpers\Form;
use Shop\Config\Main;
use Shop\Repositories\Brand\BrandCriteria;
use Shop\Repositories\Brand\BrandRepository;
use Shop\Repositories\Currency\CurrencyCriteria;
use Shop\Repositories\Currency\CurrencyRepository;
use Shop\Repositories\ProductCategory\ProductCategoryCriteria;
use Shop\Repositories\ProductCategory\ProductCategoryRepository;

/**
 * Description of AdminConfigMain
 *
 * @author Diamond Code Generator
 */
class AdminSettingsCatalog extends \Core\ModuleController
{

    protected $formBuilder;
    protected $controlBuilder;
    protected $conf;
    protected $currencyRepository;
    protected $brandRepository;
    protected $productCategoryRepository;

    /**
     * AdminSettingsMain constructor.
     * @param FormBuilder $form
     * @param ControlBuilder $controlBuilder
     * @param Main $conf
     * @param CurrencyRepository $currencyRepository
     */
    public function __construct(FormBuilder $form, ControlBuilder $controlBuilder, Main $conf,
                                CurrencyRepository $currencyRepository, BrandRepository $brandRepository,
                                ProductCategoryRepository $productCategoryRepository
    )
    {
        $this->formBuilder = $form;
        $this->controlBuilder = $controlBuilder;
        $this->conf = $conf;
        $this->currencyRepository = $currencyRepository;
        $this->brandRepository = $brandRepository;
        $this->productCategoryRepository = $productCategoryRepository;
    }

    /**
     * @return \Core\Form\SettingsForm
     */
    protected function buildForm(): \Core\Form\SettingsForm
    {
        $form = $this->formBuilder->buildSettingsForm($this->conf, 'main');
        $builder = $this->controlBuilder;

        $currencies = $this->currencyRepository->findByCriteria(
            CurrencyCriteria::create()
        );

        $brands = $this->brandRepository->findByCriteria(
          BrandCriteria::create()->setSortByName('ASC')
        );

        $categories = $this->productCategoryRepository->findByCriteria(
          ProductCategoryCriteria::create()->setSortByTitle('ASC')
        );

        $form
            ->addHeader('Валюта')
            ->addField(
                $builder->buildDropdownUniform('defaultCurrency', Form::prepareDropdown($currencies)),
                'Валюта по умолчанию', 'required'
            )
//            ->addField(
//                $builder->buildInputLittle('curencyDisplay'), 'Наименование валюты', 'required', 'Например руб.'
//            )
//            ->addField(
//                $builder->buildInputLittle('curencyDisplayShort'), 'Краткое наименование валюты', 'required', 'Например р.'
//            )
            ->addHeader('Движение позиций и заказ')
            ->addField(
                $builder->buildInputLittle('fakePersent'), 'Фиктивная наценка, %', [], 'для акционных товаров'
            )
            ->addField(
                $builder->buildInputLittle('daysNewGoods'), 'Срок жизни нового товара, дней', null, 'Товар помечается как новинка'
            )
            ->addHeader('Изображения')
            ->addField(
                $builder->buildInputSmall('imagesServer'), 'Сервер изображений', null,
                'По умолчанию будет использоваться текущий'
            )
            ->addField(
                $builder->buildInputSmall('thumbPath'), 'Url путь к миниэскизам', null,
                'Относительно сервера изображений'
            )
            ->addField(
                $builder->buildInputSmall('productImagePath'),
                'Путь для изображений товаров',
                'required','относительно каталога upload'
            )
            ->addHeader('Товары')
            ->addField(
                $builder->buildAutoDropdown('defaultBrandId', Form::prepareDropdown($brands)),
                'Бренд по умолчанию'
            )
            ->addField(
                $builder->buildAutoDropdown('defaultCategoryId', Form::prepareDropdown($categories)),
                'Раздел каталога по умолчанию'
            )
        ;

        return $form;
    }

    public function process(): string
    {

        $form = $this->buildForm();

        return $form->render();
    }

}               