<?php
namespace Shop\Repositories\StateLog;

use Repo\Concrete\AbstractCriteria;
use Shop\Domain\StateLog\Contracts\StateLogCriteriaInterface;

class StateLogCriteria extends AbstractCriteria implements StateLogCriteriaInterface
{
    /**
     * @var string|null
     */
    protected $filterByObjectId;

    /**
     * @return string|null
     */
    public function getFilterByObjectId(): ?string
    {
        return $this->filterByObjectId;
    }

    /**
     * @param string|null $filterByObjectId
     * @return StateLogCriteria
     */
    public function setFilterByObjectId(?string $filterByObjectId): StateLogCriteria
    {
        $this->filterByObjectId = $filterByObjectId;
        return $this;
    }


    public static function create()
    {
        return new self();
    }

}