<?php

namespace Shop\Repositories\DiscountRule;

use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\DiscountRule\Contracts\DiscountRuleEntityInterface;
use Shop\Domain\DiscountRule\DiscountRuleCollection;
use Shop\Models\DiscountRule\DiscountRule;
use Shop\Models\DiscountRule\DiscountRuleQuery;

/**
 * Class DiscountRuleRepository
 * @package Shop\Repositories\DiscountRule
 */
class DiscountRuleRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    /**
     * @return EntityInterface|DiscountRuleEntityInterface
     */
    public static function createEntity(): EntityInterface
    {
        return new DiscountRule();
    }

    /**
     * @return ModelCriteria|DiscountRuleQuery
     */
    protected function createQuery(): ModelCriteria
    {
        return DiscountRuleQuery::create();
    }

    /**
     * @param PaginationInterface $criteria
     * @param ModelCriteria $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        $this->modifyCriteriaForFilterSort($criteria, $dbCriteria);
    }

    /**
     * @param PaginationInterface $criteria
     * @return CollectionInterface
     * @throws \Repo\Concrete\Exceptions\Collection
     */
    public function findByCriteria(PaginationInterface $criteria): CollectionInterface
    {
        $query = $this->createQuery();
        $this->modifyCriteria($criteria, $query);
        $result = $query->paginate($criteria->getPage(), $criteria->getLimit());

        $collection = new DiscountRuleCollection();

        foreach ($result->getResults() as $row) {
            $collection->push($row);
        }

        return $collection;
    }

}