<?php


namespace Shop\Application\Office\Decorators;


use Shop\Config\Main;
use Shop\Domain\City\Contracts\CityEntityInterface;
use Shop\Domain\Customer\Contracts\CustomerEntityInterface;
use Shop\Domain\Manager\Contracts\ManagerEntityInterface;
use Symfony\Component\HttpFoundation\Session\Session;

class Customer implements CustomerEntityInterface
{
    protected $customerEntity;
    protected $session;
    /**
     * @var Main
     */
    protected $mainConfig;

    public function __construct(CustomerEntityInterface $customerEntity, Session $session, Main $mainConfig)
    {
        $this->customerEntity = $customerEntity;
        $this->session = $session;
        $this->mainConfig = $mainConfig;
    }

    public function getId()
    {
        return $this->customerEntity->getId();
    }

    public function getPassword(): string
    {
        return $this->customerEntity->getPassword();
    }

    public function getInfoHidden(): ?string
    {
        return $this->customerEntity->getInfoHidden();
    }

    public function getAccessPrices(): array
    {
        return $this->customerEntity->getAccessPrices();
    }

    public function getGroupId(): int
    {
        return $this->customerEntity->getGroupId();
    }

    public function getName(): ?string
    {
        return $this->customerEntity->getName();
    }

    public function getEmail(): string
    {
        return $this->customerEntity->getEmail();
    }

    public function getPhone(): ?string
    {
        return $this->customerEntity->getPhone();
    }

    public function getCityId(): int
    {
        return $this->customerEntity->getCityId();
    }

    public function getManagerId(): int
    {
        return $this->customerEntity->getManagerId();
    }

    public function getManager(): ManagerEntityInterface
    {
        return $this->customerEntity->getManager();
    }

    public function getCustomerCity(): CityEntityInterface
    {
        return $this->customerEntity->getCustomerCity();
    }

    public function isAuth(): bool
    {
        return $this->customerEntity->getGroupId() !== $this->mainConfig->getDefaultGuestGroup();
    }

    public function isNotifySms(): bool
    {
        return $this->customerEntity->isNotifySms();
    }

    public function getFullAddress(): string
    {
        return $this->customerEntity->getFullAddress();
    }

    public function isNotifyEmail(): bool
    {
        return $this->customerEntity->isNotifyEmail();
    }

    public function getRegisterCode(): string
    {
        return $this->customerEntity->getRegisterCode();
    }

    public function getAccessPriceListScheetIds(): array
    {
        return $this->customerEntity->getAccessPriceListScheetIds();
    }

    /**
     * @todo прокинуть настрйоку
     * @return bool
     */
    public function isProvider(): bool
    {
        return $this->customerEntity->isProvider();
    }

    /**
     * @todo прокинуть настрйоку
     * @return bool
     */
    public function isStock(): bool
    {
        return $this->customerEntity->isStock();
    }

    /**
     * @return mixed
     */
    public function getCustomerGroup()
    {
        return $this->customerEntity->getCustomerGroup();
    }

    public function __call($name, $arguments)
    {
        return call_user_func_array([$this->customerEntity,$name],$arguments);
    }


}