<?php

namespace Shop\Models\Customer\Map;

use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\InstancePoolTrait;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\DataFetcher\DataFetcherInterface;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\RelationMap;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Map\TableMapTrait;
use Shop\Models\Customer\Customer;
use Shop\Models\Customer\CustomerQuery;
use Shop\Models\CustomerSocialLogin\Map\CustomerSocialLoginTableMap;
use Shop\Models\FastLink\Map\FastLinkTableMap;


/**
 * This class defines the structure of the 'shop_customer' table.
 *
 *
 *
 * This map class is used by Propel to do runtime db structure discovery.
 * For example, the createSelectSql() method checks the type of a given column used in an
 * ORDER BY clause to know whether it needs to apply SQL to make the ORDER BY case-insensitive
 * (i.e. if it's a text column type).
 */
class CustomerTableMap extends TableMap
{
    use InstancePoolTrait;
    use TableMapTrait;

    /**
     * The (dot-path) name of this class
     */
    const CLASS_NAME = 'Models.Customer.Map.CustomerTableMap';

    /**
     * The default database name for this class
     */
    const DATABASE_NAME = 'default';

    /**
     * The table name for this class
     */
    const TABLE_NAME = 'shop_customer';

    /**
     * The related Propel class for this table
     */
    const OM_CLASS = '\\Shop\\Models\\Customer\\Customer';

    /**
     * A class that can be returned by this tableMap
     */
    const CLASS_DEFAULT = 'Models.Customer.Customer';

    /**
     * The total number of columns
     */
    const NUM_COLUMNS = 19;

    /**
     * The number of lazy-loaded columns
     */
    const NUM_LAZY_LOAD_COLUMNS = 0;

    /**
     * The number of columns to hydrate (NUM_COLUMNS - NUM_LAZY_LOAD_COLUMNS)
     */
    const NUM_HYDRATE_COLUMNS = 19;

    /**
     * the column name for the id field
     */
    const COL_ID = 'shop_customer.id';

    /**
     * the column name for the name field
     */
    const COL_NAME = 'shop_customer.name';

    /**
     * the column name for the email field
     */
    const COL_EMAIL = 'shop_customer.email';

    /**
     * the column name for the password field
     */
    const COL_PASSWORD = 'shop_customer.password';

    /**
     * the column name for the phone field
     */
    const COL_PHONE = 'shop_customer.phone';

    /**
     * the column name for the registred field
     */
    const COL_REGISTRED = 'shop_customer.registred';

    /**
     * the column name for the lastauth field
     */
    const COL_LASTAUTH = 'shop_customer.lastauth';

    /**
     * the column name for the blocked field
     */
    const COL_BLOCKED = 'shop_customer.blocked';

    /**
     * the column name for the notify_type field
     */
    const COL_NOTIFY_TYPE = 'shop_customer.notify_type';

    /**
     * the column name for the delete field
     */
    const COL_DELETE = 'shop_customer.delete';

    /**
     * the column name for the discount field
     */
    const COL_DISCOUNT = 'shop_customer.discount';

    /**
     * the column name for the inn field
     */
    const COL_INN = 'shop_customer.inn';

    /**
     * the column name for the info_hidden field
     */
    const COL_INFO_HIDDEN = 'shop_customer.info_hidden';

    /**
     * the column name for the group_id field
     */
    const COL_GROUP_ID = 'shop_customer.group_id';

    /**
     * the column name for the city_id field
     */
    const COL_CITY_ID = 'shop_customer.city_id';

    /**
     * the column name for the manager_id field
     */
    const COL_MANAGER_ID = 'shop_customer.manager_id';

    /**
     * the column name for the notify_order field
     */
    const COL_NOTIFY_ORDER = 'shop_customer.notify_order';

    /**
     * the column name for the notify_news field
     */
    const COL_NOTIFY_NEWS = 'shop_customer.notify_news';

    /**
     * the column name for the notify_products field
     */
    const COL_NOTIFY_PRODUCTS = 'shop_customer.notify_products';

    /**
     * The default string format for model objects of the related table
     */
    const DEFAULT_STRING_FORMAT = 'YAML';

    /**
     * holds an array of fieldnames
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldNames[self::TYPE_PHPNAME][0] = 'Id'
     */
    protected static $fieldNames = array (
        self::TYPE_PHPNAME       => array('Id', 'Name', 'Email', 'Password', 'Phone', 'Registred', 'Lastauth', 'Blocked', 'NotifyType', 'Delete', 'Discount', 'Inn', 'InfoHidden', 'GroupId', 'CityId', 'ManagerId', 'NotifyOrder', 'NotifyNews', 'NotifyProducts', ),
        self::TYPE_CAMELNAME     => array('id', 'name', 'email', 'password', 'phone', 'registred', 'lastauth', 'blocked', 'notifyType', 'delete', 'discount', 'inn', 'infoHidden', 'groupId', 'cityId', 'managerId', 'notifyOrder', 'notifyNews', 'notifyProducts', ),
        self::TYPE_COLNAME       => array(CustomerTableMap::COL_ID, CustomerTableMap::COL_NAME, CustomerTableMap::COL_EMAIL, CustomerTableMap::COL_PASSWORD, CustomerTableMap::COL_PHONE, CustomerTableMap::COL_REGISTRED, CustomerTableMap::COL_LASTAUTH, CustomerTableMap::COL_BLOCKED, CustomerTableMap::COL_NOTIFY_TYPE, CustomerTableMap::COL_DELETE, CustomerTableMap::COL_DISCOUNT, CustomerTableMap::COL_INN, CustomerTableMap::COL_INFO_HIDDEN, CustomerTableMap::COL_GROUP_ID, CustomerTableMap::COL_CITY_ID, CustomerTableMap::COL_MANAGER_ID, CustomerTableMap::COL_NOTIFY_ORDER, CustomerTableMap::COL_NOTIFY_NEWS, CustomerTableMap::COL_NOTIFY_PRODUCTS, ),
        self::TYPE_FIELDNAME     => array('id', 'name', 'email', 'password', 'phone', 'registred', 'lastauth', 'blocked', 'notify_type', 'delete', 'discount', 'inn', 'info_hidden', 'group_id', 'city_id', 'manager_id', 'notify_order', 'notify_news', 'notify_products', ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, )
    );

    /**
     * holds an array of keys for quick access to the fieldnames array
     *
     * first dimension keys are the type constants
     * e.g. self::$fieldKeys[self::TYPE_PHPNAME]['Id'] = 0
     */
    protected static $fieldKeys = array (
        self::TYPE_PHPNAME       => array('Id' => 0, 'Name' => 1, 'Email' => 2, 'Password' => 3, 'Phone' => 4, 'Registred' => 5, 'Lastauth' => 6, 'Blocked' => 7, 'NotifyType' => 8, 'Delete' => 9, 'Discount' => 10, 'Inn' => 11, 'InfoHidden' => 12, 'GroupId' => 13, 'CityId' => 14, 'ManagerId' => 15, 'NotifyOrder' => 16, 'NotifyNews' => 17, 'NotifyProducts' => 18, ),
        self::TYPE_CAMELNAME     => array('id' => 0, 'name' => 1, 'email' => 2, 'password' => 3, 'phone' => 4, 'registred' => 5, 'lastauth' => 6, 'blocked' => 7, 'notifyType' => 8, 'delete' => 9, 'discount' => 10, 'inn' => 11, 'infoHidden' => 12, 'groupId' => 13, 'cityId' => 14, 'managerId' => 15, 'notifyOrder' => 16, 'notifyNews' => 17, 'notifyProducts' => 18, ),
        self::TYPE_COLNAME       => array(CustomerTableMap::COL_ID => 0, CustomerTableMap::COL_NAME => 1, CustomerTableMap::COL_EMAIL => 2, CustomerTableMap::COL_PASSWORD => 3, CustomerTableMap::COL_PHONE => 4, CustomerTableMap::COL_REGISTRED => 5, CustomerTableMap::COL_LASTAUTH => 6, CustomerTableMap::COL_BLOCKED => 7, CustomerTableMap::COL_NOTIFY_TYPE => 8, CustomerTableMap::COL_DELETE => 9, CustomerTableMap::COL_DISCOUNT => 10, CustomerTableMap::COL_INN => 11, CustomerTableMap::COL_INFO_HIDDEN => 12, CustomerTableMap::COL_GROUP_ID => 13, CustomerTableMap::COL_CITY_ID => 14, CustomerTableMap::COL_MANAGER_ID => 15, CustomerTableMap::COL_NOTIFY_ORDER => 16, CustomerTableMap::COL_NOTIFY_NEWS => 17, CustomerTableMap::COL_NOTIFY_PRODUCTS => 18, ),
        self::TYPE_FIELDNAME     => array('id' => 0, 'name' => 1, 'email' => 2, 'password' => 3, 'phone' => 4, 'registred' => 5, 'lastauth' => 6, 'blocked' => 7, 'notify_type' => 8, 'delete' => 9, 'discount' => 10, 'inn' => 11, 'info_hidden' => 12, 'group_id' => 13, 'city_id' => 14, 'manager_id' => 15, 'notify_order' => 16, 'notify_news' => 17, 'notify_products' => 18, ),
        self::TYPE_NUM           => array(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, )
    );

    /**
     * Initialize the table attributes and columns
     * Relations are not initialized by this method since they are lazy loaded
     *
     * @return void
     * @throws PropelException
     */
    public function initialize()
    {
        // attributes
        $this->setName('shop_customer');
        $this->setPhpName('Customer');
        $this->setIdentifierQuoting(true);
        $this->setClassName('\\Shop\\Models\\Customer\\Customer');
        $this->setPackage('Models.Customer');
        $this->setUseIdGenerator(true);
        // columns
        $this->addPrimaryKey('id', 'Id', 'INTEGER', true, null, null);
        $this->addColumn('name', 'Name', 'VARCHAR', true, 255, null);
        $this->addColumn('email', 'Email', 'VARCHAR', true, 100, null);
        $this->addColumn('password', 'Password', 'VARCHAR', false, 100, null);
        $this->addColumn('phone', 'Phone', 'VARCHAR', true, 100, null);
        $this->addColumn('registred', 'Registred', 'TIMESTAMP', true, null, 'CURRENT_TIMESTAMP');
        $this->addColumn('lastauth', 'Lastauth', 'TIMESTAMP', false, null, null);
        $this->addColumn('blocked', 'Blocked', 'CHAR', false, null, 'N');
        $this->addColumn('notify_type', 'NotifyType', 'CHAR', false, null, 'sms_email');
        $this->addColumn('delete', 'Delete', 'TINYINT', false, null, 0);
        $this->addColumn('discount', 'Discount', 'DECIMAL', false, 19, null);
        $this->addColumn('inn', 'Inn', 'VARCHAR', false, 100, null);
        $this->addColumn('info_hidden', 'InfoHidden', 'VARCHAR', false, 255, null);
        $this->addForeignKey('group_id', 'GroupId', 'INTEGER', 'shop_customer_groups', 'id', true, null, null);
        $this->addForeignKey('city_id', 'CityId', 'INTEGER', 'shop_cities', 'id', true, null, null);
        $this->addForeignKey('manager_id', 'ManagerId', 'INTEGER', 'shop_managers', 'id', true, null, null);
        $this->addColumn('notify_order', 'NotifyOrder', 'CHAR', false, null, 'Y');
        $this->addColumn('notify_news', 'NotifyNews', 'CHAR', false, null, 'Y');
        $this->addColumn('notify_products', 'NotifyProducts', 'CHAR', false, null, 'Y');
    } // initialize()

    /**
     * Build the RelationMap objects for this table relationships
     */
    public function buildRelations()
    {
        $this->addRelation('CustomerGroup', '\\Shop\\Models\\CustomerGroup\\CustomerGroup', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':group_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('CustomerCity', '\\Shop\\Models\\City\\City', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':city_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Manager', '\\Shop\\Models\\Manager\\Manager', RelationMap::MANY_TO_ONE, array (
  0 =>
  array (
    0 => ':manager_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('CustomerSocialLogin', '\\Shop\\Models\\CustomerSocialLogin\\CustomerSocialLogin', RelationMap::ONE_TO_ONE, array (
  0 =>
  array (
    0 => ':customer_id',
    1 => ':id',
  ),
), 'CASCADE', null, null, false);
        $this->addRelation('Basket', '\\Shop\\Models\\Basket\\Basket', RelationMap::ONE_TO_ONE, array (
  0 =>
  array (
    0 => ':customer_id',
    1 => ':id',
  ),
), null, null, null, false);
        $this->addRelation('Shop', '\\Shop\\Models\\Shop\\Shop', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':contractor_id',
    1 => ':id',
  ),
), null, null, 'Shops', false);
        $this->addRelation('OrderRelatedByCustomerId', '\\Shop\\Models\\Order\\Order', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':customer_id',
    1 => ':id',
  ),
), null, null, 'OrdersRelatedByCustomerId', false);
        $this->addRelation('OrderRelatedByContractorId', '\\Shop\\Models\\Order\\Order', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':contractor_id',
    1 => ':id',
  ),
), null, null, 'OrdersRelatedByContractorId', false);
        $this->addRelation('FastLinkRelatedByOwnerCustomerId', '\\Shop\\Models\\FastLink\\FastLink', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':owner_customer_id',
    1 => ':id',
  ),
), 'CASCADE', null, 'FastLinksRelatedByOwnerCustomerId', false);
        $this->addRelation('FastLinkRelatedByCode', '\\Shop\\Models\\FastLink\\FastLink', RelationMap::ONE_TO_ONE, array (
  0 =>
  array (
    0 => ':code',
    1 => ':password',
  ),
), null, null, null, false);
        $this->addRelation('Provider', '\\Shop\\Models\\Provider\\Provider', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':contractor_id',
    1 => ':id',
  ),
), null, null, 'Providers', false);
        $this->addRelation('Score', '\\Shop\\Models\\Score\\Score', RelationMap::ONE_TO_MANY, array (
  0 =>
  array (
    0 => ':customer_id',
    1 => ':id',
  ),
), null, null, 'Scores', false);
    } // buildRelations()
    /**
     * Method to invalidate the instance pool of all tables related to shop_customer     * by a foreign key with ON DELETE CASCADE
     */
    public static function clearRelatedInstancePool()
    {
        // Invalidate objects in related instance pools,
        // since one or more of them may be deleted by ON DELETE CASCADE/SETNULL rule.
        CustomerSocialLoginTableMap::clearInstancePool();
        FastLinkTableMap::clearInstancePool();
    }

    /**
     * Retrieves a string version of the primary key from the DB resultset row that can be used to uniquely identify a row in this table.
     *
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, a serialize()d version of the primary key will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return string The primary key hash of the row
     */
    public static function getPrimaryKeyHashFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        // If the PK cannot be derived from the row, return NULL.
        if ($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] === null) {
            return null;
        }

        return null === $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] || is_scalar($row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)]) || is_callable([$row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)], '__toString']) ? (string) $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)] : $row[TableMap::TYPE_NUM == $indexType ? 0 + $offset : static::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
    }

    /**
     * Retrieves the primary key from the DB resultset row
     * For tables with a single-column primary key, that simple pkey value will be returned.  For tables with
     * a multi-column primary key, an array of the primary key columns will be returned.
     *
     * @param array  $row       resultset row.
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM
     *
     * @return mixed The primary key of the row
     */
    public static function getPrimaryKeyFromRow($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        return (int) $row[
            $indexType == TableMap::TYPE_NUM
                ? 0 + $offset
                : self::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)
        ];
    }

    /**
     * The class that the tableMap will make instances of.
     *
     * If $withPrefix is true, the returned path
     * uses a dot-path notation which is translated into a path
     * relative to a location on the PHP include_path.
     * (e.g. path.to.MyClass -> 'path/to/MyClass.php')
     *
     * @param boolean $withPrefix Whether or not to return the path with the class name
     * @return string path.to.ClassName
     */
    public static function getOMClass($withPrefix = true)
    {
        return $withPrefix ? CustomerTableMap::CLASS_DEFAULT : CustomerTableMap::OM_CLASS;
    }

    /**
     * Populates an object of the default type or an object that inherit from the default.
     *
     * @param array  $row       row returned by DataFetcher->fetch().
     * @param int    $offset    The 0-based offset for reading from the resultset row.
     * @param string $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                 One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                           TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     * @return array           (Customer object, last column rank)
     */
    public static function populateObject($row, $offset = 0, $indexType = TableMap::TYPE_NUM)
    {
        $key = CustomerTableMap::getPrimaryKeyHashFromRow($row, $offset, $indexType);
        if (null !== ($obj = CustomerTableMap::getInstanceFromPool($key))) {
            // We no longer rehydrate the object, since this can cause data loss.
            // See http://www.propelorm.org/ticket/509
            // $obj->hydrate($row, $offset, true); // rehydrate
            $col = $offset + CustomerTableMap::NUM_HYDRATE_COLUMNS;
        } else {
            $cls = CustomerTableMap::OM_CLASS;
            /** @var Customer $obj */
            $obj = new $cls();
            $col = $obj->hydrate($row, $offset, false, $indexType);
            CustomerTableMap::addInstanceToPool($obj, $key);
        }

        return array($obj, $col);
    }

    /**
     * The returned array will contain objects of the default type or
     * objects that inherit from the default.
     *
     * @param DataFetcherInterface $dataFetcher
     * @return array
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function populateObjects(DataFetcherInterface $dataFetcher)
    {
        $results = array();

        // set the class once to avoid overhead in the loop
        $cls = static::getOMClass(false);
        // populate the object(s)
        while ($row = $dataFetcher->fetch()) {
            $key = CustomerTableMap::getPrimaryKeyHashFromRow($row, 0, $dataFetcher->getIndexType());
            if (null !== ($obj = CustomerTableMap::getInstanceFromPool($key))) {
                // We no longer rehydrate the object, since this can cause data loss.
                // See http://www.propelorm.org/ticket/509
                // $obj->hydrate($row, 0, true); // rehydrate
                $results[] = $obj;
            } else {
                /** @var Customer $obj */
                $obj = new $cls();
                $obj->hydrate($row);
                $results[] = $obj;
                CustomerTableMap::addInstanceToPool($obj, $key);
            } // if key exists
        }

        return $results;
    }
    /**
     * Add all the columns needed to create a new object.
     *
     * Note: any columns that were marked with lazyLoad="true" in the
     * XML schema will not be added to the select list and only loaded
     * on demand.
     *
     * @param Criteria $criteria object containing the columns to add.
     * @param string   $alias    optional table alias
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function addSelectColumns(Criteria $criteria, $alias = null)
    {
        if (null === $alias) {
            $criteria->addSelectColumn(CustomerTableMap::COL_ID);
            $criteria->addSelectColumn(CustomerTableMap::COL_NAME);
            $criteria->addSelectColumn(CustomerTableMap::COL_EMAIL);
            $criteria->addSelectColumn(CustomerTableMap::COL_PASSWORD);
            $criteria->addSelectColumn(CustomerTableMap::COL_PHONE);
            $criteria->addSelectColumn(CustomerTableMap::COL_REGISTRED);
            $criteria->addSelectColumn(CustomerTableMap::COL_LASTAUTH);
            $criteria->addSelectColumn(CustomerTableMap::COL_BLOCKED);
            $criteria->addSelectColumn(CustomerTableMap::COL_NOTIFY_TYPE);
            $criteria->addSelectColumn(CustomerTableMap::COL_DELETE);
            $criteria->addSelectColumn(CustomerTableMap::COL_DISCOUNT);
            $criteria->addSelectColumn(CustomerTableMap::COL_INN);
            $criteria->addSelectColumn(CustomerTableMap::COL_INFO_HIDDEN);
            $criteria->addSelectColumn(CustomerTableMap::COL_GROUP_ID);
            $criteria->addSelectColumn(CustomerTableMap::COL_CITY_ID);
            $criteria->addSelectColumn(CustomerTableMap::COL_MANAGER_ID);
            $criteria->addSelectColumn(CustomerTableMap::COL_NOTIFY_ORDER);
            $criteria->addSelectColumn(CustomerTableMap::COL_NOTIFY_NEWS);
            $criteria->addSelectColumn(CustomerTableMap::COL_NOTIFY_PRODUCTS);
        } else {
            $criteria->addSelectColumn($alias . '.id');
            $criteria->addSelectColumn($alias . '.name');
            $criteria->addSelectColumn($alias . '.email');
            $criteria->addSelectColumn($alias . '.password');
            $criteria->addSelectColumn($alias . '.phone');
            $criteria->addSelectColumn($alias . '.registred');
            $criteria->addSelectColumn($alias . '.lastauth');
            $criteria->addSelectColumn($alias . '.blocked');
            $criteria->addSelectColumn($alias . '.notify_type');
            $criteria->addSelectColumn($alias . '.delete');
            $criteria->addSelectColumn($alias . '.discount');
            $criteria->addSelectColumn($alias . '.inn');
            $criteria->addSelectColumn($alias . '.info_hidden');
            $criteria->addSelectColumn($alias . '.group_id');
            $criteria->addSelectColumn($alias . '.city_id');
            $criteria->addSelectColumn($alias . '.manager_id');
            $criteria->addSelectColumn($alias . '.notify_order');
            $criteria->addSelectColumn($alias . '.notify_news');
            $criteria->addSelectColumn($alias . '.notify_products');
        }
    }

    /**
     * Returns the TableMap related to this object.
     * This method is not needed for general use but a specific application could have a need.
     * @return TableMap
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function getTableMap()
    {
        return Propel::getServiceContainer()->getDatabaseMap(CustomerTableMap::DATABASE_NAME)->getTable(CustomerTableMap::TABLE_NAME);
    }

    /**
     * Add a TableMap instance to the database for this tableMap class.
     */
    public static function buildTableMap()
    {
        $dbMap = Propel::getServiceContainer()->getDatabaseMap(CustomerTableMap::DATABASE_NAME);
        if (!$dbMap->hasTable(CustomerTableMap::TABLE_NAME)) {
            $dbMap->addTableObject(new CustomerTableMap());
        }
    }

    /**
     * Performs a DELETE on the database, given a Customer or Criteria object OR a primary key value.
     *
     * @param mixed               $values Criteria or Customer object or primary key or array of primary keys
     *              which is used to create the DELETE statement
     * @param  ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
     public static function doDelete($values, ConnectionInterface $con = null)
     {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CustomerTableMap::DATABASE_NAME);
        }

        if ($values instanceof Criteria) {
            // rename for clarity
            $criteria = $values;
        } elseif ($values instanceof \Shop\Models\Customer\Customer) { // it's a model object
            // create criteria based on pk values
            $criteria = $values->buildPkeyCriteria();
        } else { // it's a primary key, or an array of pks
            $criteria = new Criteria(CustomerTableMap::DATABASE_NAME);
            $criteria->add(CustomerTableMap::COL_ID, (array) $values, Criteria::IN);
        }

        $query = CustomerQuery::create()->mergeWith($criteria);

        if ($values instanceof Criteria) {
            CustomerTableMap::clearInstancePool();
        } elseif (!is_object($values)) { // it's a primary key, or an array of pks
            foreach ((array) $values as $singleval) {
                CustomerTableMap::removeInstanceFromPool($singleval);
            }
        }

        return $query->delete($con);
    }

    /**
     * Deletes all rows from the shop_customer table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public static function doDeleteAll(ConnectionInterface $con = null)
    {
        return CustomerQuery::create()->doDeleteAll($con);
    }

    /**
     * Performs an INSERT on the database, given a Customer or Criteria object.
     *
     * @param mixed               $criteria Criteria or Customer object containing data that is used to create the INSERT statement.
     * @param ConnectionInterface $con the ConnectionInterface connection to use
     * @return mixed           The new primary key.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public static function doInsert($criteria, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(CustomerTableMap::DATABASE_NAME);
        }

        if ($criteria instanceof Criteria) {
            $criteria = clone $criteria; // rename for clarity
        } else {
            $criteria = $criteria->buildCriteria(); // build Criteria from Customer object
        }

        if ($criteria->containsKey(CustomerTableMap::COL_ID) && $criteria->keyContainsValue(CustomerTableMap::COL_ID) ) {
            throw new PropelException('Cannot insert a value for auto-increment primary key ('.CustomerTableMap::COL_ID.')');
        }


        // Set the correct dbName
        $query = CustomerQuery::create()->mergeWith($criteria);

        // use transaction because $criteria could contain info
        // for more than one table (I guess, conceivably)
        return $con->transaction(function () use ($con, $query) {
            return $query->doInsert($con);
        });
    }

} // CustomerTableMap
// This is the static code needed to register the TableMap for this table with the main Propel class.
//
CustomerTableMap::buildTableMap();
