<?php

namespace Shop\Domain\CustomerGroup;

use Core\Repository\DropDownInterface;
use Repo\Concrete\AbstractCollection;
use Shop\Domain\CustomerGroup\Contracts\CustomerGroupEntityInterface;

/**
* Description of CustomerGroup
*
* @author Diamond Code Generator
*/
class CustomerGroupCollection extends AbstractCollection implements DropDownInterface
{

    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return CustomerGroupEntityInterface::class;
    }

    public function getDropdownList(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity){
            $ar[$entity->getId()] = $entity->getName();
        }

        return $ar;
    }


}               