<?php

namespace Shop\Domain\Catalog;

use Core\Repository\DropDownInterface;
use Repo\Concrete\AbstractCollection;
use Shop\Domain\Catalog\Contracts\CatalogEntityInterface;

/**
* Description of Catalog
*
* @author Diamond Code Generator
*/
class CatalogCollection extends AbstractCollection implements DropDownInterface
{

    /**
     * @return string
     */
    protected function getEntityClass(): string
    {
        return CatalogEntityInterface::class;
    }

    /**
     * @return array
     */
    public function getDropdownList(): array
    {
        $ar = [];
        foreach ($this->_entities as $entity){
            $ar[$entity->getId()] = $entity->getName();
        }

        return $ar;
    }
}               