<?php


namespace Shop\Application\Analytics;


use Shop\Application\Analytics\CreateTransaction\CreateTransactionCommand;
use Shop\Domain\CustomerOrder\Contracts\CustomerOrderEntityInterface;
use spaceonfire\CommandBus\CommandBus;

class AnalyticsService
{
    protected $commandBus;

    /**
     * AnalyticsService constructor.
     * @param CommandBus $commandBus
     */
    public function __construct(CommandBus $commandBus)
    {
        $this->commandBus = $commandBus;
    }

    /**
     * @param CustomerOrderEntityInterface $order
     */
    public function createOrderTransaction(CustomerOrderEntityInterface $order): void
    {
        $this->commandBus->handle(new CreateTransactionCommand($order));
    }

}