<?php

namespace Shop\Modules\AdminStockSettings;

use Core\Form\ControlBuilder;
use Core\Form\FormBuilder;
use Core\ModuleController;
use Shop\Config\Main;

/**
 * Description of AdminStockSettings
 *
 * @author Diamond Code Generator
 */
class AdminStockSettings extends ModuleController
{

    protected $form;
    protected $controlBuilder;
    protected $mainConf;

    /**
     * AdminStockSettings constructor.
     * @param FormBuilder $form
     * @param ControlBuilder $controlBuilder
     * @param Main $mainConf
     */
    public function __construct(FormBuilder $form, ControlBuilder $controlBuilder, Main $mainConf)
    {
        $this->form = $form;
        $this->controlBuilder = $controlBuilder;
        $this->mainConf = $mainConf;
    }

    /**
     * @return string
     * @throws \Core\Exceptions\BaseException
     */
    public function process(): string
    {
        $form = $this->form->buildSettingsForm($this->mainConf, 'main');
        $builder = $this->controlBuilder;

        $form->addField(
            $builder->buildInputSmall('stockImagePath'),
            'Путь для изображений торг.точек',
            'required','относительно каталога upload'
        );

        return $form->render();
    }
}               