<?php

namespace Shop\Models\ComplexRate\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\ComplexRate\ComplexRate as ChildComplexRate;
use Shop\Models\ComplexRate\ComplexRateQuery as ChildComplexRateQuery;
use Shop\Models\ComplexRate\Map\ComplexRateTableMap;

/**
 * Base class that represents a query for the 'shop_complex_rates' table.
 *
 *
 *
 * @method     ChildComplexRateQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildComplexRateQuery orderByBrandId($order = Criteria::ASC) Order by the brand_id column
 * @method     ChildComplexRateQuery orderByCustomerGroupId($order = Criteria::ASC) Order by the customer_group_id column
 * @method     ChildComplexRateQuery orderByCustomerId($order = Criteria::ASC) Order by the customer_id column
 * @method     ChildComplexRateQuery orderByShopId($order = Criteria::ASC) Order by the shop_id column
 * @method     ChildComplexRateQuery orderByCategoryId($order = Criteria::ASC) Order by the category_id column
 * @method     ChildComplexRateQuery orderByPricelistSheetId($order = Criteria::ASC) Order by the pricelist_sheet_id column
 * @method     ChildComplexRateQuery orderByRate($order = Criteria::ASC) Order by the rate column
 * @method     ChildComplexRateQuery orderByPriority($order = Criteria::ASC) Order by the priority column
 * @method     ChildComplexRateQuery orderByActive($order = Criteria::ASC) Order by the active column
 *
 * @method     ChildComplexRateQuery groupById() Group by the id column
 * @method     ChildComplexRateQuery groupByBrandId() Group by the brand_id column
 * @method     ChildComplexRateQuery groupByCustomerGroupId() Group by the customer_group_id column
 * @method     ChildComplexRateQuery groupByCustomerId() Group by the customer_id column
 * @method     ChildComplexRateQuery groupByShopId() Group by the shop_id column
 * @method     ChildComplexRateQuery groupByCategoryId() Group by the category_id column
 * @method     ChildComplexRateQuery groupByPricelistSheetId() Group by the pricelist_sheet_id column
 * @method     ChildComplexRateQuery groupByRate() Group by the rate column
 * @method     ChildComplexRateQuery groupByPriority() Group by the priority column
 * @method     ChildComplexRateQuery groupByActive() Group by the active column
 *
 * @method     ChildComplexRateQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildComplexRateQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildComplexRateQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildComplexRateQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildComplexRateQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildComplexRateQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildComplexRate findOne(ConnectionInterface $con = null) Return the first ChildComplexRate matching the query
 * @method     ChildComplexRate findOneOrCreate(ConnectionInterface $con = null) Return the first ChildComplexRate matching the query, or a new ChildComplexRate object populated from the query conditions when no match is found
 *
 * @method     ChildComplexRate findOneById(int $id) Return the first ChildComplexRate filtered by the id column
 * @method     ChildComplexRate findOneByBrandId(string $brand_id) Return the first ChildComplexRate filtered by the brand_id column
 * @method     ChildComplexRate findOneByCustomerGroupId(string $customer_group_id) Return the first ChildComplexRate filtered by the customer_group_id column
 * @method     ChildComplexRate findOneByCustomerId(string $customer_id) Return the first ChildComplexRate filtered by the customer_id column
 * @method     ChildComplexRate findOneByShopId(string $shop_id) Return the first ChildComplexRate filtered by the shop_id column
 * @method     ChildComplexRate findOneByCategoryId(string $category_id) Return the first ChildComplexRate filtered by the category_id column
 * @method     ChildComplexRate findOneByPricelistSheetId(string $pricelist_sheet_id) Return the first ChildComplexRate filtered by the pricelist_sheet_id column
 * @method     ChildComplexRate findOneByRate(string $rate) Return the first ChildComplexRate filtered by the rate column
 * @method     ChildComplexRate findOneByPriority(int $priority) Return the first ChildComplexRate filtered by the priority column
 * @method     ChildComplexRate findOneByActive(int $active) Return the first ChildComplexRate filtered by the active column *

 * @method     ChildComplexRate requirePk($key, ConnectionInterface $con = null) Return the ChildComplexRate by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildComplexRate requireOne(ConnectionInterface $con = null) Return the first ChildComplexRate matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildComplexRate requireOneById(int $id) Return the first ChildComplexRate filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildComplexRate requireOneByBrandId(string $brand_id) Return the first ChildComplexRate filtered by the brand_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildComplexRate requireOneByCustomerGroupId(string $customer_group_id) Return the first ChildComplexRate filtered by the customer_group_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildComplexRate requireOneByCustomerId(string $customer_id) Return the first ChildComplexRate filtered by the customer_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildComplexRate requireOneByShopId(string $shop_id) Return the first ChildComplexRate filtered by the shop_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildComplexRate requireOneByCategoryId(string $category_id) Return the first ChildComplexRate filtered by the category_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildComplexRate requireOneByPricelistSheetId(string $pricelist_sheet_id) Return the first ChildComplexRate filtered by the pricelist_sheet_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildComplexRate requireOneByRate(string $rate) Return the first ChildComplexRate filtered by the rate column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildComplexRate requireOneByPriority(int $priority) Return the first ChildComplexRate filtered by the priority column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildComplexRate requireOneByActive(int $active) Return the first ChildComplexRate filtered by the active column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildComplexRate[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildComplexRate objects based on current ModelCriteria
 * @method     ChildComplexRate[]|ObjectCollection findById(int $id) Return ChildComplexRate objects filtered by the id column
 * @method     ChildComplexRate[]|ObjectCollection findByBrandId(string $brand_id) Return ChildComplexRate objects filtered by the brand_id column
 * @method     ChildComplexRate[]|ObjectCollection findByCustomerGroupId(string $customer_group_id) Return ChildComplexRate objects filtered by the customer_group_id column
 * @method     ChildComplexRate[]|ObjectCollection findByCustomerId(string $customer_id) Return ChildComplexRate objects filtered by the customer_id column
 * @method     ChildComplexRate[]|ObjectCollection findByShopId(string $shop_id) Return ChildComplexRate objects filtered by the shop_id column
 * @method     ChildComplexRate[]|ObjectCollection findByCategoryId(string $category_id) Return ChildComplexRate objects filtered by the category_id column
 * @method     ChildComplexRate[]|ObjectCollection findByPricelistSheetId(string $pricelist_sheet_id) Return ChildComplexRate objects filtered by the pricelist_sheet_id column
 * @method     ChildComplexRate[]|ObjectCollection findByRate(string $rate) Return ChildComplexRate objects filtered by the rate column
 * @method     ChildComplexRate[]|ObjectCollection findByPriority(int $priority) Return ChildComplexRate objects filtered by the priority column
 * @method     ChildComplexRate[]|ObjectCollection findByActive(int $active) Return ChildComplexRate objects filtered by the active column
 * @method     ChildComplexRate[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class ComplexRateQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Models\ComplexRate\Base\ComplexRateQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\ComplexRate\\ComplexRate', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildComplexRateQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildComplexRateQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildComplexRateQuery) {
            return $criteria;
        }
        $query = new ChildComplexRateQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildComplexRate|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(ComplexRateTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = ComplexRateTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildComplexRate A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `brand_id`, `customer_group_id`, `customer_id`, `shop_id`, `category_id`, `pricelist_sheet_id`, `rate`, `priority`, `active` FROM `shop_complex_rates` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildComplexRate $obj */
            $obj = new ChildComplexRate();
            $obj->hydrate($row);
            ComplexRateTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildComplexRate|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildComplexRateQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(ComplexRateTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildComplexRateQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(ComplexRateTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildComplexRateQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(ComplexRateTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(ComplexRateTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ComplexRateTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the brand_id column
     *
     * Example usage:
     * <code>
     * $query->filterByBrandId('fooValue');   // WHERE brand_id = 'fooValue'
     * $query->filterByBrandId('%fooValue%', Criteria::LIKE); // WHERE brand_id LIKE '%fooValue%'
     * </code>
     *
     * @param     string $brandId The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildComplexRateQuery The current query, for fluid interface
     */
    public function filterByBrandId($brandId = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($brandId)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ComplexRateTableMap::COL_BRAND_ID, $brandId, $comparison);
    }

    /**
     * Filter the query on the customer_group_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCustomerGroupId('fooValue');   // WHERE customer_group_id = 'fooValue'
     * $query->filterByCustomerGroupId('%fooValue%', Criteria::LIKE); // WHERE customer_group_id LIKE '%fooValue%'
     * </code>
     *
     * @param     string $customerGroupId The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildComplexRateQuery The current query, for fluid interface
     */
    public function filterByCustomerGroupId($customerGroupId = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($customerGroupId)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ComplexRateTableMap::COL_CUSTOMER_GROUP_ID, $customerGroupId, $comparison);
    }

    /**
     * Filter the query on the customer_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCustomerId('fooValue');   // WHERE customer_id = 'fooValue'
     * $query->filterByCustomerId('%fooValue%', Criteria::LIKE); // WHERE customer_id LIKE '%fooValue%'
     * </code>
     *
     * @param     string $customerId The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildComplexRateQuery The current query, for fluid interface
     */
    public function filterByCustomerId($customerId = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($customerId)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ComplexRateTableMap::COL_CUSTOMER_ID, $customerId, $comparison);
    }

    /**
     * Filter the query on the shop_id column
     *
     * Example usage:
     * <code>
     * $query->filterByShopId('fooValue');   // WHERE shop_id = 'fooValue'
     * $query->filterByShopId('%fooValue%', Criteria::LIKE); // WHERE shop_id LIKE '%fooValue%'
     * </code>
     *
     * @param     string $shopId The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildComplexRateQuery The current query, for fluid interface
     */
    public function filterByShopId($shopId = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($shopId)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ComplexRateTableMap::COL_SHOP_ID, $shopId, $comparison);
    }

    /**
     * Filter the query on the category_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCategoryId('fooValue');   // WHERE category_id = 'fooValue'
     * $query->filterByCategoryId('%fooValue%', Criteria::LIKE); // WHERE category_id LIKE '%fooValue%'
     * </code>
     *
     * @param     string $categoryId The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildComplexRateQuery The current query, for fluid interface
     */
    public function filterByCategoryId($categoryId = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($categoryId)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ComplexRateTableMap::COL_CATEGORY_ID, $categoryId, $comparison);
    }

    /**
     * Filter the query on the pricelist_sheet_id column
     *
     * Example usage:
     * <code>
     * $query->filterByPricelistSheetId('fooValue');   // WHERE pricelist_sheet_id = 'fooValue'
     * $query->filterByPricelistSheetId('%fooValue%', Criteria::LIKE); // WHERE pricelist_sheet_id LIKE '%fooValue%'
     * </code>
     *
     * @param     string $pricelistSheetId The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildComplexRateQuery The current query, for fluid interface
     */
    public function filterByPricelistSheetId($pricelistSheetId = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($pricelistSheetId)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ComplexRateTableMap::COL_PRICELIST_SHEET_ID, $pricelistSheetId, $comparison);
    }

    /**
     * Filter the query on the rate column
     *
     * Example usage:
     * <code>
     * $query->filterByRate(1234); // WHERE rate = 1234
     * $query->filterByRate(array(12, 34)); // WHERE rate IN (12, 34)
     * $query->filterByRate(array('min' => 12)); // WHERE rate > 12
     * </code>
     *
     * @param     mixed $rate The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildComplexRateQuery The current query, for fluid interface
     */
    public function filterByRate($rate = null, $comparison = null)
    {
        if (is_array($rate)) {
            $useMinMax = false;
            if (isset($rate['min'])) {
                $this->addUsingAlias(ComplexRateTableMap::COL_RATE, $rate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($rate['max'])) {
                $this->addUsingAlias(ComplexRateTableMap::COL_RATE, $rate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ComplexRateTableMap::COL_RATE, $rate, $comparison);
    }

    /**
     * Filter the query on the priority column
     *
     * Example usage:
     * <code>
     * $query->filterByPriority(1234); // WHERE priority = 1234
     * $query->filterByPriority(array(12, 34)); // WHERE priority IN (12, 34)
     * $query->filterByPriority(array('min' => 12)); // WHERE priority > 12
     * </code>
     *
     * @param     mixed $priority The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildComplexRateQuery The current query, for fluid interface
     */
    public function filterByPriority($priority = null, $comparison = null)
    {
        if (is_array($priority)) {
            $useMinMax = false;
            if (isset($priority['min'])) {
                $this->addUsingAlias(ComplexRateTableMap::COL_PRIORITY, $priority['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($priority['max'])) {
                $this->addUsingAlias(ComplexRateTableMap::COL_PRIORITY, $priority['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ComplexRateTableMap::COL_PRIORITY, $priority, $comparison);
    }

    /**
     * Filter the query on the active column
     *
     * Example usage:
     * <code>
     * $query->filterByActive(1234); // WHERE active = 1234
     * $query->filterByActive(array(12, 34)); // WHERE active IN (12, 34)
     * $query->filterByActive(array('min' => 12)); // WHERE active > 12
     * </code>
     *
     * @param     mixed $active The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildComplexRateQuery The current query, for fluid interface
     */
    public function filterByActive($active = null, $comparison = null)
    {
        if (is_array($active)) {
            $useMinMax = false;
            if (isset($active['min'])) {
                $this->addUsingAlias(ComplexRateTableMap::COL_ACTIVE, $active['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($active['max'])) {
                $this->addUsingAlias(ComplexRateTableMap::COL_ACTIVE, $active['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(ComplexRateTableMap::COL_ACTIVE, $active, $comparison);
    }

    /**
     * Exclude object from result
     *
     * @param   ChildComplexRate $complexRate Object to remove from the list of results
     *
     * @return $this|ChildComplexRateQuery The current query, for fluid interface
     */
    public function prune($complexRate = null)
    {
        if ($complexRate) {
            $this->addUsingAlias(ComplexRateTableMap::COL_ID, $complexRate->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_complex_rates table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ComplexRateTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            ComplexRateTableMap::clearInstancePool();
            ComplexRateTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(ComplexRateTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(ComplexRateTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            ComplexRateTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            ComplexRateTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // ComplexRateQuery
