<?php


namespace Shop\Repositories\SyncLog;


use Diamond\Repositories\PropelAbstractRepository;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Repo\CollectionInterface;
use Repo\CrudRepositoryBuilderInterface;
use Repo\EntityInterface;
use Repo\PaginationInterface;
use Shop\Domain\SyncLog\SyncLogCollection;
use Shop\Models\SyncLog\SyncLog;
use Shop\Models\SyncLog\SyncLogQuery;
use Shop\Models\SyncLogs\SyncLogs;
use Shop\Models\SyncLogs\SyncLogsQuery;

class SyncLogRepository extends PropelAbstractRepository implements CrudRepositoryBuilderInterface
{
    /**
     * @return EntityInterface
     */
    public static function createEntity(): EntityInterface
    {
        return new SyncLog();
    }

    protected function createQuery(): ModelCriteria
    {
        return SyncLogQuery::create();
    }

    /**
     * @param PaginationInterface $criteria
     * @param ModelCriteria $dbCriteria
     */
    protected function modifyCriteria(PaginationInterface $criteria, ModelCriteria $dbCriteria): void
    {
        $this->modifyCriteriaForFilterSort($criteria,$dbCriteria);

        $dbCriteria
            ->_if($criteria->getFilterByOrderId()!==null)
            ->filterByOrderId($criteria->getFilterByOrderId())
            ->_endif();
    }

    /**
     * @param PaginationInterface $criteria
     * @return CollectionInterface
     * @throws \Repo\Concrete\Exceptions\Collection
     */
    public function findByCriteria(PaginationInterface $criteria): CollectionInterface
    {
        $query = $this->createQuery();
        $this->modifyCriteria($criteria, $query);
        $result = $query->paginate($criteria->getPage(), $criteria->getLimit());

        $collection = new SyncLogCollection();

        foreach ($result->getResults() as $row) {
            $collection->push($row);
        }

        return $collection;
    }

}