<?php

namespace Shop\Models\OrderItem;

use Shop\Domain\OrderItem\Contracts\OrderItemEntityInterface;
use Shop\Domain\ProviderOrderItem\Contracts\ProviderOrderItemEntityInterface;
use Shop\Models\OrderItem\Base\OrderItem as BaseOrderItem;

/**
 * Skeleton subclass for representing a row from the 'shop_order_items' table.
 *
 *
 *
 * You should add additional methods to this class to meet the
 * application requirements.  This class will only be generated as
 * long as it does not already exist in the output directory.
 *
 */
class OrderItem extends BaseOrderItem implements OrderItemEntityInterface,ProviderOrderItemEntityInterface
{

    /**
     * summ
     * @return float
     */
    public function getSumm():float
    {
        return (float) $this->getPrice() * $this->getAmount();
    }
}
