<?php

namespace Shop\Domain\Customer\Contracts;

use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;
use Shop\Repositories\Customer\CustomerCriteria;

interface CustomerCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface
{

    /**
     * @return bool|null
     */
    public function getFilterByBlocked():?bool ;

    /**
     * @return string|null
     */
    public function getFilterByEmail(): ?string;

    /**
     * @return string|null
     */
    public function getFilterByPassword(): ?string;

    /**
     * @return string|null
     */
    public function getSortByEmail(): ?string;


    /**
     * @return int|null
     */
    public function getFilterByGroupId(): ?int;

    public function setFilterByGroupId(?int $id);

    /**
     * @return array|null
     */
    public function getFilterByGroupIds(): ?array;

    public function setFilterByGroupIds(?array $ids);

    /**
     * @return string|null
     */
    public function getSearchByEmail(): ?string;

    /**
     * @return string|null
     */
    public function getSearchByName(): ?string;

    /**
     * @return int|null
     */
    public function getFilterByStockId(): ?int;

    public function getSortByRegistred(): ?string;

    public function setSortByRegistred(?string $order);

    public function setFilterByManagerId(?int $filterByManagerId): CustomerCriteriaInterface;

    public function getFilterByManagerId(): ?int;
}