<?php

namespace Shop\Domain\Stock\Contracts;

use Diamond\Domain\Site\Contracts\SiteFilterInterface;
use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;
use Shop\Repositories\Stock\StockCriteria;

/**
 * Description of Stock
 *
 * @author Diamond Code Generator
 */
interface StockCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface, SiteFilterInterface
{
    public function getFilterByContractorId(): ?int;

    public function getFilterByType(): ?string;

    public function getFilterByTypes(): ?array;

    public function getSortByTitle(): ?string;

    public function setFilterBySiteId(?int $domainId): StockCriteriaInterface;

    public function getFilterBySiteId(): ?int;

    public function getFilterByCityId(): ?int;

    public function setFilterByCityId(?int $id): StockCriteriaInterface;

    public function getFilterByActive(): ?bool;

    public function setFilterByActive(?bool $v): StockCriteriaInterface;

    public function setFilterByParentId(?int $id): StockCriteriaInterface;

    public function getFilterByParentId(): ?int;

    public function getFilterByRegionId(): ?int;

    public function setFilterByRegionId(?int $filterByRegionId): StockCriteriaInterface;

    public function asTreeView(): bool;

    public function setFilterByTypes(?array $filterByTypes): StockCriteriaInterface;

    public function setSortByTitle(?string $sortByName): StockCriteriaInterface;

    public function setFilterByType(?string $filterByType): StockCriteriaInterface;

    public function setFilterByContractorId(?int $filterByContractorId): StockCriteriaInterface;

    public function getSearchByTitle(): ?string;

    public function setSearchByTitle(?string $searchByTitle): StockCriteriaInterface;
}           