<?php

use Propel\Generator\Manager\MigrationManager;

/**
 * Data object containing the SQL and PHP code to migrate the database
 * up to version 1603523298.
 * Generated on 2020-10-24 10:08:18
 */
class PropelMigration_1603542907
{
    public $comment = '';

    public function preUp(MigrationManager $manager)
    {


    }

    public function postUp(MigrationManager $manager)
    {
        //delete
        \Diamond\Models\Menu\MenuQuery::create()->filterByName('admin-shop-customers')->delete();

        //add new
        $baseMenu = (new \Diamond\Models\Menu\Menu)
            ->setDomainId(1)
            ->setName('admin-shop-customers')
            ->setActive('Y');

        $customerMenu = $baseMenu
            ->copy()
            ->setTitle('Клиенты');

        $customerMenu->save();

        $baseMenu
            ->copy()
            ->setParentId($customerMenu->getId())
            ->setUrl('/admin/shop/customers/customers')
            ->setTitle('Справочник клиентов')
            ->save();

        $baseMenu
            ->copy()
            ->setParentId($customerMenu->getId())
            ->setUrl('/admin/shop/customers/customer_groups')
            ->setTitle('Группы клиентов')
            ->save();

        $baseMenu
            ->copy()
            ->setParentId($customerMenu->getId())
            ->setUrl('/admin/shop/customers/guests')
            ->setTitle('Гости')
            ->save();

        $orderMenu = $baseMenu
            ->copy()
            ->setTitle('Заказы клиентов');

        $orderMenu->save();

        $baseMenu
            ->copy()
            ->setParentId($orderMenu->getId())
            ->setUrl('/admin/shop/customers/orders')
            ->setTitle('Список заказов')
            ->save();

        $baseMenu
            ->copy()
            ->setParentId($orderMenu->getId())
            ->setUrl('/admin/shop/customers/order_items')
            ->setTitle('Содержимое заказов')
            ->save();

        $orderMenu = $baseMenu
            ->copy()
            ->setTitle('Заказы поставщикам');

        $orderMenu->save();

        $baseMenu
            ->copy()
            ->setParentId($orderMenu->getId())
            ->setUrl('/admin/shop/customers/provider_orders')
            ->setTitle('Список заказов')
            ->save();

        $baseMenu
            ->copy()
            ->setParentId($orderMenu->getId())
            ->setUrl('/admin/shop/customers/provider_order_items')
            ->setTitle('Содержимое заказов')
            ->save();

        $baseMenu
            ->copy()
            ->setUrl('/admin/shop/customers/settings')
            ->setTitle('Настройки')
            ->save();

        \Diamond\Models\Menu\MenuQuery::create()->filterByName('admin-shop-stocks')->delete();

        $baseMenu = (new \Diamond\Models\Menu\Menu)
            ->setDomainId(1)
            ->setName('admin-shop-stocks')
            ->setActive('Y');

        $baseMenu
            ->copy()
            ->setUrl('/admin/shop/stocks/providers')
            ->setTitle('Поставщики')
            ->save();

        $baseMenu
            ->copy()
            ->setUrl('/admin/shop/stocks/stocks')
            ->setTitle('Торговые точки')
            ->save();

        $baseMenu
            ->copy()
            ->setUrl('/admin/shop/stocks/contractors')
            ->setTitle('Контрагенты')
            ->save();

        $baseMenu
            ->copy()
            ->setUrl('/admin/shop/stocks/managers')
            ->setTitle('Менеджеры')
            ->save();

        $baseMenu
            ->copy()
            ->setUrl('/admin/shop/stocks/settings')
            ->setTitle('Настройки')
            ->save();

        \Diamond\Models\Menu\MenuQuery::create()->filterByName('admin-shop-catalog')->delete();

        $baseMenu = (new \Diamond\Models\Menu\Menu)
            ->setDomainId(1)
            ->setName('admin-shop-catalog')
            ->setActive('Y');

        $baseMenu
            ->copy()
            ->setUrl('/admin/shop/catalog/brands')
            ->setTitle('Производители')
            ->save()
            ;

        $products = $baseMenu
            ->copy()
            ->setTitle('Каталог товаров');

        $products->save();

        $baseMenu
            ->copy()
            ->setParentId($products->getId())
            ->setUrl('/admin/shop/catalog/products')
            ->setTitle('Товары')
            ->save();

        $baseMenu
            ->copy()
            ->setParentId($products->getId())
            ->setUrl('/admin/shop/catalog/groups')
            ->setTitle('Группы товаров')
            ->save();

        $baseMenu
            ->copy()
            ->setParentId($products->getId())
            ->setUrl('/admin/shop/catalog/categories')
            ->setTitle('Разделы каталога')
            ->save();

        $prices = $baseMenu
            ->copy()
            ->setTitle('Прайс-листы');

        $prices->save();

        $baseMenu
            ->copy()
            ->setParentId($prices->getId())
            ->setUrl('/admin/shop/catalog/price-files')
            ->setTitle('Прайс-файлы')
            ->save();

        $baseMenu
            ->copy()
            ->setParentId($prices->getId())
            ->setUrl('/admin/shop/catalog/price-scheets')
            ->setTitle('Прайс-листы')
            ->save();

        $baseMenu
            ->copy()
            ->setParentId($prices->getId())
            ->setUrl('/admin/shop/catalog/positions')
            ->setTitle('Содержимое прайс-листов')
            ->save();

        $baseMenu
            ->copy()
            ->setParentId($prices->getId())
            ->setUrl('/admin/shop/catalog/price-access')
            ->setTitle('Права доступа к прайс-листам')
            ->save();

        $baseMenu
            ->copy()
            ->setUrl('/admin/shop/catalog/settings')
            ->setTitle('Настройки')
            ->save();

        \Diamond\Models\Menu\MenuQuery::create()->filterByName('admin-shop-other')->delete();

        $baseMenu = (new \Diamond\Models\Menu\Menu)
            ->setDomainId(1)
            ->setName('admin-shop-other')
            ->setActive('Y');

        $baseMenu
            ->copy()
            ->setUrl('/admin/shop/other/states')
            ->setTitle('Состояния')
            ->save();

        $baseMenu
            ->copy()
            ->setUrl('/admin/shop/other/currencies')
            ->setTitle('Валюты')
            ->save();

        $baseMenu
            ->copy()
            ->setUrl('/admin/shop/other/currencies')
            ->setTitle('Валюты')
            ->save();

        $geo = $baseMenu
            ->copy()
            ->setTitle('География')
            ;
        $geo->save();

        $baseMenu
            ->copy()
            ->setParentId($geo->getId())
            ->setUrl('/admin/shop/other/countries')
            ->setTitle('Страны')
            ->save();

        $baseMenu
            ->copy()
            ->setParentId($geo->getId())
            ->setUrl('/admin/shop/other/regions')
            ->setTitle('Регионы')
            ->save();

        $baseMenu
            ->copy()
            ->setParentId($geo->getId())
            ->setUrl('/admin/shop/other/cities')
            ->setTitle('Города')
            ->save();

        $logs = $baseMenu
            ->copy()
            ->setTitle('Логи');

        $logs->save();

        $baseMenu
            ->copy()
            ->setParentId($logs->getId())
            ->setUrl('/admin/shop/other/state_logs')
            ->setTitle('Смена состояний')
            ->save();

        $baseMenu
            ->copy()
            ->setUrl('/admin/shop/other/settings_main')
            ->setTitle('Основные настройки')
            ->save();

    }

    public function preDown(MigrationManager $manager)
    {
        // add the pre-migration code here
    }

    public function postDown(MigrationManager $manager)
    {
        // add the post-migration code here
    }

    /**
     * Get the SQL statements for the Up migration
     *
     * @return array list of the SQL strings to execute for the Up migration
     *               the keys being the datasources
     */
    public function getUpSQL()
    {
        return array(
            'default' => '
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;




# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
',
        );
    }

    /**
     * Get the SQL statements for the Down migration
     *
     * @return array list of the SQL strings to execute for the Down migration
     *               the keys being the datasources
     */
    public function getDownSQL()
    {
        return array(
            'default' => '
# This is a fix for InnoDB in MySQL >= 4.1.x
# It "suspends judgement" for fkey relationships until are tables are set.
SET FOREIGN_KEY_CHECKS = 0;

# This restores the fkey checks, after having unset them earlier
SET FOREIGN_KEY_CHECKS = 1;
',
        );
    }

}