<?php

namespace Shop\Helpers;

use Shop\ValueObject\Filter as FilterValue;

/**
 * Description of Filter
 *
 * @author Admin
 */
class Filter {
    
    public static function buildFilterFromUrl($url){
        $productId = null;
        $the_array = explode('/', trim($url, '/'));

        @list($page, $category_alias, $brand_alias) = $the_array;
        
        if(preg_match("~^(\d+)\-~", $brand_alias, $m)){
            $brand_alias = null;
            $productId = $m[1];
        }
        return new FilterValue($page, $category_alias, $brand_alias, $productId);
    }
    
}
