<?php

namespace Shop\Modules\AdminCountries;

use ActiveTable\ColumnTable;
use Core\Form\ControlBuilder;
use DiamondTable\TableFactory;
use Shop\Repositories\Country\CountryCriteria;
use Shop\Repositories\Country\CountryRepository;

/**
 * Description of AdminCountries
 *
 * @author Diamond Code Generator
 */
class AdminCountries extends \Core\ModuleController
{
    protected $countryRepository;
    protected $tableFactory;
    protected $controlBuilder;

    public function __construct(CountryRepository $countryRepository, TableFactory $tableFactory,
                                ControlBuilder $controlBuilder
    )
    {
        $this->countryRepository = $countryRepository;
        $this->controlBuilder = $controlBuilder;
        $this->tableFactory = $tableFactory;
    }

    public function process(): string
    {

        $table = $this->tableFactory->buildAdminTable($this->countryRepository, CountryCriteria::create());

        $table
            ->addColumn(
                (new ColumnTable('id', '№'))
                    ->setSorted(true)
                    ->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('name', 'Название'))

            )
            ->addColumn(
                (new ColumnTable('code', 'Код страны'))

            )
            ->addColumn(
                (new ColumnTable('phoneMask', 'Маска телефона'))

            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setFormat($this->tableFactory, 'formatActions')
                    ->setWidth(120)
            );

        $table
            ->addField(
                $this->controlBuilder->buildInputSmall('name'), true
            )
            ->addField(
                $this->controlBuilder->buildInputSmall('code'), true
            )
            ->addField(
                $this->controlBuilder->buildInputSmall('phoneMask'), true, null,
                'может использоваться для ввода телефона'
            );

        $table
            ->addFilter(
                $this->controlBuilder->buildInput('search_by_name')
            )
            ->addFilter(
                $this->controlBuilder->buildInput('filter_by_code')
            );

        return $table->render();
    }

}               