<?php

namespace Shop\Application\Shopping\CreateProviderOrder;

/**
 * Class CreateProviderOrderCommand
 * @package Shop\Application\Shopping\CreateProviderOrder
 */
class CreateProviderOrderCommand
{
    protected $orderRequest;
    protected $result;

    /**
     * CreateProviderOrderCommand constructor.
     * @param OrderRequest $orderRequest
     * @param Result $result
     */
    public function __construct(OrderRequest $orderRequest, Result $result)
    {
        $this->orderRequest = $orderRequest;
        $this->result = $result;
    }

    /**
     * @return OrderRequest
     */
    public function getOrderRequest(): OrderRequest
    {
        return $this->orderRequest;
    }

    /**
     * @return Result
     */
    public function getResult(): Result
    {
        return $this->result;
    }

}