<?php

namespace Shop\Repositories\PriceList;

use Repo\Concrete\AbstractCriteria;
use Shop\Domain\PriceList\Contracts\PriceListCriteriaInterface;

class PriceListCriteria extends AbstractCriteria implements PriceListCriteriaInterface
{
    /**
     * @var int|null
     */
    protected $filterByProviderId;


    /**
     * @var string|null
     */
    protected $searchByTitle;

    /**
     * @var string|null
     */
    protected $sortByDateUpdate;

    /**
     * @var string|null
     */
    protected $sortByTitle;

    /**
     * @return string|null
     */
    public function getSortByTitle(): ?string
    {
        return $this->sortByTitle;
    }

    /**
     * @param string|null $sortByTitle
     * @return PriceListCriteria
     */
    public function setSortByTitle(?string $sortByTitle): PriceListCriteria
    {
        $this->sortByTitle = $sortByTitle;
        return $this;
    }



    /**
     * @return string|null
     */
    public function getSearchByTitle(): ?string
    {
        return $this->searchByTitle;
    }

    /**
     * @param string|null $searchByTitle
     * @return PriceListCriteria
     */
    public function setSearchByTitle(?string $searchByTitle): PriceListCriteria
    {
        $this->searchByTitle = $searchByTitle;
        return $this;
    }


    public function getFilterByProviderId(): ?int
    {
        return $this->filterByProviderId;
    }

    public function getSortByDateUpdate(): ?string
    {
        return $this->sortByDateUpdate;
    }

    /**
     * @param int|null $filterByProviderId
     * @return PriceListCriteria
     */
    public function setFilterByProviderId(?int $filterByProviderId): PriceListCriteria
    {
        $this->filterByProviderId = $filterByProviderId;
        return $this;
    }

    /**
     * @param string|null $sortByDateUpdate
     * @return PriceListCriteria
     */
    public function setSortByDateUpdate(?string $sortByDateUpdate): PriceListCriteria
    {
        $this->sortByDateUpdate = $sortByDateUpdate;
        return $this;
    }

    public static function create()
    {
        return new self;
    }

}