<?php

namespace Shop\Models\Position\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveRecord\ActiveRecordInterface;
use Propel\Runtime\Collection\Collection;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Collection\ObjectCombinationCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\BadMethodCallException;
use Propel\Runtime\Exception\LogicException;
use Propel\Runtime\Exception\PropelException;
use Propel\Runtime\Map\TableMap;
use Propel\Runtime\Parser\AbstractParser;
use Shop\Models\Position\Position as ChildPosition;
use Shop\Models\Position\PositionQuery as ChildPositionQuery;
use Shop\Models\Position\Map\PositionTableMap;
use Shop\Models\PricelistSheet\PricelistSheet;
use Shop\Models\PricelistSheet\PricelistSheetQuery;
use Shop\Models\Product\Product;
use Shop\Models\Product\ProductQuery;
use Shop\Models\Sale\Sale;
use Shop\Models\Sale\SaleQuery;
use Shop\Models\ShopPositionSize\ShopPositionSize;
use Shop\Models\ShopPositionSize\ShopPositionSizeQuery;
use Shop\Models\ShopPositionSizeType\ShopPositionSizeType;
use Shop\Models\ShopPositionSizeType\ShopPositionSizeTypeQuery;
use Shop\Models\ShopPositionSize\Base\ShopPositionSize as BaseShopPositionSize;
use Shop\Models\ShopPositionSize\Map\ShopPositionSizeTableMap;

/**
 * Base class that represents a row from the 'shop_positions' table.
 *
 *
 *
 * @package    propel.generator.Models.Position.Base
 */
abstract class Position implements ActiveRecordInterface
{
    /**
     * TableMap class name
     */
    const TABLE_MAP = '\\Shop\\Models\\Position\\Map\\PositionTableMap';


    /**
     * attribute to determine if this object has previously been saved.
     * @var boolean
     */
    protected $new = true;

    /**
     * attribute to determine whether this object has been deleted.
     * @var boolean
     */
    protected $deleted = false;

    /**
     * The columns that have been modified in current object.
     * Tracking modified columns allows us to only update modified columns.
     * @var array
     */
    protected $modifiedColumns = array();

    /**
     * The (virtual) columns that are added at runtime
     * The formatters can add supplementary columns based on a resultset
     * @var array
     */
    protected $virtualColumns = array();

    /**
     * The value for the id field.
     *
     * @var        int
     */
    protected $id;

    /**
     * The value for the desc field.
     *
     * @var        string
     */
    protected $desc;

    /**
     * The value for the remain field.
     *
     * Note: this column has a database default value of: 0
     * @var        int
     */
    protected $remain;

    /**
     * The value for the price field.
     *
     * Note: this column has a database default value of: '0.00'
     * @var        string
     */
    protected $price;

    /**
     * The value for the price_old field.
     *
     * Note: this column has a database default value of: '0.00'
     * @var        string
     */
    protected $price_old;

    /**
     * The value for the destination field.
     *
     * @var        string
     */
    protected $destination;

    /**
     * The value for the sale_id field.
     *
     * @var        int
     */
    protected $sale_id;

    /**
     * The value for the image field.
     *
     * @var        string
     */
    protected $image;

    /**
     * The value for the product_id field.
     *
     * @var        int
     */
    protected $product_id;

    /**
     * The value for the pricelist_sheet_id field.
     *
     * @var        int
     */
    protected $pricelist_sheet_id;

    /**
     * The value for the ref_id field.
     *
     * @var        string
     */
    protected $ref_id;

    /**
     * @var        Sale
     */
    protected $aSale;

    /**
     * @var        Product
     */
    protected $aProduct;

    /**
     * @var        PricelistSheet
     */
    protected $aPricelistSheet;

    /**
     * @var        ObjectCollection|ShopPositionSize[] Collection to store aggregation of ShopPositionSize objects.
     */
    protected $collShopPositionSizes;
    protected $collShopPositionSizesPartial;

    /**
     * @var ObjectCombinationCollection Cross CombinationCollection to store aggregation of ChildShopPositionSizeType combinations.
     */
    protected $combinationCollShopPositionSizeTypeValues;

    /**
     * @var bool
     */
    protected $combinationCollShopPositionSizeTypeValuesPartial;

    /**
     * @var        ObjectCollection|ShopPositionSizeType[] Cross Collection to store aggregation of ShopPositionSizeType objects.
     */
    protected $collShopPositionSizeTypes;

    /**
     * @var bool
     */
    protected $collShopPositionSizeTypesPartial;

    /**
     * Flag to prevent endless save loop, if this object is referenced
     * by another object which falls in this transaction.
     *
     * @var boolean
     */
    protected $alreadyInSave = false;

    /**
     * @var ObjectCombinationCollection Cross CombinationCollection to store aggregation of ChildShopPositionSizeType combinations.
     */
    protected $combinationCollShopPositionSizeTypeValuesScheduledForDeletion = null;

    /**
     * An array of objects scheduled for deletion.
     * @var ObjectCollection|ShopPositionSize[]
     */
    protected $shopPositionSizesScheduledForDeletion = null;

    /**
     * Applies default values to this object.
     * This method should be called from the object's constructor (or
     * equivalent initialization method).
     * @see __construct()
     */
    public function applyDefaultValues()
    {
        $this->remain = 0;
        $this->price = '0.00';
        $this->price_old = '0.00';
    }

    /**
     * Initializes internal state of Shop\Models\Position\Base\Position object.
     * @see applyDefaults()
     */
    public function __construct()
    {
        $this->applyDefaultValues();
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return boolean True if the object has been modified.
     */
    public function isModified()
    {
        return !!$this->modifiedColumns;
    }

    /**
     * Has specified column been modified?
     *
     * @param  string  $col column fully qualified name (TableMap::TYPE_COLNAME), e.g. Book::AUTHOR_ID
     * @return boolean True if $col has been modified.
     */
    public function isColumnModified($col)
    {
        return $this->modifiedColumns && isset($this->modifiedColumns[$col]);
    }

    /**
     * Get the columns that have been modified in this object.
     * @return array A unique list of the modified column names for this object.
     */
    public function getModifiedColumns()
    {
        return $this->modifiedColumns ? array_keys($this->modifiedColumns) : [];
    }

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return boolean true, if the object has never been persisted.
     */
    public function isNew()
    {
        return $this->new;
    }

    /**
     * Setter for the isNew attribute.  This method will be called
     * by Propel-generated children and objects.
     *
     * @param boolean $b the state of the object.
     */
    public function setNew($b)
    {
        $this->new = (boolean) $b;
    }

    /**
     * Whether this object has been deleted.
     * @return boolean The deleted state of this object.
     */
    public function isDeleted()
    {
        return $this->deleted;
    }

    /**
     * Specify whether this object has been deleted.
     * @param  boolean $b The deleted state of this object.
     * @return void
     */
    public function setDeleted($b)
    {
        $this->deleted = (boolean) $b;
    }

    /**
     * Sets the modified state for the object to be false.
     * @param  string $col If supplied, only the specified column is reset.
     * @return void
     */
    public function resetModified($col = null)
    {
        if (null !== $col) {
            if (isset($this->modifiedColumns[$col])) {
                unset($this->modifiedColumns[$col]);
            }
        } else {
            $this->modifiedColumns = array();
        }
    }

    /**
     * Compares this with another <code>Position</code> instance.  If
     * <code>obj</code> is an instance of <code>Position</code>, delegates to
     * <code>equals(Position)</code>.  Otherwise, returns <code>false</code>.
     *
     * @param  mixed   $obj The object to compare to.
     * @return boolean Whether equal to the object specified.
     */
    public function equals($obj)
    {
        if (!$obj instanceof static) {
            return false;
        }

        if ($this === $obj) {
            return true;
        }

        if (null === $this->getPrimaryKey() || null === $obj->getPrimaryKey()) {
            return false;
        }

        return $this->getPrimaryKey() === $obj->getPrimaryKey();
    }

    /**
     * Get the associative array of the virtual columns in this object
     *
     * @return array
     */
    public function getVirtualColumns()
    {
        return $this->virtualColumns;
    }

    /**
     * Checks the existence of a virtual column in this object
     *
     * @param  string  $name The virtual column name
     * @return boolean
     */
    public function hasVirtualColumn($name)
    {
        return array_key_exists($name, $this->virtualColumns);
    }

    /**
     * Get the value of a virtual column in this object
     *
     * @param  string $name The virtual column name
     * @return mixed
     *
     * @throws PropelException
     */
    public function getVirtualColumn($name)
    {
        if (!$this->hasVirtualColumn($name)) {
            throw new PropelException(sprintf('Cannot get value of inexistent virtual column %s.', $name));
        }

        return $this->virtualColumns[$name];
    }

    /**
     * Set the value of a virtual column in this object
     *
     * @param string $name  The virtual column name
     * @param mixed  $value The value to give to the virtual column
     *
     * @return $this|Position The current object, for fluid interface
     */
    public function setVirtualColumn($name, $value)
    {
        $this->virtualColumns[$name] = $value;

        return $this;
    }

    /**
     * Logs a message using Propel::log().
     *
     * @param  string  $msg
     * @param  int     $priority One of the Propel::LOG_* logging levels
     * @return boolean
     */
    protected function log($msg, $priority = Propel::LOG_INFO)
    {
        return Propel::log(get_class($this) . ': ' . $msg, $priority);
    }

    /**
     * Export the current object properties to a string, using a given parser format
     * <code>
     * $book = BookQuery::create()->findPk(9012);
     * echo $book->exportTo('JSON');
     *  => {"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * @param  mixed   $parser                 A AbstractParser instance, or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param  boolean $includeLazyLoadColumns (optional) Whether to include lazy load(ed) columns. Defaults to TRUE.
     * @return string  The exported data
     */
    public function exportTo($parser, $includeLazyLoadColumns = true)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        return $parser->fromArray($this->toArray(TableMap::TYPE_PHPNAME, $includeLazyLoadColumns, array(), true));
    }

    /**
     * Clean up internal collections prior to serializing
     * Avoids recursive loops that turn into segmentation faults when serializing
     */
    public function __sleep()
    {
        $this->clearAllReferences();

        $cls = new \ReflectionClass($this);
        $propertyNames = [];
        $serializableProperties = array_diff($cls->getProperties(), $cls->getProperties(\ReflectionProperty::IS_STATIC));

        foreach($serializableProperties as $property) {
            $propertyNames[] = $property->getName();
        }

        return $propertyNames;
    }

    /**
     * Get the [id] column value.
     *
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Get the [desc] column value.
     *
     * @return string
     */
    public function getDesc()
    {
        return $this->desc;
    }

    /**
     * Get the [remain] column value.
     *
     * @return int
     */
    public function getRemain()
    {
        return $this->remain;
    }

    /**
     * Get the [price] column value.
     *
     * @return string
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * Get the [price_old] column value.
     *
     * @return string
     */
    public function getPriceOld()
    {
        return $this->price_old;
    }

    /**
     * Get the [destination] column value.
     *
     * @return string
     */
    public function getDestination()
    {
        return $this->destination;
    }

    /**
     * Get the [sale_id] column value.
     *
     * @return int
     */
    public function getSaleId()
    {
        return $this->sale_id;
    }

    /**
     * Get the [image] column value.
     *
     * @return string
     */
    public function getImage()
    {
        return $this->image;
    }

    /**
     * Get the [product_id] column value.
     *
     * @return int
     */
    public function getProductId()
    {
        return $this->product_id;
    }

    /**
     * Get the [pricelist_sheet_id] column value.
     *
     * @return int
     */
    public function getPricelistSheetId()
    {
        return $this->pricelist_sheet_id;
    }

    /**
     * Get the [ref_id] column value.
     *
     * @return string
     */
    public function getRefId()
    {
        return $this->ref_id;
    }

    /**
     * Set the value of [id] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Position\Position The current object (for fluent API support)
     */
    public function setId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->id !== $v) {
            $this->id = $v;
            $this->modifiedColumns[PositionTableMap::COL_ID] = true;
        }

        return $this;
    } // setId()

    /**
     * Set the value of [desc] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Position\Position The current object (for fluent API support)
     */
    public function setDesc($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->desc !== $v) {
            $this->desc = $v;
            $this->modifiedColumns[PositionTableMap::COL_DESC] = true;
        }

        return $this;
    } // setDesc()

    /**
     * Set the value of [remain] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Position\Position The current object (for fluent API support)
     */
    public function setRemain($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->remain !== $v) {
            $this->remain = $v;
            $this->modifiedColumns[PositionTableMap::COL_REMAIN] = true;
        }

        return $this;
    } // setRemain()

    /**
     * Set the value of [price] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Position\Position The current object (for fluent API support)
     */
    public function setPrice($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->price !== $v) {
            $this->price = $v;
            $this->modifiedColumns[PositionTableMap::COL_PRICE] = true;
        }

        return $this;
    } // setPrice()

    /**
     * Set the value of [price_old] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Position\Position The current object (for fluent API support)
     */
    public function setPriceOld($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->price_old !== $v) {
            $this->price_old = $v;
            $this->modifiedColumns[PositionTableMap::COL_PRICE_OLD] = true;
        }

        return $this;
    } // setPriceOld()

    /**
     * Set the value of [destination] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Position\Position The current object (for fluent API support)
     */
    public function setDestination($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->destination !== $v) {
            $this->destination = $v;
            $this->modifiedColumns[PositionTableMap::COL_DESTINATION] = true;
        }

        return $this;
    } // setDestination()

    /**
     * Set the value of [sale_id] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Position\Position The current object (for fluent API support)
     */
    public function setSaleId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->sale_id !== $v) {
            $this->sale_id = $v;
            $this->modifiedColumns[PositionTableMap::COL_SALE_ID] = true;
        }

        if ($this->aSale !== null && $this->aSale->getId() !== $v) {
            $this->aSale = null;
        }

        return $this;
    } // setSaleId()

    /**
     * Set the value of [image] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Position\Position The current object (for fluent API support)
     */
    public function setImage($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->image !== $v) {
            $this->image = $v;
            $this->modifiedColumns[PositionTableMap::COL_IMAGE] = true;
        }

        return $this;
    } // setImage()

    /**
     * Set the value of [product_id] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Position\Position The current object (for fluent API support)
     */
    public function setProductId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->product_id !== $v) {
            $this->product_id = $v;
            $this->modifiedColumns[PositionTableMap::COL_PRODUCT_ID] = true;
        }

        if ($this->aProduct !== null && $this->aProduct->getId() !== $v) {
            $this->aProduct = null;
        }

        return $this;
    } // setProductId()

    /**
     * Set the value of [pricelist_sheet_id] column.
     *
     * @param int $v new value
     * @return $this|\Shop\Models\Position\Position The current object (for fluent API support)
     */
    public function setPricelistSheetId($v)
    {
        if ($v !== null) {
            $v = (int) $v;
        }

        if ($this->pricelist_sheet_id !== $v) {
            $this->pricelist_sheet_id = $v;
            $this->modifiedColumns[PositionTableMap::COL_PRICELIST_SHEET_ID] = true;
        }

        if ($this->aPricelistSheet !== null && $this->aPricelistSheet->getId() !== $v) {
            $this->aPricelistSheet = null;
        }

        return $this;
    } // setPricelistSheetId()

    /**
     * Set the value of [ref_id] column.
     *
     * @param string $v new value
     * @return $this|\Shop\Models\Position\Position The current object (for fluent API support)
     */
    public function setRefId($v)
    {
        if ($v !== null) {
            $v = (string) $v;
        }

        if ($this->ref_id !== $v) {
            $this->ref_id = $v;
            $this->modifiedColumns[PositionTableMap::COL_REF_ID] = true;
        }

        return $this;
    } // setRefId()

    /**
     * Indicates whether the columns in this object are only set to default values.
     *
     * This method can be used in conjunction with isModified() to indicate whether an object is both
     * modified _and_ has some values set which are non-default.
     *
     * @return boolean Whether the columns in this object are only been set with default values.
     */
    public function hasOnlyDefaultValues()
    {
            if ($this->remain !== 0) {
                return false;
            }

            if ($this->price !== '0.00') {
                return false;
            }

            if ($this->price_old !== '0.00') {
                return false;
            }

        // otherwise, everything was equal, so return TRUE
        return true;
    } // hasOnlyDefaultValues()

    /**
     * Hydrates (populates) the object variables with values from the database resultset.
     *
     * An offset (0-based "start column") is specified so that objects can be hydrated
     * with a subset of the columns in the resultset rows.  This is needed, for example,
     * for results of JOIN queries where the resultset row includes columns from two or
     * more tables.
     *
     * @param array   $row       The row returned by DataFetcher->fetch().
     * @param int     $startcol  0-based offset column which indicates which restultset column to start with.
     * @param boolean $rehydrate Whether this object is being re-hydrated from the database.
     * @param string  $indexType The index type of $row. Mostly DataFetcher->getIndexType().
                                  One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                            TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *
     * @return int             next starting column
     * @throws PropelException - Any caught Exception will be rewrapped as a PropelException.
     */
    public function hydrate($row, $startcol = 0, $rehydrate = false, $indexType = TableMap::TYPE_NUM)
    {
        try {

            $col = $row[TableMap::TYPE_NUM == $indexType ? 0 + $startcol : PositionTableMap::translateFieldName('Id', TableMap::TYPE_PHPNAME, $indexType)];
            $this->id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 1 + $startcol : PositionTableMap::translateFieldName('Desc', TableMap::TYPE_PHPNAME, $indexType)];
            $this->desc = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 2 + $startcol : PositionTableMap::translateFieldName('Remain', TableMap::TYPE_PHPNAME, $indexType)];
            $this->remain = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 3 + $startcol : PositionTableMap::translateFieldName('Price', TableMap::TYPE_PHPNAME, $indexType)];
            $this->price = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 4 + $startcol : PositionTableMap::translateFieldName('PriceOld', TableMap::TYPE_PHPNAME, $indexType)];
            $this->price_old = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 5 + $startcol : PositionTableMap::translateFieldName('Destination', TableMap::TYPE_PHPNAME, $indexType)];
            $this->destination = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 6 + $startcol : PositionTableMap::translateFieldName('SaleId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->sale_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 7 + $startcol : PositionTableMap::translateFieldName('Image', TableMap::TYPE_PHPNAME, $indexType)];
            $this->image = (null !== $col) ? (string) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 8 + $startcol : PositionTableMap::translateFieldName('ProductId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->product_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 9 + $startcol : PositionTableMap::translateFieldName('PricelistSheetId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->pricelist_sheet_id = (null !== $col) ? (int) $col : null;

            $col = $row[TableMap::TYPE_NUM == $indexType ? 10 + $startcol : PositionTableMap::translateFieldName('RefId', TableMap::TYPE_PHPNAME, $indexType)];
            $this->ref_id = (null !== $col) ? (string) $col : null;
            $this->resetModified();

            $this->setNew(false);

            if ($rehydrate) {
                $this->ensureConsistency();
            }

            return $startcol + 11; // 11 = PositionTableMap::NUM_HYDRATE_COLUMNS.

        } catch (Exception $e) {
            throw new PropelException(sprintf('Error populating %s object', '\\Shop\\Models\\Position\\Position'), 0, $e);
        }
    }

    /**
     * Checks and repairs the internal consistency of the object.
     *
     * This method is executed after an already-instantiated object is re-hydrated
     * from the database.  It exists to check any foreign keys to make sure that
     * the objects related to the current object are correct based on foreign key.
     *
     * You can override this method in the stub class, but you should always invoke
     * the base method from the overridden method (i.e. parent::ensureConsistency()),
     * in case your model changes.
     *
     * @throws PropelException
     */
    public function ensureConsistency()
    {
        if ($this->aSale !== null && $this->sale_id !== $this->aSale->getId()) {
            $this->aSale = null;
        }
        if ($this->aProduct !== null && $this->product_id !== $this->aProduct->getId()) {
            $this->aProduct = null;
        }
        if ($this->aPricelistSheet !== null && $this->pricelist_sheet_id !== $this->aPricelistSheet->getId()) {
            $this->aPricelistSheet = null;
        }
    } // ensureConsistency

    /**
     * Reloads this object from datastore based on primary key and (optionally) resets all associated objects.
     *
     * This will only work if the object has been saved and has a valid primary key set.
     *
     * @param      boolean $deep (optional) Whether to also de-associated any related objects.
     * @param      ConnectionInterface $con (optional) The ConnectionInterface connection to use.
     * @return void
     * @throws PropelException - if this object is deleted, unsaved or doesn't have pk match in db
     */
    public function reload($deep = false, ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("Cannot reload a deleted object.");
        }

        if ($this->isNew()) {
            throw new PropelException("Cannot reload an unsaved object.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(PositionTableMap::DATABASE_NAME);
        }

        // We don't need to alter the object instance pool; we're just modifying this instance
        // already in the pool.

        $dataFetcher = ChildPositionQuery::create(null, $this->buildPkeyCriteria())->setFormatter(ModelCriteria::FORMAT_STATEMENT)->find($con);
        $row = $dataFetcher->fetch();
        $dataFetcher->close();
        if (!$row) {
            throw new PropelException('Cannot find matching row in the database to reload object values.');
        }
        $this->hydrate($row, 0, true, $dataFetcher->getIndexType()); // rehydrate

        if ($deep) {  // also de-associate any related objects?

            $this->aSale = null;
            $this->aProduct = null;
            $this->aPricelistSheet = null;
            $this->collShopPositionSizes = null;

            $this->collShopPositionSizeTypeValues = null;
        } // if (deep)
    }

    /**
     * Removes this object from datastore and sets delete attribute.
     *
     * @param      ConnectionInterface $con
     * @return void
     * @throws PropelException
     * @see Position::setDeleted()
     * @see Position::isDeleted()
     */
    public function delete(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("This object has already been deleted.");
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(PositionTableMap::DATABASE_NAME);
        }

        $con->transaction(function () use ($con) {
            $deleteQuery = ChildPositionQuery::create()
                ->filterByPrimaryKey($this->getPrimaryKey());
            $ret = $this->preDelete($con);
            if ($ret) {
                $deleteQuery->delete($con);
                $this->postDelete($con);
                $this->setDeleted(true);
            }
        });
    }

    /**
     * Persists this object to the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All modified related objects will also be persisted in the doSave()
     * method.  This method wraps all precipitate database operations in a
     * single transaction.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see doSave()
     */
    public function save(ConnectionInterface $con = null)
    {
        if ($this->isDeleted()) {
            throw new PropelException("You cannot save an object that has been deleted.");
        }

        if ($this->alreadyInSave) {
            return 0;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getWriteConnection(PositionTableMap::DATABASE_NAME);
        }

        return $con->transaction(function () use ($con) {
            $ret = $this->preSave($con);
            $isInsert = $this->isNew();
            if ($isInsert) {
                $ret = $ret && $this->preInsert($con);
            } else {
                $ret = $ret && $this->preUpdate($con);
            }
            if ($ret) {
                $affectedRows = $this->doSave($con);
                if ($isInsert) {
                    $this->postInsert($con);
                } else {
                    $this->postUpdate($con);
                }
                $this->postSave($con);
                PositionTableMap::addInstanceToPool($this);
            } else {
                $affectedRows = 0;
            }

            return $affectedRows;
        });
    }

    /**
     * Performs the work of inserting or updating the row in the database.
     *
     * If the object is new, it inserts it; otherwise an update is performed.
     * All related objects are also updated in this method.
     *
     * @param      ConnectionInterface $con
     * @return int             The number of rows affected by this insert/update and any referring fk objects' save() operations.
     * @throws PropelException
     * @see save()
     */
    protected function doSave(ConnectionInterface $con)
    {
        $affectedRows = 0; // initialize var to track total num of affected rows
        if (!$this->alreadyInSave) {
            $this->alreadyInSave = true;

            // We call the save method on the following object(s) if they
            // were passed to this object by their corresponding set
            // method.  This object relates to these object(s) by a
            // foreign key reference.

            if ($this->aSale !== null) {
                if ($this->aSale->isModified() || $this->aSale->isNew()) {
                    $affectedRows += $this->aSale->save($con);
                }
                $this->setSale($this->aSale);
            }

            if ($this->aProduct !== null) {
                if ($this->aProduct->isModified() || $this->aProduct->isNew()) {
                    $affectedRows += $this->aProduct->save($con);
                }
                $this->setProduct($this->aProduct);
            }

            if ($this->aPricelistSheet !== null) {
                if ($this->aPricelistSheet->isModified() || $this->aPricelistSheet->isNew()) {
                    $affectedRows += $this->aPricelistSheet->save($con);
                }
                $this->setPricelistSheet($this->aPricelistSheet);
            }

            if ($this->isNew() || $this->isModified()) {
                // persist changes
                if ($this->isNew()) {
                    $this->doInsert($con);
                    $affectedRows += 1;
                } else {
                    $affectedRows += $this->doUpdate($con);
                }
                $this->resetModified();
            }

            if ($this->combinationCollShopPositionSizeTypeValuesScheduledForDeletion !== null) {
                if (!$this->combinationCollShopPositionSizeTypeValuesScheduledForDeletion->isEmpty()) {
                    $pks = array();
                    foreach ($this->combinationCollShopPositionSizeTypeValuesScheduledForDeletion as $combination) {
                        $entryPk = [];

                        $entryPk[0] = $this->getId();
                        $entryPk[1] = $combination[0]->getId();
                        //$combination[1] = Value;
                        $entryPk[2] = $combination[1];

                        $pks[] = $entryPk;
                    }

                    \Shop\Models\ShopPositionSize\ShopPositionSizeQuery::create()
                        ->filterByPrimaryKeys($pks)
                        ->delete($con);

                    $this->combinationCollShopPositionSizeTypeValuesScheduledForDeletion = null;
                }

            }

            if (null !== $this->combinationCollShopPositionSizeTypeValues) {
                foreach ($this->combinationCollShopPositionSizeTypeValues as $combination) {

                    //$combination[0] = ShopPositionSizeType (shop_position_sizes_fk_4bb57a)
                    if (!$combination[0]->isDeleted() && ($combination[0]->isNew() || $combination[0]->isModified())) {
                        $combination[0]->save($con);
                    }

                    //$combination[1] = Value; Nothing to save.
                }
            }


            if ($this->shopPositionSizesScheduledForDeletion !== null) {
                if (!$this->shopPositionSizesScheduledForDeletion->isEmpty()) {
                    \Shop\Models\ShopPositionSize\ShopPositionSizeQuery::create()
                        ->filterByPrimaryKeys($this->shopPositionSizesScheduledForDeletion->getPrimaryKeys(false))
                        ->delete($con);
                    $this->shopPositionSizesScheduledForDeletion = null;
                }
            }

            if ($this->collShopPositionSizes !== null) {
                foreach ($this->collShopPositionSizes as $referrerFK) {
                    if (!$referrerFK->isDeleted() && ($referrerFK->isNew() || $referrerFK->isModified())) {
                        $affectedRows += $referrerFK->save($con);
                    }
                }
            }

            $this->alreadyInSave = false;

        }

        return $affectedRows;
    } // doSave()

    /**
     * Insert the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @throws PropelException
     * @see doSave()
     */
    protected function doInsert(ConnectionInterface $con)
    {
        $modifiedColumns = array();
        $index = 0;

        $this->modifiedColumns[PositionTableMap::COL_ID] = true;
        if (null !== $this->id) {
            throw new PropelException('Cannot insert a value for auto-increment primary key (' . PositionTableMap::COL_ID . ')');
        }

         // check the columns in natural order for more readable SQL queries
        if ($this->isColumnModified(PositionTableMap::COL_ID)) {
            $modifiedColumns[':p' . $index++]  = '`id`';
        }
        if ($this->isColumnModified(PositionTableMap::COL_DESC)) {
            $modifiedColumns[':p' . $index++]  = '`desc`';
        }
        if ($this->isColumnModified(PositionTableMap::COL_REMAIN)) {
            $modifiedColumns[':p' . $index++]  = '`remain`';
        }
        if ($this->isColumnModified(PositionTableMap::COL_PRICE)) {
            $modifiedColumns[':p' . $index++]  = '`price`';
        }
        if ($this->isColumnModified(PositionTableMap::COL_PRICE_OLD)) {
            $modifiedColumns[':p' . $index++]  = '`price_old`';
        }
        if ($this->isColumnModified(PositionTableMap::COL_DESTINATION)) {
            $modifiedColumns[':p' . $index++]  = '`destination`';
        }
        if ($this->isColumnModified(PositionTableMap::COL_SALE_ID)) {
            $modifiedColumns[':p' . $index++]  = '`sale_id`';
        }
        if ($this->isColumnModified(PositionTableMap::COL_IMAGE)) {
            $modifiedColumns[':p' . $index++]  = '`image`';
        }
        if ($this->isColumnModified(PositionTableMap::COL_PRODUCT_ID)) {
            $modifiedColumns[':p' . $index++]  = '`product_id`';
        }
        if ($this->isColumnModified(PositionTableMap::COL_PRICELIST_SHEET_ID)) {
            $modifiedColumns[':p' . $index++]  = '`pricelist_sheet_id`';
        }
        if ($this->isColumnModified(PositionTableMap::COL_REF_ID)) {
            $modifiedColumns[':p' . $index++]  = '`ref_id`';
        }

        $sql = sprintf(
            'INSERT INTO `shop_positions` (%s) VALUES (%s)',
            implode(', ', $modifiedColumns),
            implode(', ', array_keys($modifiedColumns))
        );

        try {
            $stmt = $con->prepare($sql);
            foreach ($modifiedColumns as $identifier => $columnName) {
                switch ($columnName) {
                    case '`id`':
                        $stmt->bindValue($identifier, $this->id, PDO::PARAM_INT);
                        break;
                    case '`desc`':
                        $stmt->bindValue($identifier, $this->desc, PDO::PARAM_STR);
                        break;
                    case '`remain`':
                        $stmt->bindValue($identifier, $this->remain, PDO::PARAM_INT);
                        break;
                    case '`price`':
                        $stmt->bindValue($identifier, $this->price, PDO::PARAM_STR);
                        break;
                    case '`price_old`':
                        $stmt->bindValue($identifier, $this->price_old, PDO::PARAM_STR);
                        break;
                    case '`destination`':
                        $stmt->bindValue($identifier, $this->destination, PDO::PARAM_STR);
                        break;
                    case '`sale_id`':
                        $stmt->bindValue($identifier, $this->sale_id, PDO::PARAM_INT);
                        break;
                    case '`image`':
                        $stmt->bindValue($identifier, $this->image, PDO::PARAM_STR);
                        break;
                    case '`product_id`':
                        $stmt->bindValue($identifier, $this->product_id, PDO::PARAM_INT);
                        break;
                    case '`pricelist_sheet_id`':
                        $stmt->bindValue($identifier, $this->pricelist_sheet_id, PDO::PARAM_INT);
                        break;
                    case '`ref_id`':
                        $stmt->bindValue($identifier, $this->ref_id, PDO::PARAM_STR);
                        break;
                }
            }
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute INSERT statement [%s]', $sql), 0, $e);
        }

        try {
            $pk = $con->lastInsertId();
        } catch (Exception $e) {
            throw new PropelException('Unable to get autoincrement id.', 0, $e);
        }
        $this->setId($pk);

        $this->setNew(false);
    }

    /**
     * Update the row in the database.
     *
     * @param      ConnectionInterface $con
     *
     * @return Integer Number of updated rows
     * @see doSave()
     */
    protected function doUpdate(ConnectionInterface $con)
    {
        $selectCriteria = $this->buildPkeyCriteria();
        $valuesCriteria = $this->buildCriteria();

        return $selectCriteria->doUpdate($valuesCriteria, $con);
    }

    /**
     * Retrieves a field from the object by name passed in as a string.
     *
     * @param      string $name name
     * @param      string $type The type of fieldname the $name is of:
     *                     one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                     TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                     Defaults to TableMap::TYPE_PHPNAME.
     * @return mixed Value of field.
     */
    public function getByName($name, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = PositionTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);
        $field = $this->getByPosition($pos);

        return $field;
    }

    /**
     * Retrieves a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param      int $pos position in xml schema
     * @return mixed Value of field at $pos
     */
    public function getByPosition($pos)
    {
        switch ($pos) {
            case 0:
                return $this->getId();
                break;
            case 1:
                return $this->getDesc();
                break;
            case 2:
                return $this->getRemain();
                break;
            case 3:
                return $this->getPrice();
                break;
            case 4:
                return $this->getPriceOld();
                break;
            case 5:
                return $this->getDestination();
                break;
            case 6:
                return $this->getSaleId();
                break;
            case 7:
                return $this->getImage();
                break;
            case 8:
                return $this->getProductId();
                break;
            case 9:
                return $this->getPricelistSheetId();
                break;
            case 10:
                return $this->getRefId();
                break;
            default:
                return null;
                break;
        } // switch()
    }

    /**
     * Exports the object as an array.
     *
     * You can specify the key type of the array by passing one of the class
     * type constants.
     *
     * @param     string  $keyType (optional) One of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     *                    TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                    Defaults to TableMap::TYPE_PHPNAME.
     * @param     boolean $includeLazyLoadColumns (optional) Whether to include lazy loaded columns. Defaults to TRUE.
     * @param     array $alreadyDumpedObjects List of objects to skip to avoid recursion
     * @param     boolean $includeForeignObjects (optional) Whether to include hydrated related objects. Default to FALSE.
     *
     * @return array an associative array containing the field names (as keys) and field values
     */
    public function toArray($keyType = TableMap::TYPE_PHPNAME, $includeLazyLoadColumns = true, $alreadyDumpedObjects = array(), $includeForeignObjects = false)
    {

        if (isset($alreadyDumpedObjects['Position'][$this->hashCode()])) {
            return '*RECURSION*';
        }
        $alreadyDumpedObjects['Position'][$this->hashCode()] = true;
        $keys = PositionTableMap::getFieldNames($keyType);
        $result = array(
            $keys[0] => $this->getId(),
            $keys[1] => $this->getDesc(),
            $keys[2] => $this->getRemain(),
            $keys[3] => $this->getPrice(),
            $keys[4] => $this->getPriceOld(),
            $keys[5] => $this->getDestination(),
            $keys[6] => $this->getSaleId(),
            $keys[7] => $this->getImage(),
            $keys[8] => $this->getProductId(),
            $keys[9] => $this->getPricelistSheetId(),
            $keys[10] => $this->getRefId(),
        );
        $virtualColumns = $this->virtualColumns;
        foreach ($virtualColumns as $key => $virtualColumn) {
            $result[$key] = $virtualColumn;
        }

        if ($includeForeignObjects) {
            if (null !== $this->aSale) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'sale';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_sales';
                        break;
                    default:
                        $key = 'Sale';
                }

                $result[$key] = $this->aSale->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aProduct) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'product';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_products';
                        break;
                    default:
                        $key = 'Product';
                }

                $result[$key] = $this->aProduct->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->aPricelistSheet) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'pricelistSheet';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_pricelist_sheets';
                        break;
                    default:
                        $key = 'PricelistSheet';
                }

                $result[$key] = $this->aPricelistSheet->toArray($keyType, $includeLazyLoadColumns,  $alreadyDumpedObjects, true);
            }
            if (null !== $this->collShopPositionSizes) {

                switch ($keyType) {
                    case TableMap::TYPE_CAMELNAME:
                        $key = 'shopPositionSizes';
                        break;
                    case TableMap::TYPE_FIELDNAME:
                        $key = 'shop_position_sizess';
                        break;
                    default:
                        $key = 'ShopPositionSizes';
                }

                $result[$key] = $this->collShopPositionSizes->toArray(null, false, $keyType, $includeLazyLoadColumns, $alreadyDumpedObjects);
            }
        }

        return $result;
    }

    /**
     * Sets a field from the object by name passed in as a string.
     *
     * @param  string $name
     * @param  mixed  $value field value
     * @param  string $type The type of fieldname the $name is of:
     *                one of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME
     *                TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     *                Defaults to TableMap::TYPE_PHPNAME.
     * @return $this|\Shop\Models\Position\Position
     */
    public function setByName($name, $value, $type = TableMap::TYPE_PHPNAME)
    {
        $pos = PositionTableMap::translateFieldName($name, $type, TableMap::TYPE_NUM);

        return $this->setByPosition($pos, $value);
    }

    /**
     * Sets a field from the object by Position as specified in the xml schema.
     * Zero-based.
     *
     * @param  int $pos position in xml schema
     * @param  mixed $value field value
     * @return $this|\Shop\Models\Position\Position
     */
    public function setByPosition($pos, $value)
    {
        switch ($pos) {
            case 0:
                $this->setId($value);
                break;
            case 1:
                $this->setDesc($value);
                break;
            case 2:
                $this->setRemain($value);
                break;
            case 3:
                $this->setPrice($value);
                break;
            case 4:
                $this->setPriceOld($value);
                break;
            case 5:
                $this->setDestination($value);
                break;
            case 6:
                $this->setSaleId($value);
                break;
            case 7:
                $this->setImage($value);
                break;
            case 8:
                $this->setProductId($value);
                break;
            case 9:
                $this->setPricelistSheetId($value);
                break;
            case 10:
                $this->setRefId($value);
                break;
        } // switch()

        return $this;
    }

    /**
     * Populates the object using an array.
     *
     * This is particularly useful when populating an object from one of the
     * request arrays (e.g. $_POST).  This method goes through the column
     * names, checking to see whether a matching key exists in populated
     * array. If so the setByName() method is called for that column.
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param      array  $arr     An array to populate the object from.
     * @param      string $keyType The type of keys the array uses.
     * @return void
     */
    public function fromArray($arr, $keyType = TableMap::TYPE_PHPNAME)
    {
        $keys = PositionTableMap::getFieldNames($keyType);

        if (array_key_exists($keys[0], $arr)) {
            $this->setId($arr[$keys[0]]);
        }
        if (array_key_exists($keys[1], $arr)) {
            $this->setDesc($arr[$keys[1]]);
        }
        if (array_key_exists($keys[2], $arr)) {
            $this->setRemain($arr[$keys[2]]);
        }
        if (array_key_exists($keys[3], $arr)) {
            $this->setPrice($arr[$keys[3]]);
        }
        if (array_key_exists($keys[4], $arr)) {
            $this->setPriceOld($arr[$keys[4]]);
        }
        if (array_key_exists($keys[5], $arr)) {
            $this->setDestination($arr[$keys[5]]);
        }
        if (array_key_exists($keys[6], $arr)) {
            $this->setSaleId($arr[$keys[6]]);
        }
        if (array_key_exists($keys[7], $arr)) {
            $this->setImage($arr[$keys[7]]);
        }
        if (array_key_exists($keys[8], $arr)) {
            $this->setProductId($arr[$keys[8]]);
        }
        if (array_key_exists($keys[9], $arr)) {
            $this->setPricelistSheetId($arr[$keys[9]]);
        }
        if (array_key_exists($keys[10], $arr)) {
            $this->setRefId($arr[$keys[10]]);
        }
    }

     /**
     * Populate the current object from a string, using a given parser format
     * <code>
     * $book = new Book();
     * $book->importFrom('JSON', '{"Id":9012,"Title":"Don Juan","ISBN":"0140422161","Price":12.99,"PublisherId":1234,"AuthorId":5678}');
     * </code>
     *
     * You can specify the key type of the array by additionally passing one
     * of the class type constants TableMap::TYPE_PHPNAME, TableMap::TYPE_CAMELNAME,
     * TableMap::TYPE_COLNAME, TableMap::TYPE_FIELDNAME, TableMap::TYPE_NUM.
     * The default key type is the column's TableMap::TYPE_PHPNAME.
     *
     * @param mixed $parser A AbstractParser instance,
     *                       or a format name ('XML', 'YAML', 'JSON', 'CSV')
     * @param string $data The source data to import from
     * @param string $keyType The type of keys the array uses.
     *
     * @return $this|\Shop\Models\Position\Position The current object, for fluid interface
     */
    public function importFrom($parser, $data, $keyType = TableMap::TYPE_PHPNAME)
    {
        if (!$parser instanceof AbstractParser) {
            $parser = AbstractParser::getParser($parser);
        }

        $this->fromArray($parser->toArray($data), $keyType);

        return $this;
    }

    /**
     * Build a Criteria object containing the values of all modified columns in this object.
     *
     * @return Criteria The Criteria object containing all modified values.
     */
    public function buildCriteria()
    {
        $criteria = new Criteria(PositionTableMap::DATABASE_NAME);

        if ($this->isColumnModified(PositionTableMap::COL_ID)) {
            $criteria->add(PositionTableMap::COL_ID, $this->id);
        }
        if ($this->isColumnModified(PositionTableMap::COL_DESC)) {
            $criteria->add(PositionTableMap::COL_DESC, $this->desc);
        }
        if ($this->isColumnModified(PositionTableMap::COL_REMAIN)) {
            $criteria->add(PositionTableMap::COL_REMAIN, $this->remain);
        }
        if ($this->isColumnModified(PositionTableMap::COL_PRICE)) {
            $criteria->add(PositionTableMap::COL_PRICE, $this->price);
        }
        if ($this->isColumnModified(PositionTableMap::COL_PRICE_OLD)) {
            $criteria->add(PositionTableMap::COL_PRICE_OLD, $this->price_old);
        }
        if ($this->isColumnModified(PositionTableMap::COL_DESTINATION)) {
            $criteria->add(PositionTableMap::COL_DESTINATION, $this->destination);
        }
        if ($this->isColumnModified(PositionTableMap::COL_SALE_ID)) {
            $criteria->add(PositionTableMap::COL_SALE_ID, $this->sale_id);
        }
        if ($this->isColumnModified(PositionTableMap::COL_IMAGE)) {
            $criteria->add(PositionTableMap::COL_IMAGE, $this->image);
        }
        if ($this->isColumnModified(PositionTableMap::COL_PRODUCT_ID)) {
            $criteria->add(PositionTableMap::COL_PRODUCT_ID, $this->product_id);
        }
        if ($this->isColumnModified(PositionTableMap::COL_PRICELIST_SHEET_ID)) {
            $criteria->add(PositionTableMap::COL_PRICELIST_SHEET_ID, $this->pricelist_sheet_id);
        }
        if ($this->isColumnModified(PositionTableMap::COL_REF_ID)) {
            $criteria->add(PositionTableMap::COL_REF_ID, $this->ref_id);
        }

        return $criteria;
    }

    /**
     * Builds a Criteria object containing the primary key for this object.
     *
     * Unlike buildCriteria() this method includes the primary key values regardless
     * of whether or not they have been modified.
     *
     * @throws LogicException if no primary key is defined
     *
     * @return Criteria The Criteria object containing value(s) for primary key(s).
     */
    public function buildPkeyCriteria()
    {
        $criteria = ChildPositionQuery::create();
        $criteria->add(PositionTableMap::COL_ID, $this->id);

        return $criteria;
    }

    /**
     * If the primary key is not null, return the hashcode of the
     * primary key. Otherwise, return the hash code of the object.
     *
     * @return int Hashcode
     */
    public function hashCode()
    {
        $validPk = null !== $this->getId();

        $validPrimaryKeyFKs = 0;
        $primaryKeyFKs = [];

        if ($validPk) {
            return crc32(json_encode($this->getPrimaryKey(), JSON_UNESCAPED_UNICODE));
        } elseif ($validPrimaryKeyFKs) {
            return crc32(json_encode($primaryKeyFKs, JSON_UNESCAPED_UNICODE));
        }

        return spl_object_hash($this);
    }

    /**
     * Returns the primary key for this object (row).
     * @return int
     */
    public function getPrimaryKey()
    {
        return $this->getId();
    }

    /**
     * Generic method to set the primary key (id column).
     *
     * @param       int $key Primary key.
     * @return void
     */
    public function setPrimaryKey($key)
    {
        $this->setId($key);
    }

    /**
     * Returns true if the primary key for this object is null.
     * @return boolean
     */
    public function isPrimaryKeyNull()
    {
        return null === $this->getId();
    }

    /**
     * Sets contents of passed object to values from current object.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param      object $copyObj An object of \Shop\Models\Position\Position (or compatible) type.
     * @param      boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @param      boolean $makeNew Whether to reset autoincrement PKs and make the object new.
     * @throws PropelException
     */
    public function copyInto($copyObj, $deepCopy = false, $makeNew = true)
    {
        $copyObj->setDesc($this->getDesc());
        $copyObj->setRemain($this->getRemain());
        $copyObj->setPrice($this->getPrice());
        $copyObj->setPriceOld($this->getPriceOld());
        $copyObj->setDestination($this->getDestination());
        $copyObj->setSaleId($this->getSaleId());
        $copyObj->setImage($this->getImage());
        $copyObj->setProductId($this->getProductId());
        $copyObj->setPricelistSheetId($this->getPricelistSheetId());
        $copyObj->setRefId($this->getRefId());

        if ($deepCopy) {
            // important: temporarily setNew(false) because this affects the behavior of
            // the getter/setter methods for fkey referrer objects.
            $copyObj->setNew(false);

            foreach ($this->getShopPositionSizes() as $relObj) {
                if ($relObj !== $this) {  // ensure that we don't try to copy a reference to ourselves
                    $copyObj->addShopPositionSize($relObj->copy($deepCopy));
                }
            }

        } // if ($deepCopy)

        if ($makeNew) {
            $copyObj->setNew(true);
            $copyObj->setId(NULL); // this is a auto-increment column, so set to default value
        }
    }

    /**
     * Makes a copy of this object that will be inserted as a new row in table when saved.
     * It creates a new object filling in the simple attributes, but skipping any primary
     * keys that are defined for the table.
     *
     * If desired, this method can also make copies of all associated (fkey referrers)
     * objects.
     *
     * @param  boolean $deepCopy Whether to also copy all rows that refer (by fkey) to the current row.
     * @return \Shop\Models\Position\Position Clone of current object.
     * @throws PropelException
     */
    public function copy($deepCopy = false)
    {
        // we use get_class(), because this might be a subclass
        $clazz = get_class($this);
        $copyObj = new $clazz();
        $this->copyInto($copyObj, $deepCopy);

        return $copyObj;
    }

    /**
     * Declares an association between this object and a Sale object.
     *
     * @param  Sale $v
     * @return $this|\Shop\Models\Position\Position The current object (for fluent API support)
     * @throws PropelException
     */
    public function setSale(Sale $v = null)
    {
        if ($v === null) {
            $this->setSaleId(NULL);
        } else {
            $this->setSaleId($v->getId());
        }

        $this->aSale = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Sale object, it will not be re-added.
        if ($v !== null) {
            $v->addPosition($this);
        }


        return $this;
    }


    /**
     * Get the associated Sale object
     *
     * @param  ConnectionInterface $con Optional Connection object.
     * @return Sale The associated Sale object.
     * @throws PropelException
     */
    public function getSale(ConnectionInterface $con = null)
    {
        if ($this->aSale === null && ($this->sale_id != 0)) {
            $this->aSale = SaleQuery::create()->findPk($this->sale_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aSale->addPositions($this);
             */
        }

        return $this->aSale;
    }

    /**
     * Declares an association between this object and a Product object.
     *
     * @param  Product $v
     * @return $this|\Shop\Models\Position\Position The current object (for fluent API support)
     * @throws PropelException
     */
    public function setProduct(Product $v = null)
    {
        if ($v === null) {
            $this->setProductId(NULL);
        } else {
            $this->setProductId($v->getId());
        }

        $this->aProduct = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the Product object, it will not be re-added.
        if ($v !== null) {
            $v->addPosition($this);
        }


        return $this;
    }


    /**
     * Get the associated Product object
     *
     * @param  ConnectionInterface $con Optional Connection object.
     * @return Product The associated Product object.
     * @throws PropelException
     */
    public function getProduct(ConnectionInterface $con = null)
    {
        if ($this->aProduct === null && ($this->product_id != 0)) {
            $this->aProduct = ProductQuery::create()->findPk($this->product_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aProduct->addPositions($this);
             */
        }

        return $this->aProduct;
    }

    /**
     * Declares an association between this object and a PricelistSheet object.
     *
     * @param  PricelistSheet $v
     * @return $this|\Shop\Models\Position\Position The current object (for fluent API support)
     * @throws PropelException
     */
    public function setPricelistSheet(PricelistSheet $v = null)
    {
        if ($v === null) {
            $this->setPricelistSheetId(NULL);
        } else {
            $this->setPricelistSheetId($v->getId());
        }

        $this->aPricelistSheet = $v;

        // Add binding for other direction of this n:n relationship.
        // If this object has already been added to the PricelistSheet object, it will not be re-added.
        if ($v !== null) {
            $v->addPosition($this);
        }


        return $this;
    }


    /**
     * Get the associated PricelistSheet object
     *
     * @param  ConnectionInterface $con Optional Connection object.
     * @return PricelistSheet The associated PricelistSheet object.
     * @throws PropelException
     */
    public function getPricelistSheet(ConnectionInterface $con = null)
    {
        if ($this->aPricelistSheet === null && ($this->pricelist_sheet_id != 0)) {
            $this->aPricelistSheet = PricelistSheetQuery::create()->findPk($this->pricelist_sheet_id, $con);
            /* The following can be used additionally to
                guarantee the related object contains a reference
                to this object.  This level of coupling may, however, be
                undesirable since it could result in an only partially populated collection
                in the referenced object.
                $this->aPricelistSheet->addPositions($this);
             */
        }

        return $this->aPricelistSheet;
    }


    /**
     * Initializes a collection based on the name of a relation.
     * Avoids crafting an 'init[$relationName]s' method name
     * that wouldn't work when StandardEnglishPluralizer is used.
     *
     * @param      string $relationName The name of the relation to initialize
     * @return void
     */
    public function initRelation($relationName)
    {
        if ('ShopPositionSize' == $relationName) {
            $this->initShopPositionSizes();
            return;
        }
    }

    /**
     * Clears out the collShopPositionSizes collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addShopPositionSizes()
     */
    public function clearShopPositionSizes()
    {
        $this->collShopPositionSizes = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Reset is the collShopPositionSizes collection loaded partially.
     */
    public function resetPartialShopPositionSizes($v = true)
    {
        $this->collShopPositionSizesPartial = $v;
    }

    /**
     * Initializes the collShopPositionSizes collection.
     *
     * By default this just sets the collShopPositionSizes collection to an empty array (like clearcollShopPositionSizes());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @param      boolean $overrideExisting If set to true, the method call initializes
     *                                        the collection even if it is not empty
     *
     * @return void
     */
    public function initShopPositionSizes($overrideExisting = true)
    {
        if (null !== $this->collShopPositionSizes && !$overrideExisting) {
            return;
        }

        $collectionClassName = ShopPositionSizeTableMap::getTableMap()->getCollectionClassName();

        $this->collShopPositionSizes = new $collectionClassName;
        $this->collShopPositionSizes->setModel('\Shop\Models\ShopPositionSize\ShopPositionSize');
    }

    /**
     * Gets an array of ShopPositionSize objects which contain a foreign key that references this object.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildPosition is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @return ObjectCollection|ShopPositionSize[] List of ShopPositionSize objects
     * @throws PropelException
     */
    public function getShopPositionSizes(Criteria $criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->collShopPositionSizesPartial && !$this->isNew();
        if (null === $this->collShopPositionSizes || null !== $criteria  || $partial) {
            if ($this->isNew() && null === $this->collShopPositionSizes) {
                // return empty collection
                $this->initShopPositionSizes();
            } else {
                $collShopPositionSizes = ShopPositionSizeQuery::create(null, $criteria)
                    ->filterByPosition($this)
                    ->find($con);

                if (null !== $criteria) {
                    if (false !== $this->collShopPositionSizesPartial && count($collShopPositionSizes)) {
                        $this->initShopPositionSizes(false);

                        foreach ($collShopPositionSizes as $obj) {
                            if (false == $this->collShopPositionSizes->contains($obj)) {
                                $this->collShopPositionSizes->append($obj);
                            }
                        }

                        $this->collShopPositionSizesPartial = true;
                    }

                    return $collShopPositionSizes;
                }

                if ($partial && $this->collShopPositionSizes) {
                    foreach ($this->collShopPositionSizes as $obj) {
                        if ($obj->isNew()) {
                            $collShopPositionSizes[] = $obj;
                        }
                    }
                }

                $this->collShopPositionSizes = $collShopPositionSizes;
                $this->collShopPositionSizesPartial = false;
            }
        }

        return $this->collShopPositionSizes;
    }

    /**
     * Sets a collection of ShopPositionSize objects related by a one-to-many relationship
     * to the current object.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param      Collection $shopPositionSizes A Propel collection.
     * @param      ConnectionInterface $con Optional connection object
     * @return $this|ChildPosition The current object (for fluent API support)
     */
    public function setShopPositionSizes(Collection $shopPositionSizes, ConnectionInterface $con = null)
    {
        /** @var ShopPositionSize[] $shopPositionSizesToDelete */
        $shopPositionSizesToDelete = $this->getShopPositionSizes(new Criteria(), $con)->diff($shopPositionSizes);


        //since at least one column in the foreign key is at the same time a PK
        //we can not just set a PK to NULL in the lines below. We have to store
        //a backup of all values, so we are able to manipulate these items based on the onDelete value later.
        $this->shopPositionSizesScheduledForDeletion = clone $shopPositionSizesToDelete;

        foreach ($shopPositionSizesToDelete as $shopPositionSizeRemoved) {
            $shopPositionSizeRemoved->setPosition(null);
        }

        $this->collShopPositionSizes = null;
        foreach ($shopPositionSizes as $shopPositionSize) {
            $this->addShopPositionSize($shopPositionSize);
        }

        $this->collShopPositionSizes = $shopPositionSizes;
        $this->collShopPositionSizesPartial = false;

        return $this;
    }

    /**
     * Returns the number of related BaseShopPositionSize objects.
     *
     * @param      Criteria $criteria
     * @param      boolean $distinct
     * @param      ConnectionInterface $con
     * @return int             Count of related BaseShopPositionSize objects.
     * @throws PropelException
     */
    public function countShopPositionSizes(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->collShopPositionSizesPartial && !$this->isNew();
        if (null === $this->collShopPositionSizes || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->collShopPositionSizes) {
                return 0;
            }

            if ($partial && !$criteria) {
                return count($this->getShopPositionSizes());
            }

            $query = ShopPositionSizeQuery::create(null, $criteria);
            if ($distinct) {
                $query->distinct();
            }

            return $query
                ->filterByPosition($this)
                ->count($con);
        }

        return count($this->collShopPositionSizes);
    }

    /**
     * Method called to associate a ShopPositionSize object to this object
     * through the ShopPositionSize foreign key attribute.
     *
     * @param  ShopPositionSize $l ShopPositionSize
     * @return $this|\Shop\Models\Position\Position The current object (for fluent API support)
     */
    public function addShopPositionSize(ShopPositionSize $l)
    {
        if ($this->collShopPositionSizes === null) {
            $this->initShopPositionSizes();
            $this->collShopPositionSizesPartial = true;
        }

        if (!$this->collShopPositionSizes->contains($l)) {
            $this->doAddShopPositionSize($l);

            if ($this->shopPositionSizesScheduledForDeletion and $this->shopPositionSizesScheduledForDeletion->contains($l)) {
                $this->shopPositionSizesScheduledForDeletion->remove($this->shopPositionSizesScheduledForDeletion->search($l));
            }
        }

        return $this;
    }

    /**
     * @param ShopPositionSize $shopPositionSize The ShopPositionSize object to add.
     */
    protected function doAddShopPositionSize(ShopPositionSize $shopPositionSize)
    {
        $this->collShopPositionSizes[]= $shopPositionSize;
        $shopPositionSize->setPosition($this);
    }

    /**
     * @param  ShopPositionSize $shopPositionSize The ShopPositionSize object to remove.
     * @return $this|ChildPosition The current object (for fluent API support)
     */
    public function removeShopPositionSize(ShopPositionSize $shopPositionSize)
    {
        if ($this->getShopPositionSizes()->contains($shopPositionSize)) {
            $pos = $this->collShopPositionSizes->search($shopPositionSize);
            $this->collShopPositionSizes->remove($pos);
            if (null === $this->shopPositionSizesScheduledForDeletion) {
                $this->shopPositionSizesScheduledForDeletion = clone $this->collShopPositionSizes;
                $this->shopPositionSizesScheduledForDeletion->clear();
            }
            $this->shopPositionSizesScheduledForDeletion[]= clone $shopPositionSize;
            $shopPositionSize->setPosition(null);
        }

        return $this;
    }


    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this Position is new, it will return
     * an empty collection; or if this Position has previously
     * been saved, it will retrieve related ShopPositionSizes from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in Position.
     *
     * @param      Criteria $criteria optional Criteria object to narrow the query
     * @param      ConnectionInterface $con optional connection object
     * @param      string $joinBehavior optional join type to use (defaults to Criteria::LEFT_JOIN)
     * @return ObjectCollection|ShopPositionSize[] List of ShopPositionSize objects
     */
    public function getShopPositionSizesJoinShopPositionSizeType(Criteria $criteria = null, ConnectionInterface $con = null, $joinBehavior = Criteria::LEFT_JOIN)
    {
        $query = ShopPositionSizeQuery::create(null, $criteria);
        $query->joinWith('ShopPositionSizeType', $joinBehavior);

        return $this->getShopPositionSizes($query, $con);
    }

    /**
     * Clears out the collShopPositionSizeTypeValues collection
     *
     * This does not modify the database; however, it will remove any associated objects, causing
     * them to be refetched by subsequent calls to accessor method.
     *
     * @return void
     * @see        addShopPositionSizeTypeValues()
     */
    public function clearShopPositionSizeTypeValues()
    {
        $this->collShopPositionSizeTypeValues = null; // important to set this to NULL since that means it is uninitialized
    }

    /**
     * Initializes the combinationCollShopPositionSizeTypeValues crossRef collection.
     *
     * By default this just sets the combinationCollShopPositionSizeTypeValues collection to an empty collection (like clearShopPositionSizeTypeValues());
     * however, you may wish to override this method in your stub class to provide setting appropriate
     * to your application -- for example, setting the initial array to the values stored in database.
     *
     * @return void
     */
    public function initShopPositionSizeTypeValues()
    {
        $this->combinationCollShopPositionSizeTypeValues = new ObjectCombinationCollection;
        $this->combinationCollShopPositionSizeTypeValuesPartial = true;
    }

    /**
     * Checks if the combinationCollShopPositionSizeTypeValues collection is loaded.
     *
     * @return bool
     */
    public function isShopPositionSizeTypeValuesLoaded()
    {
        return null !== $this->combinationCollShopPositionSizeTypeValues;
    }

    /**
     * Returns a new query object pre configured with filters from current object and given arguments to query the database.
     *
     * @param string $value
     * @param Criteria $criteria
     *
     * @return ShopPositionSizeTypeQuery
     */
    public function createShopPositionSizeTypesQuery($value = null, Criteria $criteria = null)
    {
        $criteria = ShopPositionSizeTypeQuery::create($criteria)
            ->filterByPosition($this);

        $shopPositionSizeQuery = $criteria->useShopPositionSizeQuery();

        if (null !== $value) {
            $shopPositionSizeQuery->filterByValue($value);
        }

        $shopPositionSizeQuery->endUse();

        return $criteria;
    }

    /**
     * Gets a combined collection of ShopPositionSizeType objects related by a many-to-many relationship
     * to the current object by way of the shop_position_sizes cross-reference table.
     *
     * If the $criteria is not null, it is used to always fetch the results from the database.
     * Otherwise the results are fetched from the database the first time, then cached.
     * Next time the same method is called without $criteria, the cached collection is returned.
     * If this ChildPosition is new, it will return
     * an empty collection or the current collection; the criteria is ignored on a new object.
     *
     * @param      Criteria $criteria Optional query object to filter the query
     * @param      ConnectionInterface $con Optional connection object
     *
     * @return ObjectCombinationCollection Combination list of ShopPositionSizeType objects
     */
    public function getShopPositionSizeTypeValues($criteria = null, ConnectionInterface $con = null)
    {
        $partial = $this->combinationCollShopPositionSizeTypeValuesPartial && !$this->isNew();
        if (null === $this->combinationCollShopPositionSizeTypeValues || null !== $criteria || $partial) {
            if ($this->isNew()) {
                // return empty collection
                if (null === $this->combinationCollShopPositionSizeTypeValues) {
                    $this->initShopPositionSizeTypeValues();
                }
            } else {

                $query = ShopPositionSizeQuery::create(null, $criteria)
                    ->filterByPosition($this)
                    ->joinShopPositionSizeType()
                ;

                $items = $query->find($con);
                $combinationCollShopPositionSizeTypeValues = new ObjectCombinationCollection();
                foreach ($items as $item) {
                    $combination = [];

                    $combination[] = $item->getShopPositionSizeType();
                    $combination[] = $item->getValue();
                    $combinationCollShopPositionSizeTypeValues[] = $combination;
                }

                if (null !== $criteria) {
                    return $combinationCollShopPositionSizeTypeValues;
                }

                if ($partial && $this->combinationCollShopPositionSizeTypeValues) {
                    //make sure that already added objects gets added to the list of the database.
                    foreach ($this->combinationCollShopPositionSizeTypeValues as $obj) {
                        if (!call_user_func_array([$combinationCollShopPositionSizeTypeValues, 'contains'], $obj)) {
                            $combinationCollShopPositionSizeTypeValues[] = $obj;
                        }
                    }
                }

                $this->combinationCollShopPositionSizeTypeValues = $combinationCollShopPositionSizeTypeValues;
                $this->combinationCollShopPositionSizeTypeValuesPartial = false;
            }
        }

        return $this->combinationCollShopPositionSizeTypeValues;
    }

    /**
     * Returns a not cached ObjectCollection of ShopPositionSizeType objects. This will hit always the databases.
     * If you have attached new ShopPositionSizeType object to this object you need to call `save` first to get
     * the correct return value. Use getShopPositionSizeTypeValues() to get the current internal state.
     *
     * @param string $value
     * @param Criteria $criteria
     * @param ConnectionInterface $con
     *
     * @return ShopPositionSizeType[]|ObjectCollection
     */
    public function getShopPositionSizeTypes($value = null, Criteria $criteria = null, ConnectionInterface $con = null)
    {
        return $this->createShopPositionSizeTypesQuery($value, $criteria)->find($con);
    }

    /**
     * Sets a collection of ChildShopPositionSizeType objects related by a many-to-many relationship
     * to the current object by way of the shop_position_sizes cross-reference table.
     * It will also schedule objects for deletion based on a diff between old objects (aka persisted)
     * and new objects from the given Propel collection.
     *
     * @param  Collection $shopPositionSizeTypeValues A Propel collection.
     * @param  ConnectionInterface $con Optional connection object
     * @return $this|ChildPosition The current object (for fluent API support)
     */
    public function setShopPositionSizeTypeValues(Collection $shopPositionSizeTypeValues, ConnectionInterface $con = null)
    {
        $this->clearShopPositionSizeTypeValues();
        $currentShopPositionSizeTypeValues = $this->getShopPositionSizeTypeValues();

        $combinationCollShopPositionSizeTypeValuesScheduledForDeletion = $currentShopPositionSizeTypeValues->diff($shopPositionSizeTypeValues);

        foreach ($combinationCollShopPositionSizeTypeValuesScheduledForDeletion as $toDelete) {
            call_user_func_array([$this, 'removeShopPositionSizeTypeValue'], $toDelete);
        }

        foreach ($shopPositionSizeTypeValues as $shopPositionSizeTypeValue) {
            if (!call_user_func_array([$currentShopPositionSizeTypeValues, 'contains'], $shopPositionSizeTypeValue)) {
                call_user_func_array([$this, 'doAddShopPositionSizeTypeValue'], $shopPositionSizeTypeValue);
            }
        }

        $this->combinationCollShopPositionSizeTypeValuesPartial = false;
        $this->combinationCollShopPositionSizeTypeValues = $shopPositionSizeTypeValues;

        return $this;
    }

    /**
     * Gets the number of ChildShopPositionSizeType objects related by a many-to-many relationship
     * to the current object by way of the shop_position_sizes cross-reference table.
     *
     * @param      Criteria $criteria Optional query object to filter the query
     * @param      boolean $distinct Set to true to force count distinct
     * @param      ConnectionInterface $con Optional connection object
     *
     * @return int the number of related ChildShopPositionSizeType objects
     */
    public function countShopPositionSizeTypeValues(Criteria $criteria = null, $distinct = false, ConnectionInterface $con = null)
    {
        $partial = $this->combinationCollShopPositionSizeTypeValuesPartial && !$this->isNew();
        if (null === $this->combinationCollShopPositionSizeTypeValues || null !== $criteria || $partial) {
            if ($this->isNew() && null === $this->combinationCollShopPositionSizeTypeValues) {
                return 0;
            } else {

                if ($partial && !$criteria) {
                    return count($this->getShopPositionSizeTypeValues());
                }

                $query = ShopPositionSizeQuery::create(null, $criteria);
                if ($distinct) {
                    $query->distinct();
                }

                return $query
                    ->filterByPosition($this)
                    ->count($con);
            }
        } else {
            return count($this->combinationCollShopPositionSizeTypeValues);
        }
    }

    /**
     * Returns the not cached count of ShopPositionSizeType objects. This will hit always the databases.
     * If you have attached new ShopPositionSizeType object to this object you need to call `save` first to get
     * the correct return value. Use getShopPositionSizeTypeValues() to get the current internal state.
     *
     * @param string $value
     * @param Criteria $criteria
     * @param ConnectionInterface $con
     *
     * @return integer
     */
    public function countShopPositionSizeTypes($value = null, Criteria $criteria = null, ConnectionInterface $con = null)
    {
        return $this->createShopPositionSizeTypesQuery($value, $criteria)->count($con);
    }

    /**
     * Associate a ShopPositionSizeType to this object
     * through the shop_position_sizes cross reference table.
     *
     * @param ShopPositionSizeType $shopPositionSizeType,
     * @param string $value
     * @return ChildPosition The current object (for fluent API support)
     */
    public function addShopPositionSizeType(ShopPositionSizeType $shopPositionSizeType, $value)
    {
        if ($this->combinationCollShopPositionSizeTypeValues === null) {
            $this->initShopPositionSizeTypeValues();
        }

        if (!$this->getShopPositionSizeTypeValues()->contains($shopPositionSizeType, $value)) {
            // only add it if the **same** object is not already associated
            $this->combinationCollShopPositionSizeTypeValues->push($shopPositionSizeType, $value);
            $this->doAddShopPositionSizeTypeValue($shopPositionSizeType, $value);
        }

        return $this;
    }

    /**
     *
     * @param ShopPositionSizeType $shopPositionSizeType,
     * @param string $value
     */
    protected function doAddShopPositionSizeTypeValue(ShopPositionSizeType $shopPositionSizeType, $value)
    {
        $shopPositionSize = new ShopPositionSize();

        $shopPositionSize->setShopPositionSizeType($shopPositionSizeType);
        $shopPositionSize->setValue($value);


        $shopPositionSize->setPosition($this);

        $this->addShopPositionSize($shopPositionSize);

        // set the back reference to this object directly as using provided method either results
        // in endless loop or in multiple relations
        if ($shopPositionSizeType->isPositionValuesLoaded()) {
            $shopPositionSizeType->initPositionValues();
            $shopPositionSizeType->getPositionValues()->push($this, $value);
        } elseif (!$shopPositionSizeType->getPositionValues()->contains($this, $value)) {
            $shopPositionSizeType->getPositionValues()->push($this, $value);
        }

    }

    /**
     * Remove shopPositionSizeType, value of this object
     * through the shop_position_sizes cross reference table.
     *
     * @param ShopPositionSizeType $shopPositionSizeType,
     * @param string $value
     * @return ChildPosition The current object (for fluent API support)
     */
    public function removeShopPositionSizeTypeValue(ShopPositionSizeType $shopPositionSizeType, $value)
    {
        if ($this->getShopPositionSizeTypeValues()->contains($shopPositionSizeType, $value)) {
            $shopPositionSize = new ShopPositionSize();
            $shopPositionSize->setShopPositionSizeType($shopPositionSizeType);
            if ($shopPositionSizeType->isPositionValuesLoaded()) {
                //remove the back reference if available
                $shopPositionSizeType->getPositionValues()->removeObject($this, $value);
            }

            $shopPositionSize->setValue($value);
            $shopPositionSize->setPosition($this);
            $this->removeShopPositionSize(clone $shopPositionSize);
            $shopPositionSize->clear();

            $this->combinationCollShopPositionSizeTypeValues->remove($this->combinationCollShopPositionSizeTypeValues->search($shopPositionSizeType, $value));

            if (null === $this->combinationCollShopPositionSizeTypeValuesScheduledForDeletion) {
                $this->combinationCollShopPositionSizeTypeValuesScheduledForDeletion = clone $this->combinationCollShopPositionSizeTypeValues;
                $this->combinationCollShopPositionSizeTypeValuesScheduledForDeletion->clear();
            }

            $this->combinationCollShopPositionSizeTypeValuesScheduledForDeletion->push($shopPositionSizeType, $value);
        }


        return $this;
    }

    /**
     * Clears the current object, sets all attributes to their default values and removes
     * outgoing references as well as back-references (from other objects to this one. Results probably in a database
     * change of those foreign objects when you call `save` there).
     */
    public function clear()
    {
        if (null !== $this->aSale) {
            $this->aSale->removePosition($this);
        }
        if (null !== $this->aProduct) {
            $this->aProduct->removePosition($this);
        }
        if (null !== $this->aPricelistSheet) {
            $this->aPricelistSheet->removePosition($this);
        }
        $this->id = null;
        $this->desc = null;
        $this->remain = null;
        $this->price = null;
        $this->price_old = null;
        $this->destination = null;
        $this->sale_id = null;
        $this->image = null;
        $this->product_id = null;
        $this->pricelist_sheet_id = null;
        $this->ref_id = null;
        $this->alreadyInSave = false;
        $this->clearAllReferences();
        $this->applyDefaultValues();
        $this->resetModified();
        $this->setNew(true);
        $this->setDeleted(false);
    }

    /**
     * Resets all references and back-references to other model objects or collections of model objects.
     *
     * This method is used to reset all php object references (not the actual reference in the database).
     * Necessary for object serialisation.
     *
     * @param      boolean $deep Whether to also clear the references on all referrer objects.
     */
    public function clearAllReferences($deep = false)
    {
        if ($deep) {
            if ($this->collShopPositionSizes) {
                foreach ($this->collShopPositionSizes as $o) {
                    $o->clearAllReferences($deep);
                }
            }
            if ($this->combinationCollShopPositionSizeTypeValues) {
                foreach ($this->combinationCollShopPositionSizeTypeValues as $o) {
                    $o->clearAllReferences($deep);
                }
            }
        } // if ($deep)

        $this->collShopPositionSizes = null;
        $this->combinationCollShopPositionSizeTypeValues = null;
        $this->aSale = null;
        $this->aProduct = null;
        $this->aPricelistSheet = null;
    }

    /**
     * Return the string representation of this object
     *
     * @return string
     */
    public function __toString()
    {
        return (string) $this->exportTo(PositionTableMap::DEFAULT_STRING_FORMAT);
    }

    /**
     * Code to be run before persisting the object
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preSave(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preSave')) {
            return parent::preSave($con);
        }
        return true;
    }

    /**
     * Code to be run after persisting the object
     * @param ConnectionInterface $con
     */
    public function postSave(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postSave')) {
            parent::postSave($con);
        }
    }

    /**
     * Code to be run before inserting to database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preInsert(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preInsert')) {
            return parent::preInsert($con);
        }
        return true;
    }

    /**
     * Code to be run after inserting to database
     * @param ConnectionInterface $con
     */
    public function postInsert(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postInsert')) {
            parent::postInsert($con);
        }
    }

    /**
     * Code to be run before updating the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preUpdate(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preUpdate')) {
            return parent::preUpdate($con);
        }
        return true;
    }

    /**
     * Code to be run after updating the object in database
     * @param ConnectionInterface $con
     */
    public function postUpdate(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postUpdate')) {
            parent::postUpdate($con);
        }
    }

    /**
     * Code to be run before deleting the object in database
     * @param  ConnectionInterface $con
     * @return boolean
     */
    public function preDelete(ConnectionInterface $con = null)
    {
        if (is_callable('parent::preDelete')) {
            return parent::preDelete($con);
        }
        return true;
    }

    /**
     * Code to be run after deleting the object in database
     * @param ConnectionInterface $con
     */
    public function postDelete(ConnectionInterface $con = null)
    {
        if (is_callable('parent::postDelete')) {
            parent::postDelete($con);
        }
    }


    /**
     * Derived method to catches calls to undefined methods.
     *
     * Provides magic import/export method support (fromXML()/toXML(), fromYAML()/toYAML(), etc.).
     * Allows to define default __call() behavior if you overwrite __call()
     *
     * @param string $name
     * @param mixed  $params
     *
     * @return array|string
     */
    public function __call($name, $params)
    {
        if (0 === strpos($name, 'get')) {
            $virtualColumn = substr($name, 3);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }

            $virtualColumn = lcfirst($virtualColumn);
            if ($this->hasVirtualColumn($virtualColumn)) {
                return $this->getVirtualColumn($virtualColumn);
            }
        }

        if (0 === strpos($name, 'from')) {
            $format = substr($name, 4);

            return $this->importFrom($format, reset($params));
        }

        if (0 === strpos($name, 'to')) {
            $format = substr($name, 2);
            $includeLazyLoadColumns = isset($params[0]) ? $params[0] : true;

            return $this->exportTo($format, $includeLazyLoadColumns);
        }

        throw new BadMethodCallException(sprintf('Call to undefined method: %s.', $name));
    }

}
