<?php

namespace Shop\Modules\MetricWidget;

use Shop\Models\Position\Position;
use Shop\Models\Position\PositionQuery;
use Shop\Models\Product\ProductQuery;
use Shop\UseCases\Catalog\CatalogService;
use Shop\UseCases\Notification\NotificationService;
use Shop\Application\Office\OfficeService;
use Shop\UseCases\Shopping\ShoppingService;

/**
 * Description of MetricWidget
 *
 * @author Diamond Code Generator
 */
class MetricWidget extends \Core\ModuleController
{

    protected $customerRepo;
    protected $orderRepo;
    protected $productRepo;
    protected $confMain;
    protected $officeService;
    protected $shoppingService;
    protected $catalogService;
    protected $notificationService;

    public function __construct(
        \Shop\Config\Main $confMain,
        OfficeService $officeService,
        ShoppingService $shoppingService,
        CatalogService $catalogService
    )
    {

        $this->confMain = $confMain;
        $this->officeService = $officeService;
        $this->shoppingService = $shoppingService;
        $this->catalogService = $catalogService;
    }

    public function process(): string
    {

        $clientsCount = $this->officeService->getCustomersCount();

        $clientsCountActive = $this->officeService->getActiveCustomersCount();

        $ordersCount = $this->shoppingService->getCustomerOrdersCount();

        $productsCount = ProductQuery::create()->count();

        $ordersSumm = $this->shoppingService->getSumCustomerOrdersByIgnoreStates((array)$this->confMain->getStateCancel());

        $countPos = PositionQuery::create()->count();

        return $this->render([
            "clientsCount" => (int)$clientsCount,
            "clientsCountActive" => (int)$clientsCountActive,
            "percent" => $clientsCount ? round($clientsCountActive / $clientsCount, 2) * 100 : 0,
            "ordersCount" => $ordersCount,
            "productsCount" => $productsCount,
            "ordersSumm" => \Shop\Helpers\Price::format($ordersSumm, 0),
            "cur" => $this->confMain->getCurencyDisplay(),
            'price_pos_count' => $countPos
        ]);
    }

}