<?php


namespace Shop\Repositories\PriceFile;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\PriceFile\Contracts\PriceFileCriteriaInterface;

class PriceFileCriteria extends AbstractCriteria implements PriceFileCriteriaInterface
{
    /**
     * @var string|null
     */
    protected $searchByName;

    public static function create()
    {
        return new self();
    }

    /**
     * @return string|null
     */
    public function getSearchByName(): ?string
    {
        return $this->searchByName;
    }

    /**
     * @param string|null $searchByName
     * @return PriceFileCriteria
     */
    public function setSearchByName(?string $searchByName): PriceFileCriteriaInterface
    {
        $this->searchByName = $searchByName;
        return $this;
    }
}