<?php


namespace Shop\Application\Basket\AddItemInCurrentBasket;

/**
 * Class AddItemInCurrentBasketCommand
 * @package Shop\UseCases\ShoppingCart
 */
class AddItemInCurrentBasketCommand
{
    /**
     * @var BasketItemRequest
     */
    protected $basketItemRequest;

    /**
     * @var BasketItemResult
     */
    protected $basketItemResult;

    public function __construct(BasketItemRequest $basketItemRequest, BasketItemResult $basketItemResult)
    {
        $this->basketItemRequest = $basketItemRequest;
        $this->basketItemResult = $basketItemResult;
    }

    /**
     * @return BasketItemRequest
     */
    public function getBasketItemRequest(): BasketItemRequest
    {
        return $this->basketItemRequest;
    }

    /**
     * @return BasketItemResult
     */
    public function getBasketItemResult(): BasketItemResult
    {
        return $this->basketItemResult;
    }


}