<?php

namespace Shop\Modules\AdminCatalogs;


use ActiveTable\ColumnTable;
use ActiveTable\DataTableEngine;
use Core\Form\ControlBuilder;
use Core\ModuleController;
use DiamondTable\TableFactory;
use Shop\Domain\Catalog\Contracts\CatalogEntityInterface;
use Shop\Helpers\Text;
use Shop\Repositories\Catalog\CatalogCriteria;
use Shop\Repositories\Catalog\CatalogRepository;

/**
 * Description of AdminBrands
 *
 * @author Dmitriy
 */
class AdminCatalogs extends ModuleController
{

    protected $catalogRepository;
    protected $tableFactory;
    protected $controlBuilder;

    public function __construct(CatalogRepository $catalogRepository, TableFactory $tableFactory, ControlBuilder $controlBuilder)
    {
        $this->catalogRepository = $catalogRepository;
        $this->controlBuilder = $controlBuilder;
        $this->tableFactory = $tableFactory;
    }

    //put your code here
    public function process(): string
    {

        $table = $this->tableFactory->buildAdminTable($this->catalogRepository, CatalogCriteria::create());

        $table
            ->removeControlAccess(DataTableEngine::CONTROL_ROWS_SELECT)
            ->addColumn(
                (new ColumnTable('id', '№'))
                    ->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('name', 'Наименование'))

            )
            ->addColumn(
                (new ColumnTable('alias', 'Псевдоним'))

            )
            ->addColumn(
                (new ColumnTable('desc', 'Описание'))
                    ->setFormat($this, 'formatDesc')

            )
            ->addColumn(
                (new ColumnTable('active', 'Удален'))
                    ->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setFormat($this, 'formatActions')
                    ->setWidth(140)
            );
        ;

        $table
            ->addField(
                $this->controlBuilder->buildInput('name')
            )
            ->addField(
                $this->controlBuilder->buildInput('alias'),true,null,'для использования в ЧПУ'
            )
            ->addField(
                $this->controlBuilder
                    ->buildTextEditor('desc')
                    ->setHeight(200)
                    ->setCompact(true),false,null,'Первая картинка в описании будет использоваться в фильтре как логотип'
            )
            ;
        
        $table
            ->addFilter(
                $this->controlBuilder->buildInput('active')
            )
        ;

        $this->tableFactory->prepareAdminTableForDomain($table);

        return $table->render();
    }

    /**
     * @param CatalogEntityInterface $catalog
     * @return string
     */
    public function formatDesc(CatalogEntityInterface $catalog): string
    {
        if(!$content = $catalog->getDesc()){
            return '';
        }
        return Text::clearText($content);
    }

    /**
     * @param CatalogEntityInterface $categoryEntity
     * @return string
     */
    public function formatActions(CatalogEntityInterface $categoryEntity): string
    {
        $id = $categoryEntity->getId();

        return $this->controlBuilder->buildActionMenuAdmin([
            anchor(
                adaptive_url([
                    'fn' => 'add',
                    'parent_id' => $id
                ]),
                'Добавить каталог'),

        ], $id)->render();
    }

}