<?php

namespace Shop\Modules\AdminCurriencies;

use ActiveTable\ColumnTable;
use Core\Form\ControlBuilder;
use DiamondTable\TableFactory;
use Shop\Repositories\Currency\CurrencyCriteria;
use Shop\Repositories\Currency\CurrencyRepository;

/**
 * Class AdminCurriencies
 * @package Shop\Modules\AdminCurriencies
 */
class AdminCurriencies extends \Core\ModuleController
{

    protected $currencyRepository;
    protected $tableFactory;
    protected $controlBuilder;

    public function __construct(CurrencyRepository $currencyRepository, TableFactory $tableFactory, ControlBuilder $controlBuilder)
    {
        $this->currencyRepository = $currencyRepository;
        $this->tableFactory = $tableFactory;
        $this->controlBuilder = $controlBuilder;
    }


    public function process(): string
    {

        $table = $this->tableFactory->buildAdminTable($this->currencyRepository,CurrencyCriteria::create());

        $table
            ->addColumn(
                (new ColumnTable('id','№'))->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('name','Наименование'))
            )
            ->addColumn(
                (new ColumnTable('native','Валюта сайта'))
            )
            ->addColumn(
                (new ColumnTable('htmlSign','Отображение на сайте'))
            )
            ->addColumn(
                (new ColumnTable('displayed','Показывать'))
            )
            ->addColumn(
                (new ColumnTable('iso','Буквенный код'))
            )
            ->addColumn(
                (new ColumnTable('roundMode','Режим округления'))
            )
            ->addColumn(
                (new ColumnTable('roundPrice','Точность округления'))
            )
            ->addColumn(
                (new ColumnTable('actions',''))
                    ->setFormat($this->tableFactory,'formatActions')
                    ->setWidth(120)
            )
            ;

        $table
            ->addField(
                $this->controlBuilder->buildInputSmall('name'),true
            )
            ->addField(
                $this->controlBuilder->buildInputSmall('htmlSign'),true
            )
            ->addField(
                $this->controlBuilder->buildDropdownYNUniform('displayed'),true
            )
            ->addField(
                $this->controlBuilder->buildInputLittle('iso'),true,null,'ISO'
            )
            ->addField(
                $this->controlBuilder->buildSpinner('roundPrice')->setValue(1),true,null
            )
            ->addField(
                $this->controlBuilder->buildDropdownUniform('roundMode', ['ceil' => 'в большую', 'round' => 'в меньшую'])
            )
        ;

        return $table->render();
    }

}