<?php


namespace Shop\Modules\AdminProviderOrders;


use ActiveTable\Contracts\CommandInterface;
use Diamond\Helpers\Form;
use Shop\UseCases\Checkout\Checkout;
use Shop\UseCases\Checkout\Exceptions\CheckoutException;
use Shop\UseCases\Checkout\Exceptions\MergeCountOrdersException;
use Shop\UseCases\Checkout\Exceptions\MergeOrdersFoundSomeContractorsException;
use Shop\UseCases\Checkout\Exceptions\MergeOrdersFoundSomeCustomerException;
use Symfony\Component\HttpFoundation\RedirectResponse;

class MergeProviderOrdersCommand implements CommandInterface
{
    protected $checkoutUseCase;

    public function __construct(Checkout $checkoutUseCase)
    {
        $this->checkoutUseCase = $checkoutUseCase;
    }

    /**
     * @throws \Propel\Runtime\Exception\PropelException
     */
    public function process(): void
    {

        $ids = Form::getIdsFromRequest();

        try {
            $newOrder = $this->checkoutUseCase->mergeProviderOrdersByIds($ids);

            Form::addTableNotice(Form::buildSuccessMessage(
                sprintf(
                    'Заказы успешно объединены c заказом %s',
                    $newOrder->getOrderCode()
                )
            ));

        } catch (MergeCountOrdersException $ex) {
            Form::addTableNotice(Form::buildErrorMessage('Для объединения заказов необходимо выбрать минимум две записи'));
        } catch (MergeOrdersFoundSomeCustomerException $ex) {
            Form::addTableNotice(Form::buildErrorMessage('Заказы должны принадлежать одному покупателю'));
        }
        catch (MergeOrdersFoundSomeContractorsException $ex) {
            Form::addTableNotice(Form::buildErrorMessage('Заказы должны принадлежать одному поставщику'));
        }
        catch (CheckoutException $ex) {
            Form::addTableNotice(Form::buildErrorMessage('При объединении произошла ошибка'));
        }

        RedirectResponse::create(adaptive_url([], ['fn', 'id']))->send();
    }

}