<?php

namespace Shop\Models\PricelistFile\Base;

use \Exception;
use \PDO;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\PricelistFile\PricelistFile as ChildPricelistFile;
use Shop\Models\PricelistFile\PricelistFileQuery as ChildPricelistFileQuery;
use Shop\Models\PricelistFile\Map\PricelistFileTableMap;
use Shop\Models\PricelistSheet\PricelistSheet;
use Shop\Models\Provider\Provider;

/**
 * Base class that represents a query for the 'shop_pricelist_files' table.
 *
 *
 *
 * @method     ChildPricelistFileQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildPricelistFileQuery orderByName($order = Criteria::ASC) Order by the name column
 * @method     ChildPricelistFileQuery orderByProviderId($order = Criteria::ASC) Order by the provider_id column
 *
 * @method     ChildPricelistFileQuery groupById() Group by the id column
 * @method     ChildPricelistFileQuery groupByName() Group by the name column
 * @method     ChildPricelistFileQuery groupByProviderId() Group by the provider_id column
 *
 * @method     ChildPricelistFileQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildPricelistFileQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildPricelistFileQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildPricelistFileQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildPricelistFileQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildPricelistFileQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildPricelistFileQuery leftJoinProvider($relationAlias = null) Adds a LEFT JOIN clause to the query using the Provider relation
 * @method     ChildPricelistFileQuery rightJoinProvider($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Provider relation
 * @method     ChildPricelistFileQuery innerJoinProvider($relationAlias = null) Adds a INNER JOIN clause to the query using the Provider relation
 *
 * @method     ChildPricelistFileQuery joinWithProvider($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Provider relation
 *
 * @method     ChildPricelistFileQuery leftJoinWithProvider() Adds a LEFT JOIN clause and with to the query using the Provider relation
 * @method     ChildPricelistFileQuery rightJoinWithProvider() Adds a RIGHT JOIN clause and with to the query using the Provider relation
 * @method     ChildPricelistFileQuery innerJoinWithProvider() Adds a INNER JOIN clause and with to the query using the Provider relation
 *
 * @method     ChildPricelistFileQuery leftJoinPricelistSheet($relationAlias = null) Adds a LEFT JOIN clause to the query using the PricelistSheet relation
 * @method     ChildPricelistFileQuery rightJoinPricelistSheet($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PricelistSheet relation
 * @method     ChildPricelistFileQuery innerJoinPricelistSheet($relationAlias = null) Adds a INNER JOIN clause to the query using the PricelistSheet relation
 *
 * @method     ChildPricelistFileQuery joinWithPricelistSheet($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the PricelistSheet relation
 *
 * @method     ChildPricelistFileQuery leftJoinWithPricelistSheet() Adds a LEFT JOIN clause and with to the query using the PricelistSheet relation
 * @method     ChildPricelistFileQuery rightJoinWithPricelistSheet() Adds a RIGHT JOIN clause and with to the query using the PricelistSheet relation
 * @method     ChildPricelistFileQuery innerJoinWithPricelistSheet() Adds a INNER JOIN clause and with to the query using the PricelistSheet relation
 *
 * @method     \Shop\Models\Provider\ProviderQuery|\Shop\Models\PricelistSheet\PricelistSheetQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildPricelistFile findOne(ConnectionInterface $con = null) Return the first ChildPricelistFile matching the query
 * @method     ChildPricelistFile findOneOrCreate(ConnectionInterface $con = null) Return the first ChildPricelistFile matching the query, or a new ChildPricelistFile object populated from the query conditions when no match is found
 *
 * @method     ChildPricelistFile findOneById(int $id) Return the first ChildPricelistFile filtered by the id column
 * @method     ChildPricelistFile findOneByName(string $name) Return the first ChildPricelistFile filtered by the name column
 * @method     ChildPricelistFile findOneByProviderId(int $provider_id) Return the first ChildPricelistFile filtered by the provider_id column *

 * @method     ChildPricelistFile requirePk($key, ConnectionInterface $con = null) Return the ChildPricelistFile by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPricelistFile requireOne(ConnectionInterface $con = null) Return the first ChildPricelistFile matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildPricelistFile requireOneById(int $id) Return the first ChildPricelistFile filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPricelistFile requireOneByName(string $name) Return the first ChildPricelistFile filtered by the name column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPricelistFile requireOneByProviderId(int $provider_id) Return the first ChildPricelistFile filtered by the provider_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildPricelistFile[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildPricelistFile objects based on current ModelCriteria
 * @method     ChildPricelistFile[]|ObjectCollection findById(int $id) Return ChildPricelistFile objects filtered by the id column
 * @method     ChildPricelistFile[]|ObjectCollection findByName(string $name) Return ChildPricelistFile objects filtered by the name column
 * @method     ChildPricelistFile[]|ObjectCollection findByProviderId(int $provider_id) Return ChildPricelistFile objects filtered by the provider_id column
 * @method     ChildPricelistFile[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class PricelistFileQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Models\PricelistFile\Base\PricelistFileQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\PricelistFile\\PricelistFile', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildPricelistFileQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildPricelistFileQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildPricelistFileQuery) {
            return $criteria;
        }
        $query = new ChildPricelistFileQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildPricelistFile|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(PricelistFileTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = PricelistFileTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildPricelistFile A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `name`, `provider_id` FROM `shop_pricelist_files` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildPricelistFile $obj */
            $obj = new ChildPricelistFile();
            $obj->hydrate($row);
            PricelistFileTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildPricelistFile|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildPricelistFileQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(PricelistFileTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildPricelistFileQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(PricelistFileTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPricelistFileQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(PricelistFileTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(PricelistFileTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PricelistFileTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the name column
     *
     * Example usage:
     * <code>
     * $query->filterByName('fooValue');   // WHERE name = 'fooValue'
     * $query->filterByName('%fooValue%', Criteria::LIKE); // WHERE name LIKE '%fooValue%'
     * </code>
     *
     * @param     string $name The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPricelistFileQuery The current query, for fluid interface
     */
    public function filterByName($name = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($name)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PricelistFileTableMap::COL_NAME, $name, $comparison);
    }

    /**
     * Filter the query on the provider_id column
     *
     * Example usage:
     * <code>
     * $query->filterByProviderId(1234); // WHERE provider_id = 1234
     * $query->filterByProviderId(array(12, 34)); // WHERE provider_id IN (12, 34)
     * $query->filterByProviderId(array('min' => 12)); // WHERE provider_id > 12
     * </code>
     *
     * @see       filterByProvider()
     *
     * @param     mixed $providerId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPricelistFileQuery The current query, for fluid interface
     */
    public function filterByProviderId($providerId = null, $comparison = null)
    {
        if (is_array($providerId)) {
            $useMinMax = false;
            if (isset($providerId['min'])) {
                $this->addUsingAlias(PricelistFileTableMap::COL_PROVIDER_ID, $providerId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($providerId['max'])) {
                $this->addUsingAlias(PricelistFileTableMap::COL_PROVIDER_ID, $providerId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PricelistFileTableMap::COL_PROVIDER_ID, $providerId, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Models\Provider\Provider object
     *
     * @param \Shop\Models\Provider\Provider|ObjectCollection $provider The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildPricelistFileQuery The current query, for fluid interface
     */
    public function filterByProvider($provider, $comparison = null)
    {
        if ($provider instanceof \Shop\Models\Provider\Provider) {
            return $this
                ->addUsingAlias(PricelistFileTableMap::COL_PROVIDER_ID, $provider->getId(), $comparison);
        } elseif ($provider instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(PricelistFileTableMap::COL_PROVIDER_ID, $provider->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByProvider() only accepts arguments of type \Shop\Models\Provider\Provider or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Provider relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildPricelistFileQuery The current query, for fluid interface
     */
    public function joinProvider($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Provider');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Provider');
        }

        return $this;
    }

    /**
     * Use the Provider relation Provider object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Provider\ProviderQuery A secondary query class using the current class as primary query
     */
    public function useProviderQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinProvider($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Provider', '\Shop\Models\Provider\ProviderQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\PricelistSheet\PricelistSheet object
     *
     * @param \Shop\Models\PricelistSheet\PricelistSheet|ObjectCollection $pricelistSheet the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildPricelistFileQuery The current query, for fluid interface
     */
    public function filterByPricelistSheet($pricelistSheet, $comparison = null)
    {
        if ($pricelistSheet instanceof \Shop\Models\PricelistSheet\PricelistSheet) {
            return $this
                ->addUsingAlias(PricelistFileTableMap::COL_ID, $pricelistSheet->getPricelistFileId(), $comparison);
        } elseif ($pricelistSheet instanceof ObjectCollection) {
            return $this
                ->usePricelistSheetQuery()
                ->filterByPrimaryKeys($pricelistSheet->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByPricelistSheet() only accepts arguments of type \Shop\Models\PricelistSheet\PricelistSheet or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PricelistSheet relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildPricelistFileQuery The current query, for fluid interface
     */
    public function joinPricelistSheet($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PricelistSheet');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PricelistSheet');
        }

        return $this;
    }

    /**
     * Use the PricelistSheet relation PricelistSheet object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\PricelistSheet\PricelistSheetQuery A secondary query class using the current class as primary query
     */
    public function usePricelistSheetQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPricelistSheet($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PricelistSheet', '\Shop\Models\PricelistSheet\PricelistSheetQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildPricelistFile $pricelistFile Object to remove from the list of results
     *
     * @return $this|ChildPricelistFileQuery The current query, for fluid interface
     */
    public function prune($pricelistFile = null)
    {
        if ($pricelistFile) {
            $this->addUsingAlias(PricelistFileTableMap::COL_ID, $pricelistFile->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_pricelist_files table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PricelistFileTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            PricelistFileTableMap::clearInstancePool();
            PricelistFileTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PricelistFileTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(PricelistFileTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            PricelistFileTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            PricelistFileTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // PricelistFileQuery
