<?php

namespace Shop\Modules\AdminContractorsLite;

use ActiveTable\ColumnTable;
use ActiveTable\DataTableEngine;
use Shop\Domain\Customer\Contracts\CustomerEntityInterface;
use Shop\Modules\AdminContractors\AdminContractors;

/**
 * Description of AdminContractorsLite
 *
 * @author Diamond Code Generator
 */
class AdminContractorsLite extends AdminContractors
{

    /**
     * @param DataTableEngine $table
     */
    protected function prepareColumns(DataTableEngine $table): void
    {
        $table
            ->removeControlAccess(DataTableEngine::CONTROL_ROWS_ACTION)
            ->addColumn(
                (new ColumnTable('id', '№'))
                    ->setSorted(true)
                    ->setWidth(5, true)
            )
            ->addColumn(
                (new ColumnTable('name', 'ФИО'))->setWidth(15, true)
            )
            ->addColumn(
                (new ColumnTable('email', 'E-mail/Логин'))
                    ->setSorted(true)
                    ->setWidth(15, true)
            )
            ->addColumn(
                (new ColumnTable('phone', 'Телефон'))->setWidth(10, true)
            )
            ->addColumn(
                (new ColumnTable('address', 'Адрес'))
                    ->setFormat($this, 'formatAddress')
                    ->setWidth(25, true)
            )
            ->addColumn(
                (new ColumnTable('blocked', 'Заблокирован'))
                    ->setFormat($this, 'formatBlocked')
                    ->setWidth(5, true)
            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setWidth(15, true)
                    ->setFormat($this, 'formatSelect')
            );

    }

    /**
     * @param CustomerEntityInterface $customerEntity
     * @return string
     */
    public function formatSelect(CustomerEntityInterface $customerEntity): string
    {
        return '<button value="'.htmlspecialchars($customerEntity->getName()).'" 
onclick="selectValueInWindow(opener.document,\'contractorId\',\''.$customerEntity->getId().'\',this);" type="button" name="select" class="search-button stdbtn btn_red">Выбрать</button>';
    }

}               