<?php

namespace Shop\Repositories\Brand;

use Repo\Concrete\AbstractCriteria;
use Shop\Domain\Brand\Contracts\BrandCriteriaInterface;

/**
 * Description of ProductCriteria
 *
 * @author Admin
 */
class BrandCriteria extends AbstractCriteria implements BrandCriteriaInterface
{

    /**
     * @var string|null
     */
    protected $searchByName;

    /**
     * @var string|null
     */
    protected $filterByName;

    /**
     * @var string|null
     */
    protected $searchByAlias;

    /**
     * @var int|null
     */
    protected $filterByProductCategoryId;

    /**
     * @var string|null
     */
    protected $filterByAlias;

    /**
     * @var array|null
     */
    protected $filterByPriceListScheetIds;

    /**
     * @var array|null
     */
    protected $filterByWeights;

    /**
     * @var array|null
     */
    protected $filterByDestinations;

    /**
     * @var string|null
     */
    protected $sortByName;

    /**
     * @return string|null
     */
    public function getFilterByName(): ?string
    {
        return $this->filterByName;
    }

    /**
     * @param string|null $filterByName
     * @return BrandCriteria
     */
    public function setFilterByName(?string $filterByName): BrandCriteria
    {
        $this->filterByName = $filterByName;
        return $this;
    }

    /**
     * @return array|null
     */
    public function getFilterByDestinations(): ?array
    {
        return $this->filterByDestinations;
    }

    /**
     * @param array|null $filterByDestinations
     * @return BrandCriteria
     */
    public function setFilterByDestinations(?array $filterByDestinations): BrandCriteria
    {
        $this->filterByDestinations = $filterByDestinations;
        return $this;
    }


    /**
     * @return array|null
     */
    public function getFilterByWeights(): ?array
    {
        return $this->filterByWeights;
    }

    /**
     * @param array|null $filterByWeights
     * @return BrandCriteria
     */
    public function setFilterByWeights(?array $filterByWeights): BrandCriteria
    {
        $this->filterByWeights = $filterByWeights;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSortByName(): ?string
    {
        return $this->sortByName;
    }

    /**
     * @param string|null $sortByName
     * @return BrandCriteria
     */
    public function setSortByName(?string $sortByName): BrandCriteria
    {
        $this->sortByName = $sortByName;
        return $this;
    }


    /**
     * @return array|null
     */
    public function getFilterByPriceListScheetIds(): ?array
    {
        return $this->filterByPriceListScheetIds;
    }

    /**
     * @param array|null $filterByPriceListScheetIds
     * @return BrandCriteria
     */
    public function setFilterByPriceListScheetIds(?array $filterByPriceListScheetIds): BrandCriteria
    {
        $this->filterByPriceListScheetIds = $filterByPriceListScheetIds;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getFilterByAlias(): ?string
    {
        return $this->filterByAlias;
    }

    /**
     * @param string|null $filterByAlias
     * @return BrandCriteria
     */
    public function setFilterByAlias(?string $filterByAlias): BrandCriteria
    {
        $this->filterByAlias = $filterByAlias;
        return $this;
    }


    /**
     * @return int|null
     */
    public function getFilterByProductCategoryId(): ?int
    {
        return $this->filterByProductCategoryId;
    }

    /**
     * @param int|null $filterByProductCategoryInt
     * @return BrandCriteria
     */
    public function setFilterByProductCategoryId(?int $filterByProductCategoryInt): BrandCriteria
    {
        $this->filterByProductCategoryId = $filterByProductCategoryInt;
        return $this;
    }


    /**
     * @return mixed|BrandCriteria
     */
    public static function create()
    {
        return new self;
    }




    /**
     * @return string|null
     */
    public function getSearchByName(): ?string
    {
        return $this->searchByName;
    }

    /**
     * @param string|null $searchByName
     * @return BrandCriteria
     */
    public function setSearchByName(?string $searchByName): BrandCriteria
    {
        $this->searchByName = $searchByName;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSearchByAlias(): ?string
    {
        return $this->searchByAlias;
    }

    /**
     * @param string|null $searchByAlias
     * @return BrandCriteria
     */
    public function setSearchByAlias(?string $searchByAlias): BrandCriteria
    {
        $this->searchByAlias = $searchByAlias;
        return $this;
    }

}