<?php

namespace Shop\Domain\Stock\Contracts;

use Diamond\Domain\Site\Contracts\SiteFilterInterface;
use Repo\PaginationInterface;
use Repo\RepositoryCriteriaInterface;

/**
 * Description of Stock
 *
 * @author Diamond Code Generator
 */
interface StockCriteriaInterface extends RepositoryCriteriaInterface, PaginationInterface, SiteFilterInterface
{
    public function getFilterByContractorId(): ?int;

    public function getFilterByType(): ?string;

    public function getFilterByTypes(): ?array;

    public function getSortByTitle(): ?string;

    /**
     * @param int|null $domainId
     * @return mixed
     */
    public function setFilterBySiteId(?int $domainId): StockCriteriaInterface;

    /**
     * @return int|null
     */
    public function getFilterBySiteId(): ?int;

    /**
     * @return int|null
     */
    public function getFilterByCityId(): ?int;

    /**
     * @param int|null $id
     * @return mixed
     */
    public function setFilterByCityId(?int $id): StockCriteriaInterface;

    /**
     * @return bool|null
     */
    public function getFilterByActive(): ?bool;

    /**
     * @param bool|null $v
     * @return mixed
     */
    public function setFilterByActive(?bool $v): StockCriteriaInterface;

    /**
     * @param int|null $id
     * @return mixed
     */
    public function setFilterByParentId(?int $id): StockCriteriaInterface;

    /**
     * @return int|null
     */
    public function getFilterByParentId(): ?int;

    /**
     * @return int|null
     */
    public function getFilterByRegionId(): ?int;

    public function setFilterByRegionId(?int $filterByRegionId): StockCriteriaInterface;

    public function asTreeView(): bool;

    public function setFilterByTypes(?array $filterByTypes): StockCriteriaInterface;

    public function setSortByTitle(?string $sortByName): StockCriteriaInterface;

   public function setFilterByType(?string $filterByType): StockCriteriaInterface;

   public function setFilterByContractorId(?int $filterByContractorId): StockCriteriaInterface;
}           