<?php


namespace Shop\Repositories\Stock;

use Repo\Concrete\AbstractCriteria;
use Shop\Domain\Stock\Contracts\StockCriteriaInterface;

class StockCriteria extends AbstractCriteria implements StockCriteriaInterface
{

    public const TYPE_STOCK_MAIN = 'main';
    public const TYPE_STOCK_DEALER = 'dealer';
    public const TYPE_STOCK_STOCK = 'stock';

    /**
     * @var bool|null
     */
    protected $filterByActive;

    /**
     * @var int|null
     */
    protected $filterBySiteId;

    /**
     * @var bool
     */
    protected $treeView = false;

    /**
     * @var string|null
     */
    protected $sortByTitle;

    /**
     * @var int|null
     */
    protected $filterByContractorId;

    /**
     * @var string|null
     */
    protected $filterByType;

    /**
     * @var array|null
     */
    protected $filterByTypes;

    /**
     * @var int|null
     */
    protected $filterByCityId;

    /**
     * @var int|null
     */
    protected $filterByRegionId;

    /**
     * @var int|null
     */
    protected $filterByParentId;

    /**
     * @return int|null
     */
    public function getFilterByRegionId(): ?int
    {
        return $this->filterByRegionId;
    }

    /**
     * @param int|null $filterByRegionId
     * @return StockCriteria
     */
    public function setFilterByRegionId(?int $filterByRegionId): StockCriteriaInterface
    {
        $this->filterByRegionId = $filterByRegionId;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterByParentId(): ?int
    {
        return $this->filterByParentId;
    }

    /**
     * @param int|null $filterByParentId
     * @return StockCriteria
     */
    public function setFilterByParentId(?int $filterByParentId): StockCriteriaInterface
    {
        $this->filterByParentId = $filterByParentId;
        return $this;
    }


    /**
     * @return bool|null
     */
    public function getFilterByActive(): ?bool
    {
        return $this->filterByActive;
    }

    /**
     * @param bool|null $filterByActive
     * @return StockCriteria
     */
    public function setFilterByActive(?bool $filterByActive): StockCriteriaInterface
    {
        $this->filterByActive = $filterByActive;
        return $this;
    }



    public static function create()
    {
        return new self();
    }

    /**
     * @return int|null
     */
    public function getFilterByCityId(): ?int
    {
        return $this->filterByCityId;
    }

    /**
     * @param int|null $filterByCityId
     * @return StockCriteria
     */
    public function setFilterByCityId(?int $filterByCityId): StockCriteriaInterface
    {
        $this->filterByCityId = $filterByCityId;
        return $this;
    }


    /**
     * @return int|null
     */
    public function getFilterBySiteId(): ?int
    {
        return $this->filterBySiteId;
    }

    /**
     * @param int|null $filterBySiteId
     * @return StockCriteria
     */
    public function setFilterBySiteId(?int $filterBySiteId): StockCriteriaInterface
    {
        $this->filterBySiteId = $filterBySiteId;
        return $this;
    }



    /**
     * @return bool
     */
    public function asTreeView(): bool
    {
        return $this->treeView;
    }

    /**
     * @param bool $asTreeView
     * @return StockCriteria
     */
    public function setTreeView(bool $asTreeView): StockCriteriaInterface
    {
        $this->treeView = $asTreeView;
        return $this;
    }

    /**
     * @return array|null
     */
    public function getFilterByTypes(): ?array
    {
        return $this->filterByTypes;
    }

    /**
     * @param array|null $filterByTypes
     * @return StockCriteria
     */
    public function setFilterByTypes(?array $filterByTypes): StockCriteriaInterface
    {
        $this->filterByTypes = $filterByTypes;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getSortByTitle(): ?string
    {
        return $this->sortByTitle;
    }

    /**
     * @param string|null $sortByName
     * @return StockCriteria
     */
    public function setSortByTitle(?string $sortByName): StockCriteriaInterface
    {
        $this->sortByTitle = $sortByName;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getFilterByType(): ?string
    {
        return $this->filterByType;
    }

    /**
     * @param string|null $filterByType
     * @return StockCriteria
     */
    public function setFilterByType(?string $filterByType): StockCriteriaInterface
    {
        $this->filterByType = $filterByType;
        return $this;
    }


    /**
     * @return int|null
     */
    public function getFilterByContractorId(): ?int
    {
        return $this->filterByContractorId;
    }

    /**
     * @param int|null $filterByContractorId
     * @return StockCriteria
     */
    public function setFilterByContractorId(?int $filterByContractorId): StockCriteriaInterface
    {
        $this->filterByContractorId = $filterByContractorId;
        return $this;
    }

}