<?php

namespace Shop\Modules\OrdersChartWidget;


use Core\ModuleController;
use Core\Template\Template;

class OrdersChartWidget extends ModuleController
{
    protected $template;
    public $height = 300;
    public $id = 'chartplace';
    public $limit = 30;
    public $url = '/_service/shop/order/aggregate_sum_day';

    /**
     * ErrorsChart constructor.
     * @param Template $template
     */
    public function __construct(Template $template)
    {
        $this->template = $template;
    }

    /**
     * @return string
     * @throws \ReflectionException
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function process(): string
    {

        $this->template->addScriptLink('/_diamond/widgets/assets/jquery/flot/flot.min.js');
        $this->template->addScriptLink('/_diamond/widgets/assets/jquery/flot/flot.resize.min.js');


        $this->template->addScript($this->render('javascript',
            [
                'interval' => $this->limit,
                'url' => $this->url,
                'id' => $this->id,
                'minTickSize' => 'day'
            ]));

        return $this->render([
            'height' => $this->height,
            'id' => $this->id
        ]);
    }


}