<?php


namespace Shop\UseCases\Checkout;


use Diamond\UseCases\Notification\NotificationException;
use ExportEngine\Exporter;
use Propel\Runtime\Map\TableMap;
use Shop\Application\Shopping\ShoppingService;
use Shop\Config\Main;
use Shop\Domain\CustomerOrder\Contracts\CustomerOrderEntityInterface;
use Shop\Domain\CustomerOrder\CustomerOrderCollection;
use Shop\Domain\OrderItem\Contracts\OrderItemEntityInterface;
use Shop\Domain\ProviderOrder\Contracts\ProviderOrderEntityInterface;
use Shop\Domain\ProviderOrder\ProviderOrderCollection;
use Shop\Domain\State\Contracts\StateEntityInterface;
use Shop\Models\Currency\Currency;
use Shop\Models\Order\Order;
use Shop\Models\OrderItem\OrderItem;
use Shop\Models\OrderType\OrderType;
use Shop\Models\ProviderOrderItem\ProviderOrderItem;
use Shop\Models\State\State;
use Shop\Models\StateLog\StateLog;
use Shop\Repositories\CustomerOrder\CustomerOrderCriteria;
use Shop\Repositories\CustomerOrder\CustomerOrderRepository;
use Shop\Repositories\OrderItem\OrderItemCriteria;
use Shop\Repositories\OrderItem\OrderItemRepository;
use Shop\Repositories\ProviderOrder\ProviderOrderRepository;
use Shop\Repositories\ProviderOrderItem\ProviderOrderItemCriteria;
use Shop\Repositories\ProviderOrderItem\ProviderOrderItemRepository;
use Shop\Repositories\State\StateRepository;
use Shop\Repositories\StateLog\StateLogRepository;
use Shop\Repositories\Stock\StockRepository;
use Shop\UseCases\Checkout\Exceptions\CheckoutException;
use Shop\UseCases\Checkout\Exceptions\CreateProviderOrdersException;
use Shop\UseCases\Checkout\Exceptions\MergeCountOrdersException;
use Shop\UseCases\Checkout\Exceptions\MergeOrdersFoundSomeContractorsException;
use Shop\UseCases\Checkout\Exceptions\MergeOrdersFoundSomeCustomerException;
use Shop\UseCases\Checkout\Exceptions\SendCustomerOrdersException;
use Shop\UseCases\Checkout\Exceptions\SendProviderOrdersException;
use Shop\UseCases\Imaging\Imaging;
use Shop\UseCases\Notification\Notification;

/**
 * @deprecated
 * Class Checkout
 * @package Shop\UseCases\Checkout
 */
class Checkout extends ShoppingService
{
//    protected $stateRepository;
//    protected $itemRepository;
//    protected $stateLogRepository;
//    protected $providerOrderRepository;
//    protected $mainConf;
//    protected $customerOrderRepository;
//    protected $notificationUseCase;
//    protected $stockRepository;
//    protected $imagingUseCase;
//    protected $providerOrderItemRepository;
//
//    /**
//     * Checkout constructor.
//     * @param StateRepository $stateRepository
//     * @param OrderItemRepository $itemRepository
//     * @param ProviderOrderItemRepository $providerOrderItemRepository
//     * @param StateLogRepository $stateLogRepository
//     * @param ProviderOrderRepository $providerOrderRepository
//     * @param CustomerOrderRepository $customerOrderRepository
//     * @param Main $mainConf
//     * @param Notification $notification
//     * @param StockRepository $stockRepository
//     * @param Imaging $imagingUseCase
//     */
//    public function __construct(StateRepository $stateRepository,
//                                OrderItemRepository $itemRepository,
//                                ProviderOrderItemRepository $providerOrderItemRepository,
//                                StateLogRepository $stateLogRepository,
//                                ProviderOrderRepository $providerOrderRepository,
//                                CustomerOrderRepository $customerOrderRepository,
//                                Main $mainConf,
//                                Notification $notification,
//                                StockRepository $stockRepository,
//                                Imaging $imagingUseCase
//    )
//    {
//        $this->stateRepository = $stateRepository;
//        $this->itemRepository = $itemRepository;
//        $this->stateLogRepository = $stateLogRepository;
//        $this->providerOrderRepository = $providerOrderRepository;
//        $this->mainConf = $mainConf;
//        $this->customerOrderRepository = $customerOrderRepository;
//        $this->notificationUseCase = $notification;
//        $this->stockRepository = $stockRepository;
//        $this->imagingUseCase = $imagingUseCase;
//        $this->providerOrderItemRepository = $providerOrderItemRepository;
//    }
//
//
//
//    /**
//     * @deprecated
//     * Создание заказа поставщику от торговой точки
//     * @param OrderRequest $orderRequest
//     * @return ProviderOrderEntityInterface
//     * @throws \Propel\Runtime\Exception\PropelException
//     */
//    public function createProviderOrder(OrderRequest $orderRequest): ProviderOrderEntityInterface
//    {
//
//    }
//
//    /**
//     * @deprecated
//     * @param OrderItemRequest $item
//     * @return OrderItemEntityInterface|OrderItem
//     */
//    protected function buildOrderItem(OrderItemRequest $item): OrderItemEntityInterface
//    {
//
//    }
//
//    /**
//     * @deprecated
//     * Создание заказа клиента к торговой точке
//     * @param OrderRequest $orderRequest
//     * @return CustomerOrderEntityInterface
//     */
//    public function createCustomerOrder(OrderRequest $orderRequest): CustomerOrderEntityInterface
//    {
//
//    }
//
//    /**
//     * @deprecated
//     * @param array $ids
//     * @return ProviderOrderCollection
//     * @throws \Propel\Runtime\Exception\PropelException
//     * @throws \Repo\Concrete\Exceptions\Collection
//     * @throws \Throwable
//     * @throws \Twig\Error\LoaderError
//     * @throws \Twig\Error\RuntimeError
//     * @throws \Twig\Error\SyntaxError
//     */
//    public function sendProviderOrdersByIds(array $ids): ProviderOrderCollection
//    {
//
//    }
//
//    /**
//     * @deprecated
//     * @param ProviderOrderEntityInterface $order
//     * @return array
//     */
//    public function prepareProviderOrderDataForReport(ProviderOrderEntityInterface $order): array
//    {
//
//    }
//
//    /**
//     * @deprecated
//     * Отправка уведомление о заказе клиентам заказов
//     * @param array $ids
//     * @param bool $notifyCustomer
//     * @param bool $notifyManager
//     * @return CustomerOrderCollection
//     * @throws \Propel\Runtime\Exception\PropelException
//     * @throws \Repo\Concrete\Exceptions\Collection
//     * @throws \Twig\Error\LoaderError
//     * @throws \Twig\Error\RuntimeError
//     * @throws \Twig\Error\SyntaxError
//     */
//    public function sendCustomerOrdersByIds(array $ids, $notifyCustomer = true, $notifyManager = true): CustomerOrderCollection
//    {
//
//    }
//
//    /**
//     * @deprecated
//     * Подгтовка данных для отчета по заказу
//     * @param CustomerOrderEntityInterface $order
//     * @return array
//     */
//    public function prepareCustomerOrderDataForReport(CustomerOrderEntityInterface $order): array
//    {
//
//    }
//
//    /**
//     * @deprecated
//     * @param array $items
//     * @return string
//     */
//    public function createFileFromOrderItems(array $items, string $fileName):string{
//
//
//
//        return $link;
//    }
}