<?php

namespace Shop\Modules\AdminCities;

use ActiveTable\ColumnTable;
use Core\Form\ControlBuilder;
use Diamond\Helpers\Form;
use DiamondTable\TableFactory;
use Shop\Repositories\City\CityCriteria;
use Shop\Repositories\City\CityRepository;
use Shop\Repositories\Country\CountryCriteria;
use Shop\Repositories\Country\CountryRepository;
use Shop\Repositories\Region\RegionCriteria;
use Shop\Repositories\Region\RegionRepository;

/**
 * Description of AdminCities
 *
 * @author Diamond Code Generator
 */
class AdminCities extends \Core\ModuleController
{

    protected $cityRepository;
    protected $regionRepository;
    protected $controlBuilder;
    protected $tableFactory;
    protected $countryRepository;

    /**
     * AdminCities constructor.
     * @param RegionRepository $regionRepository
     * @param TableFactory $tableFactory
     * @param ControlBuilder $controlBuilder
     * @param CityRepository $cityRepository
     * @param CountryRepository $countryRepository
     */
    public function __construct(RegionRepository $regionRepository, TableFactory $tableFactory, ControlBuilder $controlBuilder,
                                CityRepository $cityRepository,CountryRepository $countryRepository)
    {
        $this->regionRepository = $regionRepository;
        $this->tableFactory = $tableFactory;
        $this->controlBuilder = $controlBuilder;
        $this->cityRepository = $cityRepository;
        $this->countryRepository = $countryRepository;
    }

    public function process(): string
    {
        $table = $this->tableFactory->buildAdminTable(
            $this->cityRepository,
            CityCriteria::create()
        );
        $regions = $this->regionRepository->findByCriteria(
            RegionCriteria::create()
        );
        $countries = $this->countryRepository->findByCriteria(
            CountryCriteria::create()
        );
        $table
            ->addColumn(
                (new ColumnTable('id', '№'))
                    ->setSorted(true)
                    ->setWidth(40)
            )
            ->addColumn(
                (new ColumnTable('name', 'Название'))
                    ->setSorted(true)

            )
            ->addColumn(
                (new ColumnTable('regionId', 'Регион'))
                    ->setFormat($this, 'formatRegion')

            )
            ->addColumn(
                (new ColumnTable('countryId', 'Страна'))
                    ->setFormat($this, 'formatCountry')

            )
            ->addColumn(
                (new ColumnTable('actions', ''))
                    ->setFormat($this->tableFactory, 'formatActions')
                    ->setWidth(120)
            )
        ;
        $table
            ->addField(
                $this->controlBuilder->buildInput('name'), true
            )
            ->addField(
                $this->controlBuilder->buildAutoDropdown('regionId',Form::prepareDropdown($regions)), true
            );

        $table
            ->addFilter(
                $this->controlBuilder->buildInput('search_by_name')
            )
            ->addFilter(
                $this->controlBuilder->buildDropdownUniform('filter_by_regionId',Form::prepareDropdown($regions))
            )
            ->addFilter(
                $this->controlBuilder->buildDropdownUniform('filter_by_countryId',Form::prepareDropdown($countries))
            )
            ;

        return $table->render();

    }

    /**
     *
     * @param \Shop\Models\City\City $city
     * @return type
     */
    public function formatCountry(\Shop\Models\City\City $city)
    {
        return $city->getCityRegion()->getRegionCountry()->getName();
    }

    /**
     *
     * @param \Shop\Models\Region\Region $region
     * @return type
     */
    public function formatRegion(\Shop\Models\City\City $city)
    {
        return $city->getCityRegion()->getName();
    }
}