<?php


namespace Shop\Repositories\CustomerOrder;


use Repo\Concrete\AbstractCriteria;
use Shop\Domain\CustomerOrder\Contracts\CustomerOrderCriteriaInterface;

class CustomerOrderCriteria extends AbstractCriteria implements CustomerOrderCriteriaInterface
{

    /**
     * @var int|null
     */
    protected $filterByStockId;

    /**
     * @var array|null
     */
    protected $filterByStockIds;

    /**
     * @var string|null
     */
    protected $filterByOrderCode;

    /**
     * @var string|null
     */
    protected $sortById;

    /**
     * @var int|null
     */
    protected $filterByStateId;

    /**
     * @var int|null
     */
    protected $filterByCustomerId;

    public static function create()
    {
        return new self();
    }

    /**
     * @return int|null
     */
    public function getFilterByCustomerId(): ?int
    {
        return $this->filterByCustomerId;
    }

    /**
     * @param int|null $filterByCustomerId
     * @return CustomerOrderCriteria
     */
    public function setFilterByCustomerId(?int $filterByCustomerId): CustomerOrderCriteria
    {
        $this->filterByCustomerId = $filterByCustomerId;
        return $this;
    }


    /**
     * @return array|null
     */
    public function getFilterByStockIds(): ?array
    {
        return $this->filterByStockIds;
    }

    /**
     * @param array|null $filterByStockIds
     * @return CustomerOrderCriteria
     */
    public function setFilterByStockIds(?array $filterByStockIds): CustomerOrderCriteria
    {
        $this->filterByStockIds = $filterByStockIds;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getFilterByOrderCode(): ?string
    {
        return $this->filterByOrderCode;
    }

    /**
     * @param string|null $filterByOrderCode
     * @return CustomerOrderCriteria
     */
    public function setFilterByOrderCode(?string $filterByOrderCode): CustomerOrderCriteria
    {
        $this->filterByOrderCode = $filterByOrderCode;
        return $this;
    }


    /**
     * @return string|null
     */
    public function getSortById(): ?string
    {
        return $this->sortById;
    }

    /**
     * @param string|null $sortById
     * @return CustomerOrderCriteria
     */
    public function setSortById(?string $sortById): AbstractCriteria
    {
        $this->sortById = $sortById;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterByStateId(): ?int
    {
        return $this->filterByStateId;
    }

    /**
     * @param int|null $filterByStateId
     * @return CustomerOrderCriteria
     */
    public function setFilterByStateId(?int $filterByStateId): CustomerOrderCriteria
    {
        $this->filterByStateId = $filterByStateId;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getFilterByStockId(): ?int
    {
        return $this->filterByStockId;
    }

    /**
     * @param int|null $filterByStockId
     * @return CustomerOrderCriteria
     */
    public function setFilterByStockId(?int $filterByStockId): CustomerOrderCriteria
    {
        $this->filterByStockId = $filterByStockId;
        return $this;
    }

}