<?php


namespace Shop\Application\Shopping\PrepareCustomerOrderDataForReport;


use Shop\Domain\CustomerOrder\Contracts\CustomerOrderEntityInterface;

class PrepareCustomerOrderDataForReportCommand
{
    protected $order;
    protected $result;

    /**
     * PrepareCustomerOrderDataForReportCommand constructor.
     * @param CustomerOrderEntityInterface $order
     * @param ResultData $result
     */
    public function __construct(CustomerOrderEntityInterface $order, ResultData $result)
    {
        $this->result = $result;
        $this->order = $order;
    }

    /**
     * @return CustomerOrderEntityInterface
     */
    public function getOrder(): CustomerOrderEntityInterface
    {
        return $this->order;
    }

    /**
     * @return ResultData
     */
    public function getResult(): ResultData
    {
        return $this->result;
    }




}