<?php


namespace Shop\Modules\AdminProducts;


use Core\Form\ControlBuilder;
use Core\Form\FormBuilder;
use Core\Form\Simpleform;
use Diamond\Helpers\Form;
use Shop\Repositories\Product\ProductCriteria;
use Shop\Repositories\Product\ProductRepository;

trait FormTrait
{
    /**
     * @var FormBuilder
     */
    protected $formBuilder;

    /**
     * @var ControlBuilder
     */
    protected $controlBuilder;

    /**
     * @var ProductRepository
     */
    protected $productRepository;

    /**
     * @param array $brandsAr
     * @return Simpleform
     * @throws \ReflectionException
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function buildMoveBrandForm(array $brandsAr): Simpleform
    {
        $form = $this->formBuilder->buildSimpleValidationForm('move-brands');

        $form
            ->addField(
                $this->controlBuilder->buildAutoDropdown('new_brand', $brandsAr), 'Новый производитель', ['required']
            )
            ->addField(
                $this->controlBuilder->buildHidden('ids', input_post('ids'))
            )
            ->addField(
                $this->controlBuilder->buildHidden('actiontype', input_post('actiontype'))
            )
            ->addControl(
                $this->controlBuilder->buildSubmitButton('submit_change_brand', 'Сменить производителя')
            );

        return $form;
    }

    /**
     * @return Simpleform
     */
    public function buildMergerProductsForm(): Simpleform
    {
        $form = $this->formBuilder->buildSimpleValidationForm('merge-products');

        $ids = Form::getIdsFromRequest();

        if(!$ids){
            return $form;
        }

        $products = $this->productRepository->findByCriteria(
          ProductCriteria::create()->setFilterByIds($ids)
        );


        $form
            ->addField(
                $this->controlBuilder->buildAutoDropdown('new_product', $products->getDropdownListFull()), 'Объеденить с товаром', ['required']
            )
            ->addField(
                $this->controlBuilder->buildHidden('ids', input_post('ids'))
            )
            ->addField(
                $this->controlBuilder->buildHidden('actiontype', input_post('actiontype'))
            )
            ->addControl(
                $this->controlBuilder->buildSubmitButton('submit_merge_order', 'Объеденить')
            );

        return $form;
    }

    /**
     * @param array $brandsAr
     * @return Simpleform
     * @throws \ReflectionException
     * @throws \Twig\Error\LoaderError
     * @throws \Twig\Error\RuntimeError
     * @throws \Twig\Error\SyntaxError
     */
    public function buildMoveCategoryForm(array $brandsAr): Simpleform
    {
        $form = $this->formBuilder->buildSimpleValidationForm('move-category');

        $form
            ->addField(
                $this->controlBuilder->buildAutoDropdown('new_category', $brandsAr),
                'Новый раздел каталога',
                ['required']
            )
            ->addField(
                $this->controlBuilder->buildHidden('ids', input_post('ids'))
            )
            ->addField(
                $this->controlBuilder->buildHidden('actiontype', input_post('actiontype'))
            )
            ->addControl(
                $this->controlBuilder->buildSubmitButton('submit_change_brand', 'Сменить раздел')
            )
            ->addControl($this->controlBuilder->buildCancel('cancel',
                'Отмена'
            ));

        return $form;
    }

}