<?php


namespace Shop\Application\Basket\Decorators;

use Shop\Domain\Basket\BasketItem;
use Shop\Domain\Basket\Contracts\BasketEntityInterface;

class Basket implements BasketEntityInterface
{
    protected $basket;
    protected $basketDriver;
    protected $basketRepository;

    /**
     * Basket constructor.
     * @param BasketEntityInterface $basket
     * @param \Core\Basket\Basket $basketDriver
     */
    public function __construct(BasketEntityInterface $basket,
                                \Core\Basket\Basket $basketDriver)
    {
        $this->basket = $basket;
        $this->basketDriver = $basketDriver;
    }

    public function getItems(): array
    {
        return $this->basket->getItems();
    }

    public function getCount(): int
    {
        return $this->basket->getCount();
    }

    public function getSum(): float
    {
        return $this->basket->getSum();
    }

    public function itemExistByRef(string $ref): int
    {
        return $this->basket->itemExistByRef($ref);
    }

    public function clear(): void
    {
        $this->basketDriver->clear();
    }

    public function getId()
    {
        return $this->basket->getId();
    }


    public function addItem(BasketItem $item): void
    {
        $this->basket->addItem($item);
    }

}