<?php

namespace Shop\Models\PricelistSheet\Base;

use \Exception;
use \PDO;
use MoySklad\Models\MoySkladTask\MoySkladTask;
use Propel\Runtime\Propel;
use Propel\Runtime\ActiveQuery\Criteria;
use Propel\Runtime\ActiveQuery\ModelCriteria;
use Propel\Runtime\ActiveQuery\ModelJoin;
use Propel\Runtime\Collection\ObjectCollection;
use Propel\Runtime\Connection\ConnectionInterface;
use Propel\Runtime\Exception\PropelException;
use Shop\Models\Currency\Currency;
use Shop\Models\Position\Position;
use Shop\Models\PricelistFile\PricelistFile;
use Shop\Models\PricelistSheet\PricelistSheet as ChildPricelistSheet;
use Shop\Models\PricelistSheet\PricelistSheetQuery as ChildPricelistSheetQuery;
use Shop\Models\PricelistSheet\Map\PricelistSheetTableMap;

/**
 * Base class that represents a query for the 'shop_pricelist_sheets' table.
 *
 *
 *
 * @method     ChildPricelistSheetQuery orderById($order = Criteria::ASC) Order by the id column
 * @method     ChildPricelistSheetQuery orderByTitle($order = Criteria::ASC) Order by the title column
 * @method     ChildPricelistSheetQuery orderByDateUpdate($order = Criteria::ASC) Order by the date_update column
 * @method     ChildPricelistSheetQuery orderByPricelistFileId($order = Criteria::ASC) Order by the pricelist_file_id column
 * @method     ChildPricelistSheetQuery orderByCurrencyId($order = Criteria::ASC) Order by the crrency_id column
 *
 * @method     ChildPricelistSheetQuery groupById() Group by the id column
 * @method     ChildPricelistSheetQuery groupByTitle() Group by the title column
 * @method     ChildPricelistSheetQuery groupByDateUpdate() Group by the date_update column
 * @method     ChildPricelistSheetQuery groupByPricelistFileId() Group by the pricelist_file_id column
 * @method     ChildPricelistSheetQuery groupByCurrencyId() Group by the crrency_id column
 *
 * @method     ChildPricelistSheetQuery leftJoin($relation) Adds a LEFT JOIN clause to the query
 * @method     ChildPricelistSheetQuery rightJoin($relation) Adds a RIGHT JOIN clause to the query
 * @method     ChildPricelistSheetQuery innerJoin($relation) Adds a INNER JOIN clause to the query
 *
 * @method     ChildPricelistSheetQuery leftJoinWith($relation) Adds a LEFT JOIN clause and with to the query
 * @method     ChildPricelistSheetQuery rightJoinWith($relation) Adds a RIGHT JOIN clause and with to the query
 * @method     ChildPricelistSheetQuery innerJoinWith($relation) Adds a INNER JOIN clause and with to the query
 *
 * @method     ChildPricelistSheetQuery leftJoinPricelistFile($relationAlias = null) Adds a LEFT JOIN clause to the query using the PricelistFile relation
 * @method     ChildPricelistSheetQuery rightJoinPricelistFile($relationAlias = null) Adds a RIGHT JOIN clause to the query using the PricelistFile relation
 * @method     ChildPricelistSheetQuery innerJoinPricelistFile($relationAlias = null) Adds a INNER JOIN clause to the query using the PricelistFile relation
 *
 * @method     ChildPricelistSheetQuery joinWithPricelistFile($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the PricelistFile relation
 *
 * @method     ChildPricelistSheetQuery leftJoinWithPricelistFile() Adds a LEFT JOIN clause and with to the query using the PricelistFile relation
 * @method     ChildPricelistSheetQuery rightJoinWithPricelistFile() Adds a RIGHT JOIN clause and with to the query using the PricelistFile relation
 * @method     ChildPricelistSheetQuery innerJoinWithPricelistFile() Adds a INNER JOIN clause and with to the query using the PricelistFile relation
 *
 * @method     ChildPricelistSheetQuery leftJoinCurrency($relationAlias = null) Adds a LEFT JOIN clause to the query using the Currency relation
 * @method     ChildPricelistSheetQuery rightJoinCurrency($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Currency relation
 * @method     ChildPricelistSheetQuery innerJoinCurrency($relationAlias = null) Adds a INNER JOIN clause to the query using the Currency relation
 *
 * @method     ChildPricelistSheetQuery joinWithCurrency($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Currency relation
 *
 * @method     ChildPricelistSheetQuery leftJoinWithCurrency() Adds a LEFT JOIN clause and with to the query using the Currency relation
 * @method     ChildPricelistSheetQuery rightJoinWithCurrency() Adds a RIGHT JOIN clause and with to the query using the Currency relation
 * @method     ChildPricelistSheetQuery innerJoinWithCurrency() Adds a INNER JOIN clause and with to the query using the Currency relation
 *
 * @method     ChildPricelistSheetQuery leftJoinMoySkladTask($relationAlias = null) Adds a LEFT JOIN clause to the query using the MoySkladTask relation
 * @method     ChildPricelistSheetQuery rightJoinMoySkladTask($relationAlias = null) Adds a RIGHT JOIN clause to the query using the MoySkladTask relation
 * @method     ChildPricelistSheetQuery innerJoinMoySkladTask($relationAlias = null) Adds a INNER JOIN clause to the query using the MoySkladTask relation
 *
 * @method     ChildPricelistSheetQuery joinWithMoySkladTask($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the MoySkladTask relation
 *
 * @method     ChildPricelistSheetQuery leftJoinWithMoySkladTask() Adds a LEFT JOIN clause and with to the query using the MoySkladTask relation
 * @method     ChildPricelistSheetQuery rightJoinWithMoySkladTask() Adds a RIGHT JOIN clause and with to the query using the MoySkladTask relation
 * @method     ChildPricelistSheetQuery innerJoinWithMoySkladTask() Adds a INNER JOIN clause and with to the query using the MoySkladTask relation
 *
 * @method     ChildPricelistSheetQuery leftJoinPosition($relationAlias = null) Adds a LEFT JOIN clause to the query using the Position relation
 * @method     ChildPricelistSheetQuery rightJoinPosition($relationAlias = null) Adds a RIGHT JOIN clause to the query using the Position relation
 * @method     ChildPricelistSheetQuery innerJoinPosition($relationAlias = null) Adds a INNER JOIN clause to the query using the Position relation
 *
 * @method     ChildPricelistSheetQuery joinWithPosition($joinType = Criteria::INNER_JOIN) Adds a join clause and with to the query using the Position relation
 *
 * @method     ChildPricelistSheetQuery leftJoinWithPosition() Adds a LEFT JOIN clause and with to the query using the Position relation
 * @method     ChildPricelistSheetQuery rightJoinWithPosition() Adds a RIGHT JOIN clause and with to the query using the Position relation
 * @method     ChildPricelistSheetQuery innerJoinWithPosition() Adds a INNER JOIN clause and with to the query using the Position relation
 *
 * @method     \Shop\Models\PricelistFile\PricelistFileQuery|\Shop\Models\Currency\CurrencyQuery|\MoySklad\Models\MoySkladTask\MoySkladTaskQuery|\Shop\Models\Position\PositionQuery endUse() Finalizes a secondary criteria and merges it with its primary Criteria
 *
 * @method     ChildPricelistSheet findOne(ConnectionInterface $con = null) Return the first ChildPricelistSheet matching the query
 * @method     ChildPricelistSheet findOneOrCreate(ConnectionInterface $con = null) Return the first ChildPricelistSheet matching the query, or a new ChildPricelistSheet object populated from the query conditions when no match is found
 *
 * @method     ChildPricelistSheet findOneById(int $id) Return the first ChildPricelistSheet filtered by the id column
 * @method     ChildPricelistSheet findOneByTitle(string $title) Return the first ChildPricelistSheet filtered by the title column
 * @method     ChildPricelistSheet findOneByDateUpdate(string $date_update) Return the first ChildPricelistSheet filtered by the date_update column
 * @method     ChildPricelistSheet findOneByPricelistFileId(int $pricelist_file_id) Return the first ChildPricelistSheet filtered by the pricelist_file_id column
 * @method     ChildPricelistSheet findOneByCurrencyId(int $crrency_id) Return the first ChildPricelistSheet filtered by the crrency_id column *

 * @method     ChildPricelistSheet requirePk($key, ConnectionInterface $con = null) Return the ChildPricelistSheet by primary key and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPricelistSheet requireOne(ConnectionInterface $con = null) Return the first ChildPricelistSheet matching the query and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildPricelistSheet requireOneById(int $id) Return the first ChildPricelistSheet filtered by the id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPricelistSheet requireOneByTitle(string $title) Return the first ChildPricelistSheet filtered by the title column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPricelistSheet requireOneByDateUpdate(string $date_update) Return the first ChildPricelistSheet filtered by the date_update column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPricelistSheet requireOneByPricelistFileId(int $pricelist_file_id) Return the first ChildPricelistSheet filtered by the pricelist_file_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 * @method     ChildPricelistSheet requireOneByCurrencyId(int $crrency_id) Return the first ChildPricelistSheet filtered by the crrency_id column and throws \Propel\Runtime\Exception\EntityNotFoundException when not found
 *
 * @method     ChildPricelistSheet[]|ObjectCollection find(ConnectionInterface $con = null) Return ChildPricelistSheet objects based on current ModelCriteria
 * @method     ChildPricelistSheet[]|ObjectCollection findById(int $id) Return ChildPricelistSheet objects filtered by the id column
 * @method     ChildPricelistSheet[]|ObjectCollection findByTitle(string $title) Return ChildPricelistSheet objects filtered by the title column
 * @method     ChildPricelistSheet[]|ObjectCollection findByDateUpdate(string $date_update) Return ChildPricelistSheet objects filtered by the date_update column
 * @method     ChildPricelistSheet[]|ObjectCollection findByPricelistFileId(int $pricelist_file_id) Return ChildPricelistSheet objects filtered by the pricelist_file_id column
 * @method     ChildPricelistSheet[]|ObjectCollection findByCurrencyId(int $crrency_id) Return ChildPricelistSheet objects filtered by the crrency_id column
 * @method     ChildPricelistSheet[]|\Propel\Runtime\Util\PropelModelPager paginate($page = 1, $maxPerPage = 10, ConnectionInterface $con = null) Issue a SELECT query based on the current ModelCriteria and uses a page and a maximum number of results per page to compute an offset and a limit
 *
 */
abstract class PricelistSheetQuery extends ModelCriteria
{
    protected $entityNotFoundExceptionClass = '\\Propel\\Runtime\\Exception\\EntityNotFoundException';

    /**
     * Initializes internal state of \Shop\Models\PricelistSheet\Base\PricelistSheetQuery object.
     *
     * @param     string $dbName The database name
     * @param     string $modelName The phpName of a model, e.g. 'Book'
     * @param     string $modelAlias The alias for the model in this query, e.g. 'b'
     */
    public function __construct($dbName = 'default', $modelName = '\\Shop\\Models\\PricelistSheet\\PricelistSheet', $modelAlias = null)
    {
        parent::__construct($dbName, $modelName, $modelAlias);
    }

    /**
     * Returns a new ChildPricelistSheetQuery object.
     *
     * @param     string $modelAlias The alias of a model in the query
     * @param     Criteria $criteria Optional Criteria to build the query from
     *
     * @return ChildPricelistSheetQuery
     */
    public static function create($modelAlias = null, Criteria $criteria = null)
    {
        if ($criteria instanceof ChildPricelistSheetQuery) {
            return $criteria;
        }
        $query = new ChildPricelistSheetQuery();
        if (null !== $modelAlias) {
            $query->setModelAlias($modelAlias);
        }
        if ($criteria instanceof Criteria) {
            $query->mergeWith($criteria);
        }

        return $query;
    }

    /**
     * Find object by primary key.
     * Propel uses the instance pool to skip the database if the object exists.
     * Go fast if the query is untouched.
     *
     * <code>
     * $obj  = $c->findPk(12, $con);
     * </code>
     *
     * @param mixed $key Primary key to use for the query
     * @param ConnectionInterface $con an optional connection object
     *
     * @return ChildPricelistSheet|array|mixed the result, formatted by the current formatter
     */
    public function findPk($key, ConnectionInterface $con = null)
    {
        if ($key === null) {
            return null;
        }

        if ($con === null) {
            $con = Propel::getServiceContainer()->getReadConnection(PricelistSheetTableMap::DATABASE_NAME);
        }

        $this->basePreSelect($con);

        if (
            $this->formatter || $this->modelAlias || $this->with || $this->select
            || $this->selectColumns || $this->asColumns || $this->selectModifiers
            || $this->map || $this->having || $this->joins
        ) {
            return $this->findPkComplex($key, $con);
        }

        if ((null !== ($obj = PricelistSheetTableMap::getInstanceFromPool(null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key)))) {
            // the object is already in the instance pool
            return $obj;
        }

        return $this->findPkSimple($key, $con);
    }

    /**
     * Find object by primary key using raw SQL to go fast.
     * Bypass doSelect() and the object formatter by using generated code.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildPricelistSheet A model object, or null if the key is not found
     */
    protected function findPkSimple($key, ConnectionInterface $con)
    {
        $sql = 'SELECT `id`, `title`, `date_update`, `pricelist_file_id`, `crrency_id` FROM `shop_pricelist_sheets` WHERE `id` = :p0';
        try {
            $stmt = $con->prepare($sql);
            $stmt->bindValue(':p0', $key, PDO::PARAM_INT);
            $stmt->execute();
        } catch (Exception $e) {
            Propel::log($e->getMessage(), Propel::LOG_ERR);
            throw new PropelException(sprintf('Unable to execute SELECT statement [%s]', $sql), 0, $e);
        }
        $obj = null;
        if ($row = $stmt->fetch(\PDO::FETCH_NUM)) {
            /** @var ChildPricelistSheet $obj */
            $obj = new ChildPricelistSheet();
            $obj->hydrate($row);
            PricelistSheetTableMap::addInstanceToPool($obj, null === $key || is_scalar($key) || is_callable([$key, '__toString']) ? (string) $key : $key);
        }
        $stmt->closeCursor();

        return $obj;
    }

    /**
     * Find object by primary key.
     *
     * @param     mixed $key Primary key to use for the query
     * @param     ConnectionInterface $con A connection object
     *
     * @return ChildPricelistSheet|array|mixed the result, formatted by the current formatter
     */
    protected function findPkComplex($key, ConnectionInterface $con)
    {
        // As the query uses a PK condition, no limit(1) is necessary.
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKey($key)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->formatOne($dataFetcher);
    }

    /**
     * Find objects by primary key
     * <code>
     * $objs = $c->findPks(array(12, 56, 832), $con);
     * </code>
     * @param     array $keys Primary keys to use for the query
     * @param     ConnectionInterface $con an optional connection object
     *
     * @return ObjectCollection|array|mixed the list of results, formatted by the current formatter
     */
    public function findPks($keys, ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getReadConnection($this->getDbName());
        }
        $this->basePreSelect($con);
        $criteria = $this->isKeepQuery() ? clone $this : $this;
        $dataFetcher = $criteria
            ->filterByPrimaryKeys($keys)
            ->doSelect($con);

        return $criteria->getFormatter()->init($criteria)->format($dataFetcher);
    }

    /**
     * Filter the query by primary key
     *
     * @param     mixed $key Primary key to use for the query
     *
     * @return $this|ChildPricelistSheetQuery The current query, for fluid interface
     */
    public function filterByPrimaryKey($key)
    {

        return $this->addUsingAlias(PricelistSheetTableMap::COL_ID, $key, Criteria::EQUAL);
    }

    /**
     * Filter the query by a list of primary keys
     *
     * @param     array $keys The list of primary key to use for the query
     *
     * @return $this|ChildPricelistSheetQuery The current query, for fluid interface
     */
    public function filterByPrimaryKeys($keys)
    {

        return $this->addUsingAlias(PricelistSheetTableMap::COL_ID, $keys, Criteria::IN);
    }

    /**
     * Filter the query on the id column
     *
     * Example usage:
     * <code>
     * $query->filterById(1234); // WHERE id = 1234
     * $query->filterById(array(12, 34)); // WHERE id IN (12, 34)
     * $query->filterById(array('min' => 12)); // WHERE id > 12
     * </code>
     *
     * @param     mixed $id The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPricelistSheetQuery The current query, for fluid interface
     */
    public function filterById($id = null, $comparison = null)
    {
        if (is_array($id)) {
            $useMinMax = false;
            if (isset($id['min'])) {
                $this->addUsingAlias(PricelistSheetTableMap::COL_ID, $id['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($id['max'])) {
                $this->addUsingAlias(PricelistSheetTableMap::COL_ID, $id['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PricelistSheetTableMap::COL_ID, $id, $comparison);
    }

    /**
     * Filter the query on the title column
     *
     * Example usage:
     * <code>
     * $query->filterByTitle('fooValue');   // WHERE title = 'fooValue'
     * $query->filterByTitle('%fooValue%', Criteria::LIKE); // WHERE title LIKE '%fooValue%'
     * </code>
     *
     * @param     string $title The value to use as filter.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPricelistSheetQuery The current query, for fluid interface
     */
    public function filterByTitle($title = null, $comparison = null)
    {
        if (null === $comparison) {
            if (is_array($title)) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PricelistSheetTableMap::COL_TITLE, $title, $comparison);
    }

    /**
     * Filter the query on the date_update column
     *
     * Example usage:
     * <code>
     * $query->filterByDateUpdate('2011-03-14'); // WHERE date_update = '2011-03-14'
     * $query->filterByDateUpdate('now'); // WHERE date_update = '2011-03-14'
     * $query->filterByDateUpdate(array('max' => 'yesterday')); // WHERE date_update > '2011-03-13'
     * </code>
     *
     * @param     mixed $dateUpdate The value to use as filter.
     *              Values can be integers (unix timestamps), DateTime objects, or strings.
     *              Empty strings are treated as NULL.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPricelistSheetQuery The current query, for fluid interface
     */
    public function filterByDateUpdate($dateUpdate = null, $comparison = null)
    {
        if (is_array($dateUpdate)) {
            $useMinMax = false;
            if (isset($dateUpdate['min'])) {
                $this->addUsingAlias(PricelistSheetTableMap::COL_DATE_UPDATE, $dateUpdate['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($dateUpdate['max'])) {
                $this->addUsingAlias(PricelistSheetTableMap::COL_DATE_UPDATE, $dateUpdate['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PricelistSheetTableMap::COL_DATE_UPDATE, $dateUpdate, $comparison);
    }

    /**
     * Filter the query on the pricelist_file_id column
     *
     * Example usage:
     * <code>
     * $query->filterByPricelistFileId(1234); // WHERE pricelist_file_id = 1234
     * $query->filterByPricelistFileId(array(12, 34)); // WHERE pricelist_file_id IN (12, 34)
     * $query->filterByPricelistFileId(array('min' => 12)); // WHERE pricelist_file_id > 12
     * </code>
     *
     * @see       filterByPricelistFile()
     *
     * @param     mixed $pricelistFileId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPricelistSheetQuery The current query, for fluid interface
     */
    public function filterByPricelistFileId($pricelistFileId = null, $comparison = null)
    {
        if (is_array($pricelistFileId)) {
            $useMinMax = false;
            if (isset($pricelistFileId['min'])) {
                $this->addUsingAlias(PricelistSheetTableMap::COL_PRICELIST_FILE_ID, $pricelistFileId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($pricelistFileId['max'])) {
                $this->addUsingAlias(PricelistSheetTableMap::COL_PRICELIST_FILE_ID, $pricelistFileId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PricelistSheetTableMap::COL_PRICELIST_FILE_ID, $pricelistFileId, $comparison);
    }

    /**
     * Filter the query on the crrency_id column
     *
     * Example usage:
     * <code>
     * $query->filterByCurrencyId(1234); // WHERE crrency_id = 1234
     * $query->filterByCurrencyId(array(12, 34)); // WHERE crrency_id IN (12, 34)
     * $query->filterByCurrencyId(array('min' => 12)); // WHERE crrency_id > 12
     * </code>
     *
     * @see       filterByCurrency()
     *
     * @param     mixed $currencyId The value to use as filter.
     *              Use scalar values for equality.
     *              Use array values for in_array() equivalent.
     *              Use associative array('min' => $minValue, 'max' => $maxValue) for intervals.
     * @param     string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return $this|ChildPricelistSheetQuery The current query, for fluid interface
     */
    public function filterByCurrencyId($currencyId = null, $comparison = null)
    {
        if (is_array($currencyId)) {
            $useMinMax = false;
            if (isset($currencyId['min'])) {
                $this->addUsingAlias(PricelistSheetTableMap::COL_CRRENCY_ID, $currencyId['min'], Criteria::GREATER_EQUAL);
                $useMinMax = true;
            }
            if (isset($currencyId['max'])) {
                $this->addUsingAlias(PricelistSheetTableMap::COL_CRRENCY_ID, $currencyId['max'], Criteria::LESS_EQUAL);
                $useMinMax = true;
            }
            if ($useMinMax) {
                return $this;
            }
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }
        }

        return $this->addUsingAlias(PricelistSheetTableMap::COL_CRRENCY_ID, $currencyId, $comparison);
    }

    /**
     * Filter the query by a related \Shop\Models\PricelistFile\PricelistFile object
     *
     * @param \Shop\Models\PricelistFile\PricelistFile|ObjectCollection $pricelistFile The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildPricelistSheetQuery The current query, for fluid interface
     */
    public function filterByPricelistFile($pricelistFile, $comparison = null)
    {
        if ($pricelistFile instanceof \Shop\Models\PricelistFile\PricelistFile) {
            return $this
                ->addUsingAlias(PricelistSheetTableMap::COL_PRICELIST_FILE_ID, $pricelistFile->getId(), $comparison);
        } elseif ($pricelistFile instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(PricelistSheetTableMap::COL_PRICELIST_FILE_ID, $pricelistFile->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByPricelistFile() only accepts arguments of type \Shop\Models\PricelistFile\PricelistFile or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the PricelistFile relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildPricelistSheetQuery The current query, for fluid interface
     */
    public function joinPricelistFile($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('PricelistFile');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'PricelistFile');
        }

        return $this;
    }

    /**
     * Use the PricelistFile relation PricelistFile object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\PricelistFile\PricelistFileQuery A secondary query class using the current class as primary query
     */
    public function usePricelistFileQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPricelistFile($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'PricelistFile', '\Shop\Models\PricelistFile\PricelistFileQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Currency\Currency object
     *
     * @param \Shop\Models\Currency\Currency|ObjectCollection $currency The related object(s) to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @throws \Propel\Runtime\Exception\PropelException
     *
     * @return ChildPricelistSheetQuery The current query, for fluid interface
     */
    public function filterByCurrency($currency, $comparison = null)
    {
        if ($currency instanceof \Shop\Models\Currency\Currency) {
            return $this
                ->addUsingAlias(PricelistSheetTableMap::COL_CRRENCY_ID, $currency->getId(), $comparison);
        } elseif ($currency instanceof ObjectCollection) {
            if (null === $comparison) {
                $comparison = Criteria::IN;
            }

            return $this
                ->addUsingAlias(PricelistSheetTableMap::COL_CRRENCY_ID, $currency->toKeyValue('PrimaryKey', 'Id'), $comparison);
        } else {
            throw new PropelException('filterByCurrency() only accepts arguments of type \Shop\Models\Currency\Currency or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Currency relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildPricelistSheetQuery The current query, for fluid interface
     */
    public function joinCurrency($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Currency');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Currency');
        }

        return $this;
    }

    /**
     * Use the Currency relation Currency object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Currency\CurrencyQuery A secondary query class using the current class as primary query
     */
    public function useCurrencyQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinCurrency($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Currency', '\Shop\Models\Currency\CurrencyQuery');
    }

    /**
     * Filter the query by a related \MoySklad\Models\MoySkladTask\MoySkladTask object
     *
     * @param \MoySklad\Models\MoySkladTask\MoySkladTask|ObjectCollection $moySkladTask the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildPricelistSheetQuery The current query, for fluid interface
     */
    public function filterByMoySkladTask($moySkladTask, $comparison = null)
    {
        if ($moySkladTask instanceof \MoySklad\Models\MoySkladTask\MoySkladTask) {
            return $this
                ->addUsingAlias(PricelistSheetTableMap::COL_ID, $moySkladTask->getPricelistSheetId(), $comparison);
        } elseif ($moySkladTask instanceof ObjectCollection) {
            return $this
                ->useMoySkladTaskQuery()
                ->filterByPrimaryKeys($moySkladTask->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByMoySkladTask() only accepts arguments of type \MoySklad\Models\MoySkladTask\MoySkladTask or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the MoySkladTask relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildPricelistSheetQuery The current query, for fluid interface
     */
    public function joinMoySkladTask($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('MoySkladTask');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'MoySkladTask');
        }

        return $this;
    }

    /**
     * Use the MoySkladTask relation MoySkladTask object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \MoySklad\Models\MoySkladTask\MoySkladTaskQuery A secondary query class using the current class as primary query
     */
    public function useMoySkladTaskQuery($relationAlias = null, $joinType = Criteria::LEFT_JOIN)
    {
        return $this
            ->joinMoySkladTask($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'MoySkladTask', '\MoySklad\Models\MoySkladTask\MoySkladTaskQuery');
    }

    /**
     * Filter the query by a related \Shop\Models\Position\Position object
     *
     * @param \Shop\Models\Position\Position|ObjectCollection $position the related object to use as filter
     * @param string $comparison Operator to use for the column comparison, defaults to Criteria::EQUAL
     *
     * @return ChildPricelistSheetQuery The current query, for fluid interface
     */
    public function filterByPosition($position, $comparison = null)
    {
        if ($position instanceof \Shop\Models\Position\Position) {
            return $this
                ->addUsingAlias(PricelistSheetTableMap::COL_ID, $position->getPricelistSheetId(), $comparison);
        } elseif ($position instanceof ObjectCollection) {
            return $this
                ->usePositionQuery()
                ->filterByPrimaryKeys($position->getPrimaryKeys())
                ->endUse();
        } else {
            throw new PropelException('filterByPosition() only accepts arguments of type \Shop\Models\Position\Position or Collection');
        }
    }

    /**
     * Adds a JOIN clause to the query using the Position relation
     *
     * @param     string $relationAlias optional alias for the relation
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return $this|ChildPricelistSheetQuery The current query, for fluid interface
     */
    public function joinPosition($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        $tableMap = $this->getTableMap();
        $relationMap = $tableMap->getRelation('Position');

        // create a ModelJoin object for this join
        $join = new ModelJoin();
        $join->setJoinType($joinType);
        $join->setRelationMap($relationMap, $this->useAliasInSQL ? $this->getModelAlias() : null, $relationAlias);
        if ($previousJoin = $this->getPreviousJoin()) {
            $join->setPreviousJoin($previousJoin);
        }

        // add the ModelJoin to the current object
        if ($relationAlias) {
            $this->addAlias($relationAlias, $relationMap->getRightTable()->getName());
            $this->addJoinObject($join, $relationAlias);
        } else {
            $this->addJoinObject($join, 'Position');
        }

        return $this;
    }

    /**
     * Use the Position relation Position object
     *
     * @see useQuery()
     *
     * @param     string $relationAlias optional alias for the relation,
     *                                   to be used as main alias in the secondary query
     * @param     string $joinType Accepted values are null, 'left join', 'right join', 'inner join'
     *
     * @return \Shop\Models\Position\PositionQuery A secondary query class using the current class as primary query
     */
    public function usePositionQuery($relationAlias = null, $joinType = Criteria::INNER_JOIN)
    {
        return $this
            ->joinPosition($relationAlias, $joinType)
            ->useQuery($relationAlias ? $relationAlias : 'Position', '\Shop\Models\Position\PositionQuery');
    }

    /**
     * Exclude object from result
     *
     * @param   ChildPricelistSheet $pricelistSheet Object to remove from the list of results
     *
     * @return $this|ChildPricelistSheetQuery The current query, for fluid interface
     */
    public function prune($pricelistSheet = null)
    {
        if ($pricelistSheet) {
            $this->addUsingAlias(PricelistSheetTableMap::COL_ID, $pricelistSheet->getId(), Criteria::NOT_EQUAL);
        }

        return $this;
    }

    /**
     * Deletes all rows from the shop_pricelist_sheets table.
     *
     * @param ConnectionInterface $con the connection to use
     * @return int The number of affected rows (if supported by underlying database driver).
     */
    public function doDeleteAll(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PricelistSheetTableMap::DATABASE_NAME);
        }

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con) {
            $affectedRows = 0; // initialize var to track total num of affected rows
            $affectedRows += parent::doDeleteAll($con);
            // Because this db requires some delete cascade/set null emulation, we have to
            // clear the cached instance *after* the emulation has happened (since
            // instances get re-added by the select statement contained therein).
            PricelistSheetTableMap::clearInstancePool();
            PricelistSheetTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

    /**
     * Performs a DELETE on the database based on the current ModelCriteria
     *
     * @param ConnectionInterface $con the connection to use
     * @return int             The number of affected rows (if supported by underlying database driver).  This includes CASCADE-related rows
     *                         if supported by native driver or if emulated using Propel.
     * @throws PropelException Any exceptions caught during processing will be
     *                         rethrown wrapped into a PropelException.
     */
    public function delete(ConnectionInterface $con = null)
    {
        if (null === $con) {
            $con = Propel::getServiceContainer()->getWriteConnection(PricelistSheetTableMap::DATABASE_NAME);
        }

        $criteria = $this;

        // Set the correct dbName
        $criteria->setDbName(PricelistSheetTableMap::DATABASE_NAME);

        // use transaction because $criteria could contain info
        // for more than one table or we could emulating ON DELETE CASCADE, etc.
        return $con->transaction(function () use ($con, $criteria) {
            $affectedRows = 0; // initialize var to track total num of affected rows

            PricelistSheetTableMap::removeInstanceFromPool($criteria);

            $affectedRows += ModelCriteria::delete($con);
            PricelistSheetTableMap::clearRelatedInstancePool();

            return $affectedRows;
        });
    }

} // PricelistSheetQuery
